/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.network.c2s;

import fabric.net.mca.cobalt.network.Message;
import fabric.net.mca.server.world.data.Building;
import fabric.net.mca.server.world.data.GraveyardManager;
import fabric.net.mca.server.world.data.Village;
import fabric.net.mca.server.world.data.VillageManager;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

public class ReportBuildingMessage
implements Message {
    private static final long serialVersionUID = 3510050513221709603L;
    private final Action action;
    private final String data;

    public ReportBuildingMessage(Action action, String data) {
        this.action = action;
        this.data = data;
    }

    public ReportBuildingMessage(Action action) {
        this(action, null);
    }

    @Override
    public void receive(class_3222 player) {
        VillageManager villages = VillageManager.get(player.method_14220());
        switch (this.action) {
            case ADD: 
            case ADD_ROOM: {
                Building.validationResult result = villages.processBuilding(player.method_24515(), true, this.action == Action.ADD_ROOM);
                player.method_7353((class_2561)new class_2588("blueprint.scan." + result.name().toLowerCase(Locale.ENGLISH)), true);
                GraveyardManager.get(player.method_14220()).reportToVillageManager((class_1297)player);
                break;
            }
            case AUTO_SCAN: {
                villages.findNearestVillage((class_1297)player).ifPresent(Village::toggleAutoScan);
                break;
            }
            case FULL_SCAN: {
                villages.findNearestVillage((class_1297)player).ifPresent(buildings -> new ArrayList<Building>(buildings.getBuildings().values()).forEach(b -> villages.processBuilding(b.getCenter(), true, false)));
                break;
            }
            case FORCE_TYPE: 
            case REMOVE: {
                Optional<Village> village = villages.findNearestVillage((class_1297)player);
                Optional building = village.flatMap(v -> v.getBuildings().values().stream().filter(b -> b.containsPos((class_2382)player.method_24515())).findAny());
                if (building.isPresent()) {
                    if (this.action == Action.FORCE_TYPE) {
                        if (((Building)building.get()).getType().equals(this.data)) {
                            ((Building)building.get()).determineType();
                            break;
                        }
                        ((Building)building.get()).setForcedType(this.data);
                        break;
                    }
                    village.get().removeBuilding(((Building)building.get()).getId());
                    village.get().markDirty(player.method_14220());
                    break;
                }
                player.method_7353((class_2561)new class_2588("blueprint.noBuilding"), true);
            }
        }
    }

    public static enum Action {
        AUTO_SCAN,
        ADD_ROOM,
        ADD,
        REMOVE,
        FORCE_TYPE,
        FULL_SCAN;

    }
}

