/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.network.c2s;

import fabric.net.mca.MCA;
import fabric.net.mca.cobalt.network.Message;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.VillagerLike;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.entity.ai.relationship.family.FamilyTree;
import fabric.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import fabric.net.mca.network.NbtDataMessage;
import fabric.net.mca.network.c2s.GetVillagerRequest;
import fabric.net.mca.network.s2c.PlayerDataMessage;
import fabric.net.mca.resources.ClothingList;
import fabric.net.mca.resources.HairList;
import fabric.net.mca.server.world.data.PlayerSaveData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;

public class VillagerEditorSyncRequest
extends NbtDataMessage
implements Message {
    private static final long serialVersionUID = -5581564927127176555L;
    private final String command;
    private final UUID uuid;

    public VillagerEditorSyncRequest(String command, UUID uuid, class_2487 data) {
        super(data);
        this.command = command;
        this.uuid = uuid;
    }

    private void setHair(class_3222 player, class_1297 entity) {
        class_2487 villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String hair = this.getData().method_10545("offset") ? HairList.getInstance().getPool(this.getGender(villagerData)).pickNext(villagerData.method_10558("hair"), this.getData().method_10550("offset")) : HairList.getInstance().getPool(this.getGender(villagerData)).pickOne();
            villagerData.method_10582("hair", hair);
            this.saveEntity(player, entity, villagerData);
        }
    }

    private void setClothing(class_3222 player, class_1297 entity) {
        class_2487 villagerData = GetVillagerRequest.getVillagerData(entity);
        if (villagerData != null) {
            String clothes = "mca:missing";
            if (entity instanceof class_1657) {
                clothes = this.getData().method_10545("offset") ? ClothingList.getInstance().getPool(this.getGender(villagerData), class_3852.field_17051).pickNext(villagerData.method_10558("clothes"), this.getData().method_10550("offset")) : ClothingList.getInstance().getPool(this.getGender(villagerData), class_3852.field_17051).pickOne();
            } else if (entity instanceof VillagerLike) {
                VillagerLike villager = (VillagerLike)entity;
                clothes = this.getData().method_10545("offset") ? ClothingList.getInstance().getPool(villager).pickNext(villager.getClothes(), this.getData().method_10550("offset")) : ClothingList.getInstance().getPool(villager).pickOne();
            }
            villagerData.method_10582("clothes", clothes);
            this.saveEntity(player, entity, villagerData);
        }
    }

    @Override
    public void receive(class_3222 player) {
        class_1297 entity = player.method_14220().method_14190(this.uuid);
        switch (this.command) {
            case "hair": {
                this.setHair(player, entity);
                break;
            }
            case "clothing": {
                this.setClothing(player, entity);
                break;
            }
            case "gender": {
                this.setHair(player, entity);
                this.setClothing(player, entity);
                break;
            }
            case "sync": {
                this.saveEntity(player, entity, this.getData());
                break;
            }
            case "profession": {
                if (!(entity instanceof VillagerEntityMCA)) break;
                class_3852 profession = (class_3852)class_2378.field_17167.method_10223(new class_2960(this.getData().method_10558("profession")));
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.setProfession(profession);
            }
        }
        this.getData();
    }

    private void saveEntity(class_3222 player, class_1297 entity, class_2487 villagerData) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            PlayerSaveData data = PlayerSaveData.get(serverPlayer);
            data.setEntityData(villagerData);
            data.setEntityDataSet(true);
            this.syncFamilyTree(player, entity, villagerData);
            serverPlayer.method_14220().method_18456().forEach(p -> NetworkHandler.sendToPlayer(new PlayerDataMessage(player.method_5667(), villagerData), p));
        } else if (entity instanceof VillagerLike) {
            ((class_1309)entity).method_5749(villagerData);
            entity.method_18382();
            this.syncFamilyTree(player, entity, villagerData);
            if (entity instanceof VillagerEntityMCA) {
                VillagerEntityMCA villager = (VillagerEntityMCA)entity;
                villager.getResidency().getHomeBuilding().ifPresent(b -> b.updateResident((class_1297)villager));
            }
        }
    }

    private Gender getGender(class_2487 villagerData) {
        return Gender.byId(villagerData.method_10550("gender"));
    }

    private Optional<FamilyTreeNode> getFamilyNode(class_3222 player, FamilyTree tree, String name, Gender gender) {
        try {
            UUID uuid = UUID.fromString(name);
            Optional<FamilyTreeNode> node = tree.getOrEmpty(uuid);
            if (node.isPresent()) {
                player.method_7353((class_2561)new class_2588("gui.villager_editor.uuid_known", new Object[]{name, node.get().getName()}), true);
                return node;
            }
            player.method_7353((class_2561)new class_2588("gui.villager_editor.uuid_unknown", new Object[]{name}).method_27692(class_124.field_1061), true);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            List nodes = tree.getAllWithName(name).collect(Collectors.toList());
            if (nodes.isEmpty()) {
                player.method_7353((class_2561)new class_2588("gui.villager_editor.name_created", new Object[]{name}).method_27692(class_124.field_1054), true);
                return Optional.of(tree.getOrCreate(UUID.randomUUID(), name, gender));
            }
            if (nodes.size() > 1) {
                player.method_7353((class_2561)new class_2588("gui.villager_editor.name_not_unique", new Object[]{name}).method_27692(class_124.field_1061), true);
                String uuids = nodes.stream().map(FamilyTreeNode::id).map(UUID::toString).collect(Collectors.joining(", "));
                player.method_7353((class_2561)new class_2588("gui.villager_editor.list_of_ids", new Object[]{uuids}), false);
            } else {
                player.method_7353((class_2561)new class_2588("gui.villager_editor.name_unique", new Object[]{name}), true);
            }
            return Optional.ofNullable((FamilyTreeNode)nodes.get(0));
        }
    }

    private void syncFamilyTree(class_3222 player, class_1297 entity, class_2487 villagerData) {
        String name;
        FamilyTree tree = FamilyTree.get((class_3218)entity.field_6002);
        FamilyTreeNode entry = tree.getOrCreate(entity);
        entry.setGender(this.getGender(this.getData()));
        entry.setName(this.getData().method_10558("villagerName"));
        if (villagerData.method_10545("tree_father_new")) {
            name = villagerData.method_10558("tree_father_new");
            if (MCA.isBlankString(name)) {
                entry.removeFather();
            } else {
                this.getFamilyNode(player, tree, name, Gender.MALE).ifPresent(entry::setFather);
            }
        }
        if (villagerData.method_10545("tree_mother_new")) {
            name = villagerData.method_10558("tree_mother_new");
            if (MCA.isBlankString(name)) {
                entry.removeMother();
            } else {
                this.getFamilyNode(player, tree, name, Gender.FEMALE).ifPresent(entry::setMother);
            }
        }
        if (villagerData.method_10545("tree_spouse_new")) {
            name = villagerData.method_10558("tree_spouse_new");
            if (MCA.isBlankString(name)) {
                Optional.of(entry.partner()).flatMap(tree::getOrEmpty).ifPresent(node -> node.updatePartner(null, null));
                entry.updatePartner(null, null);
            } else {
                this.getFamilyNode(player, tree, name, entry.gender().opposite()).ifPresent(node -> {
                    entry.updatePartner((FamilyTreeNode)node);
                    node.updatePartner(entry);
                });
            }
        }
    }
}

