/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.resources;

import java.util.List;
import java.util.Optional;
import java.util.Random;

public interface PoolUtil {
    public static <T> Optional<T> pop(List<T> selection, Random rng) {
        return Optional.ofNullable(PoolUtil.popOne(selection, null, rng));
    }

    public static <T> T popOne(List<T> selection, T def, Random rng) {
        if (selection.isEmpty()) {
            return def;
        }
        return selection.remove(rng.nextInt(selection.size()));
    }

    public static <T> Optional<T> pick(List<T> selection, Random rng) {
        return Optional.ofNullable(PoolUtil.pickOne(selection, null, rng));
    }

    public static <T> T pickOne(List<T> selection, T def, Random rng) {
        if (selection.isEmpty()) {
            return def;
        }
        return selection.get(rng.nextInt(selection.size()));
    }

    public static <T> T pickOne(T[] selection, T def, Random rng) {
        if (selection.length == 0) {
            return def;
        }
        return selection[rng.nextInt(selection.length)];
    }
}

