/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.resources.data.dialogue;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fabric.net.mca.client.gui.Constraint;
import fabric.net.mca.resources.data.dialogue.Result;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Answer {
    private final String name;
    private final List<Constraint> constraints;
    private final List<Result> results;

    public Answer(String name, List<Constraint> constraints, List<Result> results) {
        this.name = name;
        this.constraints = constraints;
        this.results = results;
    }

    public static Answer fromJson(JsonObject json) {
        String name = json.has("name") ? json.get("name").getAsString() : "";
        List<Constraint> constraints = Constraint.fromStringList(json.has("constraints") ? json.get("constraints").getAsString() : "");
        LinkedList<Result> results = new LinkedList<Result>();
        for (JsonElement e : json.getAsJsonArray("results")) {
            results.add(Result.fromJson(e.getAsJsonObject()));
        }
        return new Answer(name, constraints, results);
    }

    public String getName() {
        return this.name;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public boolean isValidForConstraint(Set<Constraint> constraints) {
        return constraints.containsAll(this.constraints);
    }
}

