/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server;

import fabric.net.mca.Config;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.entity.ai.relationship.EntityRelationship;
import fabric.net.mca.entity.ai.relationship.Gender;
import fabric.net.mca.entity.ai.relationship.RelationshipState;
import fabric.net.mca.network.s2c.OpenDestinyGuiRequest;
import fabric.net.mca.network.s2c.ShowToastRequest;
import fabric.net.mca.server.world.data.BabyTracker;
import fabric.net.mca.server.world.data.PlayerSaveData;
import fabric.net.mca.util.compat.OptionalCompat;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

public class ServerInteractionManager {
    private static final ServerInteractionManager INSTANCE = new ServerInteractionManager();
    private final Map<UUID, List<UUID>> proposals = new HashMap<UUID, List<UUID>>();
    private final Object2LongArrayMap<UUID> procreateMap = new Object2LongArrayMap();

    private ServerInteractionManager() {
    }

    public static ServerInteractionManager getInstance() {
        return INSTANCE;
    }

    public static void launchDestiny(class_3222 player) {
        NetworkHandler.sendToPlayer(new OpenDestinyGuiRequest(player), player);
    }

    public void tick() {
        ArrayList removals = new ArrayList();
        this.procreateMap.keySet().stream().filter(k -> this.procreateMap.getLong(k) < System.currentTimeMillis()).forEach(removals::add);
        removals.forEach(arg_0 -> this.procreateMap.removeLong(arg_0));
    }

    public void onPlayerJoin(class_3222 player) {
        PlayerSaveData playerData = PlayerSaveData.get(player);
        if (!playerData.isEntityDataSet()) {
            if (Config.getInstance().launchIntoDestiny) {
                ServerInteractionManager.launchDestiny(player);
                if (player.field_13974.method_14257() == class_1934.field_9215) {
                    player.method_7336(class_1934.field_9219);
                }
            } else if (Config.getInstance().allowDestinyCommandOnce) {
                NetworkHandler.sendToPlayer(new ShowToastRequest("server.destinyNotSet.title", "server.destinyNotSet.description"), player);
            } else if (Config.getInstance().allowFullPlayerEditor) {
                NetworkHandler.sendToPlayer(new ShowToastRequest("server.playerNotCustomized.title", "server.playerNotCustomized.description"), player);
            }
        }
        if (playerData.hasMail()) {
            PlayerSaveData.showMailNotification(player);
        }
    }

    private boolean hasProposalFrom(class_3222 sender, class_3222 receiver) {
        return this.getProposalsFor(receiver).contains(sender.method_5667());
    }

    private List<UUID> getProposalsFor(class_3222 player) {
        return this.proposals.getOrDefault(player.method_5667(), new ArrayList());
    }

    private void removeProposalFor(class_3222 target, class_3222 proposer) {
        List<UUID> list = this.getProposalsFor(target);
        list.remove(proposer.method_5667());
        this.proposals.put(target.method_5667(), list);
    }

    public void listProposals(class_3222 sender) {
        List<UUID> proposals = this.getProposalsFor(sender);
        if (proposals.size() == 0) {
            this.infoMessage((class_1657)sender, (class_2554)new class_2588("server.noProposals"));
        } else {
            this.infoMessage((class_1657)sender, (class_2554)new class_2588("server.proposals"));
        }
        proposals.forEach(uuid -> {
            class_1657 player = sender.field_6002.method_18470(uuid);
            if (player != null) {
                this.infoMessage((class_1657)sender, (class_2554)new class_2585("- ").method_10852((class_2561)new class_2585(player.method_5820())));
            }
        });
    }

    public void sendProposal(class_3222 sender, class_3222 receiver) {
        if (!Config.getInstance().allowPlayerMarriage) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("notify.playerMarriage.disabled"));
            return;
        }
        if (PlayerSaveData.get(sender).isMarried()) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("server.alreadyMarried"));
            return;
        }
        if (sender == receiver) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("server.proposedToYourself"));
            return;
        }
        if (this.hasProposalFrom(sender, receiver)) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("server.sentProposal", new Object[]{receiver.method_5820()}));
        } else {
            this.successMessage((class_1657)sender, (class_2554)new class_2588("server.proposalSent", new Object[]{receiver.method_5820()}));
            this.infoMessage((class_1657)receiver, (class_2554)new class_2588("server.proposedMarriage", new Object[]{sender.method_5820()}));
            List<UUID> list = this.getProposalsFor(receiver);
            list.add(sender.method_5667());
            this.proposals.put(receiver.method_5667(), list);
        }
    }

    public void rejectProposal(class_3222 sender, class_3222 receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("server.noProposal", new Object[]{receiver.method_5476()}));
        } else {
            this.successMessage((class_1657)sender, (class_2554)new class_2588("server.proposalRejectionSent"));
            this.failMessage((class_1657)receiver, (class_2554)new class_2588("server.proposalRejected", new Object[]{sender.method_5820()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void acceptProposal(class_3222 sender, class_3222 receiver) {
        if (!this.hasProposalFrom(receiver, sender)) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("server.noProposal", new Object[]{receiver.method_5476()}));
        } else {
            this.successMessage((class_1657)receiver, (class_2554)new class_2588("server.proposalAccepted", new Object[]{sender.method_5476()}));
            PlayerSaveData.get(sender).marry((class_1297)receiver);
            PlayerSaveData.get(receiver).marry((class_1297)sender);
            this.successMessage((class_1657)sender, (class_2554)new class_2588("server.married", new Object[]{receiver.method_5476()}));
            this.successMessage((class_1657)receiver, (class_2554)new class_2588("server.married", new Object[]{sender.method_5476()}));
            this.removeProposalFor(sender, receiver);
        }
    }

    public void endMarriage(class_3222 sender) {
        EntityRelationship.of((class_1297)sender).ifPresent(senderData -> {
            if (!senderData.isMarried()) {
                this.failMessage((class_1657)sender, (class_2554)new class_2588("server.endMarriageNotMarried"));
                return;
            }
            if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
                this.failMessage((class_1657)sender, (class_2554)new class_2588("server.marriedToVillager"));
                return;
            }
            senderData.getPartnerName().ifPresent(name -> this.successMessage((class_1657)sender, (class_2554)new class_2588("server.endMarriage", new Object[]{name.getString()})));
            senderData.getPartner().ifPresent(spouse -> {
                if (spouse instanceof class_1657) {
                    class_1657 player = (class_1657)spouse;
                    this.failMessage(player, (class_2554)new class_2588("server.marriageEnded", new Object[]{sender.method_5820()}));
                }
            });
            senderData.endRelationShip(RelationshipState.SINGLE);
            senderData.getPartnerUUID().map(id -> PlayerSaveData.get(sender)).ifPresent(r -> r.endRelationShip(RelationshipState.SINGLE));
        });
    }

    public void procreate(class_3222 sender) {
        PlayerSaveData senderData = PlayerSaveData.get(sender);
        if (!senderData.isMarried()) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("server.notMarried"));
            return;
        }
        if (senderData.getRelationshipState() != RelationshipState.MARRIED_TO_PLAYER) {
            this.failMessage((class_1657)sender, (class_2554)new class_2588("server.marriedToVillager"));
            return;
        }
        BabyTracker tracker = BabyTracker.get(sender.method_14220());
        BabyTracker.Pairing pairing = tracker.getPairing(sender.method_5667(), senderData.getPartnerUUID().orElse(null));
        if (tracker.hasActiveBaby(sender.method_5667(), senderData.getPartnerUUID().orElse(null))) {
            if (((BabyTracker.Placement)((Object)pairing.locateBaby((class_1657)sender).getRight())).wasFound()) {
                this.failMessage((class_1657)sender, (class_2554)new class_2588("server.babyPresent"));
            } else {
                this.failMessage((class_1657)sender, (class_2554)new class_2588("server.babyLost"));
                pairing.reconstructBaby(sender);
            }
            return;
        }
        OptionalCompat.ifPresentOrElse(senderData.getPartner().filter(e -> e instanceof class_1657).map(class_1657.class::cast), spouse -> {
            if (!this.procreateMap.containsKey((Object)spouse.method_5667())) {
                this.procreateMap.put((Object)sender.method_5667(), System.currentTimeMillis() + 10000L);
                this.infoMessage((class_1657)spouse, (class_2554)new class_2588("server.procreationRequest", new Object[]{sender.method_5820()}));
            } else {
                this.successMessage((class_1657)sender, (class_2554)new class_2588("server.procreationSuccessful"));
                this.successMessage((class_1657)spouse, (class_2554)new class_2588("server.procreationSuccessful"));
                pairing.addChild(s -> {
                    s.setGender(Gender.getRandom());
                    s.setOwner((class_1297)sender);
                    spouse.method_7270(s.createItem());
                });
            }
        }, () -> this.failMessage((class_1657)sender, (class_2554)new class_2588("server.spouseNotPresent")));
    }

    private void successMessage(class_1657 player, class_2554 message) {
        player.method_9203((class_2561)message.method_27692(class_124.field_1060), class_156.field_25140);
    }

    private void failMessage(class_1657 player, class_2554 message) {
        player.method_9203((class_2561)message.method_27692(class_124.field_1061), class_156.field_25140);
    }

    private void infoMessage(class_1657 player, class_2554 message) {
        player.method_9203((class_2561)message.method_27692(class_124.field_1054), class_156.field_25140);
    }
}

