/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.server.world.data;

import fabric.net.mca.Config;
import fabric.net.mca.resources.API;
import fabric.net.mca.resources.data.BuildingType;
import fabric.net.mca.util.NbtHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4158;

public class Building
implements Serializable,
Iterable<UUID> {
    private static final long serialVersionUID = -1106627083469687307L;
    public static final long SCAN_COOLDOWN = 4800L;
    private static final class_2350[] directions = new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    private final Map<UUID, String> residents = new HashMap<UUID, String>();
    private final Map<class_2960, List<class_2338>> blocks = new HashMap<class_2960, List<class_2338>>();
    private String type = "building";
    private String forcedType = null;
    private int size;
    private int pos0X;
    private int pos0Y;
    private int pos0Z;
    private int pos1X;
    private int pos1Y;
    private int pos1Z;
    private int posX;
    private int posY;
    private int posZ;
    private int id;
    private boolean strictScan;
    private long lastScan;

    public Building() {
    }

    public Building(class_2338 pos) {
        this(pos, false);
    }

    public Building(class_2338 pos, boolean strictScan) {
        this();
        this.pos0X = pos.method_10263();
        this.pos0Y = pos.method_10264();
        this.pos0Z = pos.method_10260();
        this.pos1X = this.pos0X;
        this.pos1Y = this.pos0Y;
        this.pos1Z = this.pos0Z;
        this.posX = this.pos0X;
        this.posY = this.pos0Y;
        this.posZ = this.pos0Z;
        this.strictScan = strictScan;
    }

    public Building(class_2487 v) {
        this.id = v.method_10550("id");
        this.size = v.method_10550("size");
        this.pos0X = v.method_10550("pos0X");
        this.pos0Y = v.method_10550("pos0Y");
        this.pos0Z = v.method_10550("pos0Z");
        this.pos1X = v.method_10550("pos1X");
        this.pos1Y = v.method_10550("pos1Y");
        this.pos1Z = v.method_10550("pos1Z");
        if (v.method_10545("posX")) {
            this.posX = v.method_10550("posX");
            this.posY = v.method_10550("posY");
            this.posZ = v.method_10550("posZ");
        } else {
            class_2338 center = this.getCenter();
            this.posX = center.method_10263();
            this.posY = center.method_10264();
            this.posZ = center.method_10260();
        }
        this.forcedType = v.method_10545("forced_type") ? v.method_10558("forced_type") : null;
        this.type = this.forcedType != null ? this.forcedType : v.method_10558("type");
        this.strictScan = v.method_10577("strictScan");
        class_2499 res = v.method_10554("residents", 10);
        for (int i = 0; i < res.size(); ++i) {
            class_2487 c = res.method_10602(i);
            this.residents.put(c.method_25926("uuid"), c.method_10558("name"));
        }
        this.blocks.putAll(NbtHelper.toMap(v.method_10562("blocks2"), class_2960::new, l -> NbtHelper.toList(l, e -> {
            class_2487 c = (class_2487)e;
            return new class_2338(c.method_10550("x"), c.method_10550("y"), c.method_10550("z"));
        })));
    }

    public class_2487 save() {
        class_2487 v = new class_2487();
        v.method_10569("id", this.id);
        v.method_10569("size", this.size);
        v.method_10569("pos0X", this.pos0X);
        v.method_10569("pos0Y", this.pos0Y);
        v.method_10569("pos0Z", this.pos0Z);
        v.method_10569("pos1X", this.pos1X);
        v.method_10569("pos1Y", this.pos1Y);
        v.method_10569("pos1Z", this.pos1Z);
        v.method_10569("posX", this.posX);
        v.method_10569("posY", this.posY);
        v.method_10569("posZ", this.posZ);
        if (this.forcedType != null) {
            v.method_10582("forced_type", this.forcedType);
        }
        v.method_10582("type", this.type);
        v.method_10556("strictScan", this.strictScan);
        v.method_10566("residents", (class_2520)NbtHelper.fromList(this.residents.entrySet(), resident -> {
            class_2487 entry = new class_2487();
            entry.method_25927("uuid", (UUID)resident.getKey());
            entry.method_10582("name", (String)resident.getValue());
            return entry;
        }));
        class_2487 b = new class_2487();
        NbtHelper.fromMap(b, this.blocks, class_2960::toString, e -> NbtHelper.fromList(e, p -> {
            class_2487 entry = new class_2487();
            entry.method_10569("x", p.method_10263());
            entry.method_10569("y", p.method_10264());
            entry.method_10569("z", p.method_10260());
            return entry;
        }));
        v.method_10566("blocks2", (class_2520)b);
        return v;
    }

    public boolean hasFreeSpace() {
        return this.getBedCount() > this.getResidents().size();
    }

    public boolean isCrowded() {
        return this.getBedCount() < this.getResidents().size();
    }

    public Stream<class_2338> findEmptyBed(class_3218 world) {
        return world.method_19494().method_22383(class_4158.field_18517.method_19164(), this.getCenter(), this.getPos0().method_19455((class_2382)this.getPos1()), class_4153.class_4155.field_18489).filter(p -> {
            class_2680 blockState = world.method_8320(p.method_19141());
            return blockState.method_26164((class_3494)class_3481.field_16443) && (Boolean)blockState.method_11654((class_2769)class_2244.field_9968) == false;
        }).map(class_4156::method_19141).filter(this::containsPos);
    }

    public Optional<class_2338> findClosestEmptyBed(class_3218 world, class_2338 pos) {
        return this.findEmptyBed(world).min(Comparator.comparingInt(a -> a.method_19455((class_2382)pos)));
    }

    public void addResident(class_1297 e) {
        if (!this.residents.containsKey(e.method_5667())) {
            this.residents.put(e.method_5667(), e.method_5477().getString());
        }
    }

    public void updateResident(class_1297 e) {
        if (this.residents.containsKey(e.method_5667())) {
            this.residents.put(e.method_5667(), e.method_5477().getString());
        }
    }

    public class_2338 getPos0() {
        return new class_2338(this.pos0X, this.pos0Y, this.pos0Z);
    }

    public class_2338 getPos1() {
        return new class_2338(this.pos1X, this.pos1Y, this.pos1Z);
    }

    public class_2338 getCenter() {
        return new class_2338((this.pos0X + this.pos1X) / 2, (this.pos0Y + this.pos1Y) / 2, (this.pos0Z + this.pos1Z) / 2);
    }

    public class_2338 getSourceBlock() {
        return new class_2338(this.posX, this.posY, this.posZ);
    }

    public void validateBlocks(class_1937 world) {
        this.setLastScan(world.method_8510());
        for (Map.Entry<class_2960, List<class_2338>> positions : this.blocks.entrySet()) {
            List mask = positions.getValue().stream().filter(p -> !class_2378.field_11146.method_10221((Object)world.method_8320(p).method_26204()).equals(positions.getKey())).collect(Collectors.toList());
            positions.getValue().removeAll(mask);
        }
    }

    public Stream<class_2338> getBlockPosStream() {
        return this.blocks.values().stream().flatMap(Collection::stream);
    }

    public void addPOI(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        this.removeBlock(block, pos);
        this.addBlock(block, pos);
        this.validateBlocks(world);
        int n = (int)this.getBlockPosStream().count();
        if (n > 0) {
            class_2338 center = this.getBlockPosStream().reduce(class_2338.field_10980, class_2338::method_10081);
            this.pos0X = center.method_10263() / n;
            this.pos0Y = center.method_10264() / n;
            this.pos0Z = center.method_10260() / n;
            this.pos1X = this.pos0X;
            this.pos1Y = this.pos0Y;
            this.pos1Z = this.pos0Z;
        }
    }

    public validationResult validateBuilding(class_1937 world, Set<class_2338> blocked) {
        class_2680 block;
        this.blocks.clear();
        this.size = 0;
        this.setLastScan(world.method_8510());
        HashSet<class_2338> done = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        class_2338 center = this.getSourceBlock();
        queue.add(center);
        done.add(center);
        int minSize = Config.getInstance().minBuildingSize;
        int maxSize = Config.getInstance().maxBuildingSize;
        int maxRadius = Config.getInstance().maxBuildingRadius;
        int interiorSize = 0;
        boolean hasDoor = false;
        HashMap<class_2338, Boolean> roofCache = new HashMap<class_2338, Boolean>();
        for (int scanSize = 0; !queue.isEmpty() && scanSize < maxSize; ++scanSize) {
            class_2338 p = (class_2338)queue.removeLast();
            if (blocked.contains(p) && scanSize > 0) {
                return validationResult.OVERLAP;
            }
            if (p.method_19455((class_2382)center) < maxRadius) {
                for (class_2350 d : directions) {
                    class_2338 n = p.method_10093(d);
                    if (done.contains(n)) continue;
                    class_2680 state = world.method_8320(n);
                    done.add(n);
                    if (state.method_26215()) {
                        if (!roofCache.containsKey(n)) {
                            class_2338 n2 = n;
                            int maxScanHeight = 16;
                            for (int i = 0; i < maxScanHeight; ++i) {
                                roofCache.put(n2, false);
                                n2 = n2.method_10084();
                                block = world.method_8320(n2);
                                if (block.method_26215() && !roofCache.containsKey(n2)) continue;
                                if (roofCache.containsKey(n2) && !((Boolean)roofCache.get(n2)).booleanValue() || block.method_26164((class_3494)class_3481.field_15503)) break;
                                for (int i2 = i; i2 >= 0; --i2) {
                                    n2 = n2.method_10074();
                                    roofCache.put(n2, true);
                                }
                                break;
                            }
                        }
                        if (!((Boolean)roofCache.get(n)).booleanValue()) continue;
                        ++interiorSize;
                        queue.add(n);
                        continue;
                    }
                    if (!(state.method_26204() instanceof class_2323)) continue;
                    if (!this.strictScan) {
                        queue.add(n);
                    }
                    hasDoor = true;
                }
                continue;
            }
            return validationResult.SIZE_LIMIT;
        }
        if (!queue.isEmpty()) {
            return validationResult.BLOCK_LIMIT;
        }
        if (done.size() <= minSize) {
            return validationResult.TOO_SMALL;
        }
        if (!hasDoor) {
            return validationResult.NO_DOOR;
        }
        HashSet<class_2960> blockTypes = new HashSet<class_2960>();
        for (BuildingType bt : API.getVillagePool()) {
            blockTypes.addAll(bt.getBlockToGroup().keySet());
        }
        int sx = center.method_10263();
        int sy = center.method_10264();
        int sz = center.method_10260();
        int ex = sx;
        int ey = sy;
        int ez = sz;
        for (class_2338 p : done) {
            sx = Math.min(sx, p.method_10263());
            sy = Math.min(sy, p.method_10264());
            sz = Math.min(sz, p.method_10260());
            ex = Math.max(ex, p.method_10263());
            ey = Math.max(ey, p.method_10264());
            ez = Math.max(ez, p.method_10260());
            class_2680 blockState = world.method_8320(p);
            block = blockState.method_26204();
            if (!blockTypes.contains(class_2378.field_11146.method_10221((Object)block))) continue;
            if (block instanceof class_2244) {
                if (blockState.method_11654((class_2769)class_2244.field_9967) != class_2742.field_12560) continue;
                this.addBlock((class_2248)block, p);
                continue;
            }
            this.addBlock((class_2248)block, p);
        }
        this.pos0X = sx;
        this.pos0Y = sy;
        this.pos0Z = sz;
        this.pos1X = ex;
        this.pos1Y = ey;
        this.pos1Z = ez;
        this.size = interiorSize;
        boolean assignedType = false;
        if (!this.type.equals("blocked")) {
            assignedType = this.determineType();
        }
        return assignedType ? validationResult.SUCCESS : validationResult.INVALID_TYPE;
    }

    public boolean determineType() {
        int bestPriority = -1;
        boolean assignedType = false;
        for (BuildingType bt : API.getVillagePool()) {
            boolean checkingForcedType;
            boolean bl = checkingForcedType = this.forcedType != null && this.forcedType.equalsIgnoreCase(bt.name());
            if (!checkingForcedType && bt.priority() <= bestPriority || this.size < bt.size()) continue;
            Map<class_2960, List<class_2338>> available = bt.getGroups(this.blocks);
            boolean valid = bt.getGroups().entrySet().stream().noneMatch(e -> !available.containsKey(e.getKey()) || ((List)available.get(e.getKey())).size() < (Integer)e.getValue());
            if (valid) {
                bestPriority = bt.priority();
                this.type = bt.name();
                assignedType = true;
                if (!checkingForcedType) continue;
                break;
            }
            if (!checkingForcedType) continue;
            assignedType = false;
        }
        return assignedType;
    }

    public String getType() {
        return this.type;
    }

    public String getForcedType() {
        return this.forcedType;
    }

    public BuildingType getBuildingType() {
        return API.getVillagePool().getBuildingType(this.type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setForcedType(String type) {
        this.forcedType = type;
    }

    public Map<UUID, String> getResidents() {
        return this.residents;
    }

    @Override
    public Iterator<UUID> iterator() {
        return this.residents.keySet().iterator();
    }

    public boolean hasResident(UUID id) {
        return this.residents.containsKey(id);
    }

    public Map<class_2960, List<class_2338>> getBlocks() {
        return this.blocks;
    }

    public void addBlock(class_2248 block, class_2338 p) {
        class_2960 key = class_2378.field_11146.method_10221((Object)block);
        if (!this.blocks.containsKey(key)) {
            this.blocks.put(key, new ArrayList());
        }
        this.blocks.get(key).add(p);
    }

    public void removeBlock(class_2248 block, class_2338 p) {
        class_2960 key = class_2378.field_11146.method_10221((Object)block);
        if (this.blocks.containsKey(key)) {
            this.blocks.get(key).remove(p);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean overlaps(Building b) {
        return this.pos1X > b.pos0X && this.pos0X < b.pos1X && this.pos1Y > b.pos0Y && this.pos0Y < b.pos1Y && this.pos1Z > b.pos0Z && this.pos0Z < b.pos1Z;
    }

    public boolean containsPos(class_2382 pos) {
        return pos.method_10263() >= this.pos0X && pos.method_10263() <= this.pos1X && pos.method_10264() >= this.pos0Y && pos.method_10264() <= this.pos1Y && pos.method_10260() >= this.pos0Z && pos.method_10260() <= this.pos1Z;
    }

    public boolean isIdentical(Building b) {
        return this.pos0X == b.pos0X && this.pos1X == b.pos1X && this.pos0Y == b.pos0Y && this.pos1Y == b.pos1Y && this.pos0Z == b.pos0Z && this.pos1Z == b.pos1Z;
    }

    public int getBedCount() {
        return this.getBlocksOfGroup(new class_2960("minecraft:beds")).size();
    }

    @Deprecated
    public List<class_2338> getBlocksOfGroup(class_2960 i) {
        Map<class_2960, List<class_2338>> groups = API.getVillagePool().getBuildingType("?").getGroups(this.blocks);
        return groups.getOrDefault(i, new ArrayList());
    }

    public int getSize() {
        return this.size;
    }

    public long getLastScan() {
        return this.lastScan;
    }

    public void setLastScan(long lastScan) {
        this.lastScan = lastScan;
    }

    public static enum validationResult {
        OVERLAP,
        BLOCK_LIMIT,
        SIZE_LIMIT,
        NO_DOOR,
        TOO_SMALL,
        IDENTICAL,
        SUCCESS,
        INVALID_TYPE;

    }
}

