/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.util.compat.model;

import fabric.net.mca.util.compat.model.Dilation;
import fabric.net.mca.util.compat.model.ModelPartCompat;
import fabric.net.mca.util.compat.model.ModelPartData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelPartBuilder {
    private boolean mirror;
    private int u;
    private int v;
    final ModelPartCompat part = new ModelPartCompat();
    private final List<Runnable> cuboids = new ArrayList<Runnable>();
    final Map<String, ModelPartData> children = new HashMap<String, ModelPartData>();

    public static ModelPartBuilder create() {
        return new ModelPartBuilder();
    }

    public ModelPartBuilder uv(int u, int v) {
        this.u = u;
        this.v = v;
        return this;
    }

    public ModelPartBuilder cuboid(float x, float y, float z, float w, float h, float d, Dilation dilation, float textureScaleX, float textureScaleY) {
        boolean mirror = this.mirror;
        int u = this.u;
        int v = this.v;
        this.cuboids.add(() -> {
            int texW = this.part.getTextureWidth();
            int texH = this.part.getTextureHeight();
            this.part.method_2850(u, v);
            this.part.method_2853((int)((float)texW * textureScaleX), (int)((float)texH * textureScaleY));
            this.part.method_2849(x, y, z, w, h, d, dilation.value, mirror);
            this.part.method_2853(texW, texH);
        });
        return this;
    }

    public ModelPartBuilder cuboid(float x, float y, float z, float w, float h, float d, Dilation dilation) {
        return this.cuboid(x, y, z, w, h, d, dilation, 1.0f, 1.0f);
    }

    public ModelPartBuilder mirrored() {
        this.mirror = true;
        return this;
    }

    ModelPartCompat build(int textureWidth, int textureHeight) {
        this.part.method_2853(textureWidth, textureHeight);
        this.cuboids.forEach(Runnable::run);
        this.children.values().forEach(v -> v.builder.build(textureWidth, textureHeight));
        return this.part;
    }
}

