/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.util.localization;

import fabric.net.mca.resources.PoolUtil;
import fabric.net.mca.util.localization.TemplateSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PooledTranslationStorage {
    private static final Pattern TRAILING_NUMBERS_PATTERN = Pattern.compile("/[0-9]+$");
    private static final Predicate<String> TRAILING_NUMBERS_PREDICATE = TRAILING_NUMBERS_PATTERN.asPredicate();
    private final Map<String, List<String>> multiTranslations = new HashMap<String, List<String>>();
    private final Random rand = new Random();

    public PooledTranslationStorage(Map<String, String> translations) {
        translations.forEach(this::addTranslation);
    }

    private void addTranslation(String key, String value) {
        if (TRAILING_NUMBERS_PREDICATE.test(key)) {
            this.multiTranslations.computeIfAbsent(TRAILING_NUMBERS_PATTERN.matcher(key).replaceAll(""), k -> new ArrayList()).add(value);
        }
    }

    @NotNull
    private List<String> getOptions(String key) {
        return this.multiTranslations.getOrDefault(key, Collections.emptyList());
    }

    @Nullable
    public String get(String key) {
        List<String> options = this.getOptions(key);
        if (!options.isEmpty()) {
            return TemplateSet.INSTANCE.replace(PoolUtil.pickOne(options, key, this.rand));
        }
        return null;
    }

    public boolean contains(String key) {
        return !this.getOptions(key).isEmpty();
    }
}

