/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca;

import com.google.common.collect.ImmutableSet;
import forge.net.mca.entity.ai.PointOfInterestTypeMCA;
import forge.net.mca.mixin.MixinVillagerProfession;
import java.util.HashSet;
import java.util.Set;
import me.shedaniel.architectury.registry.DeferredRegister;
import me.shedaniel.architectury.registry.RegistrySupplier;
import net.minecraft.block.Block;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestType;
import org.jetbrains.annotations.Nullable;

public interface ProfessionsMCA {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((String)"mca", (RegistryKey)Registry.field_239683_U_);
    public static final RegistrySupplier<VillagerProfession> OUTLAW = ProfessionsMCA.register("outlaw", false, true, true, PointOfInterestType.field_221054_b, SoundEvents.field_219698_mF);
    public static final RegistrySupplier<VillagerProfession> GUARD = ProfessionsMCA.register("guard", false, true, false, PointOfInterestType.field_221054_b, SoundEvents.field_219694_mB);
    public static final RegistrySupplier<VillagerProfession> ARCHER = ProfessionsMCA.register("archer", false, true, false, PointOfInterestType.field_221054_b, SoundEvents.field_219700_mH);
    public static final RegistrySupplier<VillagerProfession> ADVENTURER = ProfessionsMCA.register("adventurer", true, true, true, PointOfInterestType.field_221054_b, SoundEvents.field_219700_mH);
    public static final RegistrySupplier<VillagerProfession> MERCENARY = ProfessionsMCA.register("mercenary", false, true, true, PointOfInterestType.field_221054_b, SoundEvents.field_219700_mH);
    public static final RegistrySupplier<VillagerProfession> CULTIST = ProfessionsMCA.register("cultist", true, true, true, PointOfInterestType.field_221054_b, SoundEvents.field_219700_mH);
    public static final Set<VillagerProfession> canNotTrade = new HashSet<VillagerProfession>();
    public static final Set<VillagerProfession> isImportant = new HashSet<VillagerProfession>();
    public static final Set<VillagerProfession> needsNoHome = new HashSet<VillagerProfession>();

    public static void bootstrap() {
        PROFESSIONS.register();
        PointOfInterestTypeMCA.bootstrap();
        canNotTrade.add(VillagerProfession.field_221151_a);
        canNotTrade.add(VillagerProfession.field_221162_l);
    }

    public static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, PointOfInterestType workStation, @Nullable SoundEvent workSound) {
        return ProfessionsMCA.register(name, canTradeWith, important, needsNoHome, workStation, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), workSound);
    }

    public static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, boolean important, boolean needsNoHome, PointOfInterestType workStation, ImmutableSet<Item> gatherableItems, ImmutableSet<Block> secondaryJobSites, @Nullable SoundEvent workSound) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return PROFESSIONS.register(id, () -> {
            VillagerProfession result = MixinVillagerProfession.init(id.toString().replace(':', '.'), workStation, gatherableItems, secondaryJobSites, workSound);
            if (!canTradeWith) {
                canNotTrade.add(result);
            }
            if (important) {
                isImportant.add(result);
            }
            if (needsNoHome) {
                ProfessionsMCA.needsNoHome.add(result);
            }
            return result;
        });
    }

    public static String getFavoredBuilding(VillagerProfession profession) {
        if (VillagerProfession.field_221154_d == profession || VillagerProfession.field_221160_j == profession || VillagerProfession.field_221155_e == profession) {
            return "library";
        }
        if (GUARD.get() == profession || ARCHER.get() == profession) {
            return "inn";
        }
        return null;
    }
}

