/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.net.mca.MCA;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class FamilyCriterion
extends AbstractCriterionTrigger<Conditions> {
    private static final ResourceLocation ID = MCA.locate("family");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public Conditions conditionsFromJson(JsonObject json, EntityPredicate.AndPredicate player, ConditionArrayParser deserializer) {
        MinMaxBounds.IntBound c = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("children"));
        MinMaxBounds.IntBound gc = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("grandchildren"));
        return new Conditions(player, c, gc);
    }

    public void trigger(ServerPlayerEntity player) {
        FamilyTreeNode familyTree = FamilyTree.get(player.func_71121_q()).getOrCreate((Entity)player);
        long c = familyTree.getRelatives(0, 1).count();
        long gc = familyTree.getRelatives(0, 2).count() - c;
        this.func_235959_a_(player, condition -> condition.test((int)c, (int)gc));
    }

    public static class Conditions
    extends CriterionInstance {
        private final MinMaxBounds.IntBound children;
        private final MinMaxBounds.IntBound grandchildren;

        public Conditions(EntityPredicate.AndPredicate player, MinMaxBounds.IntBound children, MinMaxBounds.IntBound grandchildren) {
            super(ID, player);
            this.children = children;
            this.grandchildren = grandchildren;
        }

        public boolean test(int c, int gc) {
            return this.children.func_211339_d(c) && this.grandchildren.func_211339_d(gc);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer serializer) {
            JsonObject json = super.func_230240_a_(serializer);
            json.add("children", this.children.func_200321_c());
            json.add("grandchildren", this.grandchildren.func_200321_c());
            return json;
        }
    }
}

