/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import forge.net.mca.MCA;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class HeartsCriterion
extends AbstractCriterionTrigger<Conditions> {
    private static final ResourceLocation ID = MCA.locate("hearts");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public Conditions conditionsFromJson(JsonObject json, EntityPredicate.AndPredicate player, ConditionArrayParser deserializer) {
        MinMaxBounds.IntBound hearts = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("hearts"));
        MinMaxBounds.IntBound increase = MinMaxBounds.IntBound.func_211344_a((JsonElement)json.get("increase"));
        String source = json.has("source") ? json.get("source").getAsString() : "";
        return new Conditions(player, hearts, increase, source);
    }

    public void trigger(ServerPlayerEntity player, int hearts, int increase, String source) {
        this.func_235959_a_(player, conditions -> conditions.test(hearts, increase, source));
    }

    public static class Conditions
    extends CriterionInstance {
        private final MinMaxBounds.IntBound hearts;
        private final MinMaxBounds.IntBound increase;
        private final String source;

        public Conditions(EntityPredicate.AndPredicate player, MinMaxBounds.IntBound hearts, MinMaxBounds.IntBound increase, String source) {
            super(ID, player);
            this.hearts = hearts;
            this.increase = increase;
            this.source = source;
        }

        public boolean test(int hearts, int increase, String source) {
            return this.hearts.func_211339_d(hearts) && this.increase.func_211339_d(increase) && (MCA.isBlankString(this.source) || this.source.equals(source));
        }

        public JsonObject func_230240_a_(ConditionArraySerializer serializer) {
            JsonObject json = super.func_230240_a_(serializer);
            json.add("hearts", this.hearts.func_200321_c());
            json.add("increase", this.increase.func_200321_c());
            json.add("source", (JsonElement)new JsonPrimitive(this.source));
            return json;
        }
    }
}

