/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import forge.net.mca.MCA;
import forge.net.mca.resources.Rank;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;

public class VillagerFateCriterion
extends AbstractCriterionTrigger<Conditions> {
    private static final ResourceLocation ID = MCA.locate("villager_fate");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public Conditions conditionsFromJson(JsonObject json, EntityPredicate.AndPredicate player, ConditionArrayParser deserializer) {
        Rank userRelation = Rank.fromName(json.get("user_relation").getAsString());
        ResourceLocation cause = ResourceLocation.func_208304_a((String)json.get("cause").getAsString());
        return new Conditions(player, cause, userRelation);
    }

    public void trigger(ServerPlayerEntity player, ResourceLocation cause, Rank userRelation) {
        this.func_235959_a_(player, conditions -> conditions.test(cause, userRelation));
    }

    public static class Conditions
    extends CriterionInstance {
        private final Rank userRelation;
        private final ResourceLocation cause;

        public Conditions(EntityPredicate.AndPredicate player, ResourceLocation cause, Rank userRelation) {
            super(ID, player);
            this.userRelation = userRelation;
            this.cause = cause;
        }

        public boolean test(ResourceLocation cause, Rank userRelation) {
            return this.cause.toString().equals(cause.toString()) && userRelation.isAtLeast(this.userRelation);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer serializer) {
            JsonObject json = super.func_230240_a_(serializer);
            json.add("cause", (JsonElement)new JsonPrimitive(this.cause.toString()));
            json.add("user_relation", (JsonElement)new JsonPrimitive(this.userRelation.name()));
            return json;
        }
    }
}

