/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.block;

import forge.net.mca.block.BlockEntityTypesMCA;
import forge.net.mca.block.BlocksMCA;
import forge.net.mca.entity.Infectable;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.entity.ai.relationship.EntityRelationship;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.server.world.data.GraveyardManager;
import forge.net.mca.util.NbtHelper;
import forge.net.mca.util.VoxelShapeUtil;
import forge.net.mca.util.localization.FlowingText;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class TombstoneBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final VoxelShape GRAVELLING_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    public static final VoxelShape UPRIGHT_SHAPE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)18.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)18.0, (double)2.0, (double)14.0, (double)19.0, (double)4.0), Block.func_208617_a((double)3.0, (double)19.0, (double)2.0, (double)13.0, (double)20.0, (double)4.0)});
    public static final VoxelShape CROSS_SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)28.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)-1.0, (double)18.0, (double)2.0, (double)17.0, (double)21.0, (double)4.0));
    public static final VoxelShape SLANTED_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape WALL_SHAPE = Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    private final Map<Direction, VoxelShape> shapes;
    private final int lineWidth;
    private final int maxNameHeight;
    private final Vector3d nameplateOffset;
    private final boolean requiresSolid;
    private final float rotation;

    public TombstoneBlock(AbstractBlock.Properties properties, int lineWidth, int maxNameHeight, Vector3d nameplateOffset, float rotation, boolean requiresSolid, VoxelShape baseShape) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
        this.lineWidth = lineWidth;
        this.maxNameHeight = maxNameHeight;
        this.nameplateOffset = nameplateOffset;
        this.rotation = rotation;
        this.requiresSolid = requiresSolid;
        this.shapes = Arrays.stream(Direction.values()).filter(d -> d.func_176740_k() != Direction.Axis.Y).collect(Collectors.toMap(Function.identity(), VoxelShapeUtil.rotator(baseShape)));
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getMaxNameHeight() {
        return this.maxNameHeight;
    }

    public Vector3d getNameplateOffset() {
        return this.nameplateOffset;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        if (this == BlocksMCA.SLANTED_HEADSTONE.get()) {
            this.shapes.replaceAll((i, v) -> VoxelShapeUtil.rotator(SLANTED_SHAPE).apply((Direction)i));
        }
        return this.shapes.getOrDefault(state.func_177229_b((Property)BlockStateProperties.field_208157_J), VoxelShapes.func_197868_b());
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean notify) {
        this.updateTombstoneState(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Data.of(world.func_175625_s(pos)).ifPresent(data -> data.readFromStack(stack));
        this.updateTombstoneState(world, pos);
    }

    private void updateTombstoneState(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            GraveyardManager.get((ServerWorld)world).setTombstoneState(pos, this.hasEntity((IBlockReader)world, pos) ? GraveyardManager.TombstoneState.FILLED : GraveyardManager.TombstoneState.EMPTY);
        }
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moved) {
        super.func_196243_a(state, world, pos, newState, moved);
        if (!world.field_72995_K && !state.func_203425_a(newState.func_177230_c())) {
            this.updateNeighbors(state, world, pos);
            GraveyardManager.get((ServerWorld)world).removeTombstoneState(pos);
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return ((TileEntityType)BlockEntityTypesMCA.TOMBSTONE.get()).func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y}).func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (direction == Direction.DOWN && !this.func_196260_a(state, (IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (this.requiresSolid) {
            pos = pos.func_177977_b();
            return world.func_180495_p(pos).func_242698_a((IBlockReader)world, pos, Direction.UP, BlockVoxelShape.FULL);
        }
        return true;
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    private void updateNeighbors(BlockState state, World world, BlockPos pos) {
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177972_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)), (Block)this);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        return state.func_185893_b(world, pos, direction);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        return direction == state.func_177229_b((Property)BlockStateProperties.field_208157_J) && this.hasEntity(world, pos) ? 15 : 0;
    }

    protected boolean hasEntity(IBlockReader world, BlockPos pos) {
        return Data.of(world.func_175625_s(pos)).map(Data::hasEntity).orElse(false);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        Data.of(world.func_175625_s(pos)).filter(Data::isResurrecting).ifPresent(data -> {
            for (int i = 0; i < random.nextInt(8) + 1; ++i) {
                world.func_195594_a((IParticleData)(random.nextBoolean() ? ParticleTypes.field_197594_E : ParticleTypes.field_197601_L), (double)((float)pos.func_177958_n() + random.nextFloat()), (double)((float)pos.func_177956_o() + random.nextFloat()), (double)((float)pos.func_177952_p() + random.nextFloat()), ((double)random.nextFloat() - 0.5) / 10.0, 0.0, ((double)random.nextFloat() - 0.5) / 10.0);
            }
        });
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List stacks = super.func_220076_a(state, builder);
        Optional<Data> data = Data.of((TileEntity)builder.func_216024_a(LootParameters.field_216288_h)).filter(Data::hasEntity);
        data.flatMap(Data::getEntityName).ifPresent(name -> stacks.stream().filter(TombstoneBlock::isRemains).forEach(stack -> {
            stack.func_135074_t();
            stack.func_200302_a((ITextComponent)new TranslationTextComponent("block.mca.tombstone.remains", new Object[]{stack.func_200301_q(), name}));
        }));
        data.ifPresent(be -> stacks.stream().filter(s -> s.func_77973_b() == this.func_199767_j()).findFirst().ifPresent(be::writeToStack));
        return stacks;
    }

    static boolean isRemains(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151103_aS || stack.func_77973_b() == Items.field_196182_dv;
    }

    public static class Data
    extends TileEntity
    implements ITickableTileEntity {
        public static Supplier<Data> constructor = Data::new;
        private Optional<EntityData> entityData = Optional.empty();
        @Nullable
        private FlowingText computedName;
        private int resurrectionProgress;
        private boolean cure;

        protected Data() {
            super((TileEntityType)BlockEntityTypesMCA.TOMBSTONE.get());
        }

        public boolean isResurrecting() {
            return this.resurrectionProgress > 0;
        }

        public void startResurrecting(boolean cure) {
            this.resurrectionProgress = 1;
            this.cure = cure;
            this.generateLightning();
            this.func_70296_d();
            this.sync();
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.hasEntity() && this.resurrectionProgress > 0) {
                ++this.resurrectionProgress;
                this.func_70296_d();
                this.sync();
                if (this.resurrectionProgress % 30 == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.cure ? SoundEvents.field_219603_Y : SoundEvents.field_190026_er, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.field_145850_b.func_217379_c(2001, this.field_174879_c, Block.func_196246_j((BlockState)this.func_195044_w()));
                }
                if (this.field_145850_b.field_73012_v.nextInt(10) > 5 && this.resurrectionProgress % 20 == 0) {
                    this.generateLightning();
                }
                if (this.resurrectionProgress > 500) {
                    this.resurrectionProgress = 0;
                    this.createEntity(this.field_145850_b, true).ifPresent(entity -> {
                        this.generateLightning();
                        entity.func_70066_B();
                        entity.func_242279_ag();
                        entity.func_70107_b((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
                        if (entity instanceof LivingEntity) {
                            LivingEntity l = (LivingEntity)entity;
                            l.func_70606_j(l.func_110138_aP());
                            l.func_195061_cb();
                            l.field_70143_R = 0.0f;
                            l.field_70128_L = false;
                            l.field_70725_aQ = 0;
                        }
                        if (entity instanceof AgeableEntity) {
                            AgeableEntity mob = (AgeableEntity)entity;
                            mob.func_70873_a(mob.func_70874_b());
                        }
                        boolean alreadySpawned = false;
                        if (this.cure && entity instanceof ZombieVillagerEntity) {
                            ZombieVillagerEntity zombie = (ZombieVillagerEntity)entity;
                            entity = zombie.func_233656_b_(EntityType.field_200756_av, true);
                            alreadySpawned = true;
                        }
                        if (entity instanceof CompassionateEntity) {
                            CompassionateEntity compassionateEntity = (CompassionateEntity)entity;
                            compassionateEntity.getRelationships().getFamilyEntry().setDeceased(false);
                        }
                        if (entity instanceof Infectable) {
                            Infectable infectable = (Infectable)entity;
                            infectable.setInfectionProgress(this.cure ? 0.0f : Math.max(MathHelper.func_219799_g((float)this.field_145850_b.field_73012_v.nextFloat(), (float)0.2f, (float)0.6f), infectable.getInfectionProgress()));
                        }
                        if (!alreadySpawned) {
                            this.field_145850_b.func_217376_c(entity);
                        }
                    });
                }
            }
        }

        private void generateLightning() {
            this.field_145850_b.func_225605_c_(10);
            LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_145850_b);
            bolt.func_233623_a_(true);
            bolt.func_226286_f_((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
            this.field_145850_b.func_217376_c((Entity)bolt);
        }

        public void setEntity(@Nullable Entity entity) {
            this.entityData = Optional.ofNullable(entity).map(e -> new EntityData(this.writeEntityToNbt((Entity)e), e.func_145748_c_(), EntityRelationship.of(e).map(EntityRelationship::getGender).orElse(Gender.MALE)));
            this.computedName = null;
            this.func_70296_d();
            if (this.func_145830_o()) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_219603_Y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.field_145850_b.func_217379_c(2001, this.field_174879_c, Block.func_196246_j((BlockState)this.func_195044_w()));
                ((TombstoneBlock)this.func_195044_w().func_177230_c()).updateNeighbors(this.func_195044_w(), this.field_145850_b, this.field_174879_c);
                if (!this.field_145850_b.field_72995_K) {
                    GraveyardManager.get((ServerWorld)this.field_145850_b).setTombstoneState(this.field_174879_c, this.hasEntity() ? GraveyardManager.TombstoneState.FILLED : GraveyardManager.TombstoneState.EMPTY);
                    this.sync();
                }
            }
        }

        public boolean hasEntity() {
            return this.entityData.isPresent();
        }

        public Gender getGender() {
            return this.entityData.map(e -> ((EntityData)e).gender).orElse(Gender.MALE);
        }

        public Optional<ITextComponent> getEntityName() {
            return this.entityData.map(e -> ((EntityData)e).name);
        }

        public FlowingText getOrCreateEntityName(Function<ITextComponent, FlowingText> factory) {
            if (this.computedName == null) {
                this.computedName = factory.apply(this.getEntityName().orElse(StringTextComponent.field_240750_d_));
            }
            return this.computedName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<Entity> createEntity(World world, boolean remove) {
            try {
                Optional<Entity> optional = this.entityData.flatMap(data -> EntityType.func_220330_a((CompoundNBT)((EntityData)data).nbt, (World)world));
                return optional;
            }
            finally {
                if (remove) {
                    this.setEntity(null);
                }
            }
        }

        private CompoundNBT writeEntityToNbt(Entity entity) {
            CompoundNBT nbt = new CompoundNBT();
            entity.func_189511_e(nbt);
            nbt.func_74778_a("id", EntityType.func_200718_a((EntityType)entity.func_200600_R()).toString());
            return nbt;
        }

        protected void sync() {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }

        public void fromClientTag(CompoundNBT tag) {
            this.entityData = tag.func_150297_b("entityData", 10) ? Optional.of(new EntityData(tag)) : Optional.empty();
            this.resurrectionProgress = tag.func_74762_e("resurrectionProgress");
            this.cure = tag.func_74767_n("cure");
        }

        public CompoundNBT toClientTag(CompoundNBT tag) {
            return this.func_189515_b(tag);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.fromClientTag(nbt);
        }

        public CompoundNBT func_189517_E_() {
            return this.func_189515_b(new CompoundNBT());
        }

        public SUpdateTileEntityPacket func_189518_D_() {
            return new SUpdateTileEntityPacket(this.field_174879_c, 127, this.func_189517_E_());
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            this.entityData.ifPresent(data -> data.writeNbt(nbt));
            nbt.func_74768_a("resurrectionProgress", this.resurrectionProgress);
            nbt.func_74757_a("cure", this.cure);
            return super.func_189515_b(nbt);
        }

        public void readFromStack(ItemStack stack) {
            this.entityData = Optional.ofNullable(stack).map(s -> s.func_179543_a("entityData")).map(EntityData::new);
        }

        public void writeToStack(ItemStack stack) {
            this.entityData.ifPresent(data -> {
                data.writeNbt(stack.func_190925_c("entityData"));
                this.getEntityName().ifPresent(name -> NbtHelper.computeIfAbsent(stack.func_190925_c("Display"), "Lore", 9, ListNBT::new).add(0, (INBT)StringNBT.func_229705_a_((String)name.func_150261_e())));
            });
        }

        public static Optional<Data> of(@Nullable TileEntity be) {
            return Optional.ofNullable(be).filter(p -> p instanceof Data).map(Data.class::cast);
        }

        static final class EntityData {
            private final CompoundNBT nbt;
            private final ITextComponent name;
            private final Gender gender;

            public EntityData(CompoundNBT nbt, ITextComponent name, Gender gender) {
                this.nbt = nbt;
                this.name = name == null ? StringTextComponent.field_240750_d_ : new StringTextComponent(name.func_150261_e());
                this.gender = gender;
            }

            EntityData(CompoundNBT nbt) {
                this(nbt.func_74775_l("entityData"), (ITextComponent)ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("entityName")), Gender.byId(nbt.func_74762_e("entityGender")));
            }

            void writeNbt(CompoundNBT nbt) {
                nbt.func_218657_a("entityData", (INBT)this.nbt);
                nbt.func_74778_a("entityName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
                nbt.func_74768_a("entityGender", this.gender.ordinal());
            }
        }
    }
}

