/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.book.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.client.book.pages.Page;
import forge.net.mca.client.gui.ExtendedBookScreen;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ListPage
extends Page {
    final ITextComponent title;
    final List<ITextComponent> text;
    int page;
    public static final int entriesPerPage = 11;

    public ListPage(ITextComponent title, List<ITextComponent> text) {
        this.title = title;
        this.text = text;
    }

    public ListPage(String title, List<ITextComponent> text) {
        this((ITextComponent)new TranslationTextComponent(title).func_240699_a_(TextFormatting.BLACK).func_240699_a_(TextFormatting.BOLD), text);
    }

    private static void drawCenteredText(MatrixStack matrices, FontRenderer textRenderer, ITextComponent text, int centerX, int y, int color) {
        IReorderingProcessor orderedText = text.func_241878_f();
        textRenderer.func_238422_b_(matrices, orderedText, (float)(centerX - textRenderer.func_243245_a(orderedText) / 2), (float)y, color);
    }

    @Override
    public void render(ExtendedBookScreen screen, MatrixStack matrices, int mouseX, int mouseY, float delta) {
        ListPage.drawCenteredText(matrices, screen.getTextRenderer(), this.title, screen.field_230708_k_ / 2, 35, -1);
        int y = 48;
        for (int i = this.page * 11; i < Math.min(this.text.size(), (this.page + 1) * 11); ++i) {
            ListPage.drawCenteredText(matrices, screen.getTextRenderer(), this.text.get(i), screen.field_230708_k_ / 2 - 4, y, -1);
            y += 10;
        }
    }

    @Override
    public void open(boolean back) {
        this.page = back ? (this.text.size() - 1) / 11 : 0;
    }

    @Override
    public boolean previousPage() {
        if (this.page > 0) {
            --this.page;
            return false;
        }
        return true;
    }

    @Override
    public boolean nextPage() {
        if (this.page < (this.text.size() - 1) / 11) {
            ++this.page;
            return false;
        }
        return true;
    }
}

