/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.book.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.client.book.pages.Page;
import forge.net.mca.client.gui.ExtendedBookScreen;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TitlePage
extends Page {
    final ITextComponent title;
    final ITextComponent subtitle;

    public TitlePage(String book) {
        this(book, TextFormatting.BLACK);
    }

    public TitlePage(String book, TextFormatting color) {
        this("item.mca.book_" + book, "mca.books." + book + ".author", color);
    }

    public TitlePage(String title, String subtitle) {
        this(title, subtitle, TextFormatting.BLACK);
    }

    public TitlePage(String title, String subtitle, TextFormatting color) {
        this((ITextComponent)new TranslationTextComponent(title).func_240699_a_(color).func_240699_a_(TextFormatting.BOLD), (ITextComponent)new TranslationTextComponent(subtitle).func_240699_a_(color).func_240699_a_(TextFormatting.ITALIC));
    }

    public TitlePage(ITextComponent title, ITextComponent subtitle) {
        this.title = title;
        this.subtitle = subtitle;
    }

    private static void drawCenteredText(MatrixStack matrices, FontRenderer textRenderer, ITextComponent text, int centerX, int y, int color) {
        IReorderingProcessor orderedText = text.func_241878_f();
        TitlePage.drawCenteredText(matrices, textRenderer, orderedText, centerX, y, color);
    }

    private static void drawCenteredText(MatrixStack matrices, FontRenderer textRenderer, IReorderingProcessor text, int centerX, int y, int color) {
        textRenderer.func_238422_b_(matrices, text, (float)(centerX - textRenderer.func_243245_a(text) / 2), (float)y, color);
    }

    @Override
    public void render(ExtendedBookScreen screen, MatrixStack matrices, int mouseX, int mouseY, float delta) {
        List texts = screen.getTextRenderer().func_238425_b_((ITextProperties)this.title, 114);
        int y = 80 - 5 * texts.size();
        for (IReorderingProcessor t : texts) {
            TitlePage.drawCenteredText(matrices, screen.getTextRenderer(), t, screen.field_230708_k_ / 2 - 2, y, 0xFFFFFF);
            y += 10;
        }
        y = 82 + 5 * texts.size();
        TitlePage.drawCenteredText(matrices, screen.getTextRenderer(), this.subtitle, screen.field_230708_k_ / 2 - 2, y, 0xFFFFFF);
    }
}

