/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.client.gui.Button;
import forge.net.mca.client.gui.Constraint;
import forge.net.mca.client.gui.MCAScreens;
import forge.net.mca.client.resources.Icon;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class AbstractDynamicScreen
extends Screen {
    protected static final float iconScale = 1.5f;
    private String activeScreen = "main";
    private int mouseX;
    private int mouseY;
    private Set<Constraint> constraints = new HashSet<Constraint>();

    protected AbstractDynamicScreen(ITextComponent title) {
        super(title);
    }

    public String getActiveScreen() {
        return this.activeScreen;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Set<Constraint> constraints) {
        this.constraints = constraints;
        this.setLayout(this.activeScreen);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    protected abstract void buttonPressed(Button var1);

    protected void disableButton(String id) {
        this.func_231039_at__().forEach(b -> {
            if (b instanceof ButtonEx && ((ButtonEx)((Object)b)).getApiButton().identifier().equals(id)) {
                ((ButtonEx)b).field_230693_o_ = false;
            }
        });
    }

    protected void enableAllButtons() {
        this.func_231039_at__().forEach(b -> {
            if (b instanceof Widget) {
                ((Widget)b).field_230693_o_ = true;
            }
        });
    }

    protected void disableAllButtons() {
        this.func_231039_at__().forEach(b -> {
            if (b instanceof Widget) {
                if (b instanceof ButtonEx) {
                    if (!((ButtonEx)((Object)b)).getApiButton().identifier().equals("gui.button.backarrow")) {
                        ((Widget)b).field_230693_o_ = false;
                    }
                } else {
                    ((Widget)b).field_230693_o_ = false;
                }
            }
        });
    }

    public void setLayout(String guiKey) {
        this.activeScreen = guiKey;
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        MCAScreens.getInstance().getScreen(guiKey).ifPresent(buttons -> {
            for (Button b : buttons) {
                this.func_230480_a_((Widget)new ButtonEx(b, this));
            }
        });
    }

    protected void drawIcon(MatrixStack transform, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        this.func_238474_b_(transform, (int)((float)icon.x() / 1.5f), (int)((float)icon.y() / 1.5f), icon.u(), icon.v(), 16, 16);
    }

    protected void drawHoveringIconText(MatrixStack transform, ITextComponent text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        this.func_238652_a_(transform, text, icon.x() + 16, icon.y() + 20);
    }

    protected void drawHoveringIconText(MatrixStack transform, List<ITextComponent> text, String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        this.func_243308_b(transform, text, icon.x() + 16, icon.y() + 20);
    }

    protected boolean hoveringOverIcon(String key) {
        Icon icon = MCAScreens.getInstance().getIcon(key);
        return this.hoveringOver(icon.x(), icon.y(), 24, 24);
    }

    protected boolean hoveringOver(int x, int y, int w, int h) {
        return this.mouseX > x && this.mouseX < x + w && this.mouseY > y && this.mouseY < y + h;
    }

    private static class ButtonEx
    extends net.minecraft.client.gui.widget.button.Button {
        private final Button apiButton;

        public ButtonEx(Button apiButton, AbstractDynamicScreen screen) {
            super((int)((float)screen.field_230708_k_ * Alignment.alignments.get((Object)apiButton.align()).h + (float)apiButton.x()), (int)((float)screen.field_230709_l_ * Alignment.alignments.get((Object)apiButton.align()).v + (float)apiButton.y()), apiButton.width(), apiButton.height(), (ITextComponent)new TranslationTextComponent(apiButton.identifier()), a -> screen.buttonPressed(apiButton));
            this.apiButton = apiButton;
            if (!apiButton.isValidForConstraint(screen.getConstraints())) {
                if (apiButton.hideOnFail()) {
                    this.field_230694_p_ = false;
                }
                this.field_230693_o_ = false;
            }
        }

        public Button getApiButton() {
            return this.apiButton;
        }
    }

    private static enum Alignment {
        TOP_LEFT(0.0f, 0.0f),
        TOP(0.5f, 0.0f),
        TOP_RIGHT(1.0f, 0.0f),
        RIGHT(1.0f, 0.5f),
        BOTTOM_RIGHT(1.0f, 1.0f),
        BOTTOM(0.5f, 1.0f),
        BOTTOM_LEFT(0.0f, 1.0f),
        LEFT(0.0f, 0.5f),
        CENTER(0.5f, 0.5f);

        final float h;
        final float v;
        static final Map<String, Alignment> alignments;

        private Alignment(float h, float v) {
            this.h = h;
            this.v = v;
        }

        static {
            alignments = new HashMap<String, Alignment>();
            for (Alignment a : Alignment.values()) {
                alignments.put(a.name().toLowerCase(Locale.ENGLISH), a);
            }
        }
    }
}

