/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.ExtendedScreen;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.client.gui.widget.RectangleWidget;
import forge.net.mca.client.gui.widget.TooltipButtonWidget;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.c2s.GetVillageRequest;
import forge.net.mca.network.c2s.RenameVillageMessage;
import forge.net.mca.network.c2s.ReportBuildingMessage;
import forge.net.mca.network.c2s.SaveVillageMessage;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.data.BuildingType;
import forge.net.mca.resources.data.tasks.Task;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.util.compat.RenderSystemCompat;
import forge.net.mca.util.localization.FlowingText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class BlueprintScreen
extends ExtendedScreen {
    private final int positionTaxes = -60;
    private final int positionBirth = -10;
    private final int positionMarriage = 40;
    private Village village;
    private int reputation;
    private boolean isVillage;
    private Rank rank;
    private Set<String> completedTasks;
    private String page;
    private Button[] buttonTaxes;
    private Button[] buttonBirths;
    private Button[] buttonMarriage;
    private Button buttonPage;
    private int pageNumber = 0;
    private final List<Button> catalogButtons = new LinkedList<Button>();
    private static final ResourceLocation ICON_TEXTURES = MCA.locate("textures/buildings.png");
    private BuildingType selectedBuilding;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;
    private Map<Rank, List<Task>> tasks;
    private Map<String, BuildingType> buildingTypes;

    private BuildingType getBuildingType(String type) {
        return this.buildingTypes.containsKey(type) ? this.buildingTypes.get(type) : new BuildingType();
    }

    public BlueprintScreen() {
        super((ITextComponent)new StringTextComponent("Blueprint"));
    }

    private void saveVillage() {
        NetworkHandler.sendToServer(new SaveVillageMessage(this.village));
    }

    private void changeTaxes(int d) {
        this.village.setTaxes(Math.max(0, Math.min(100, this.village.getTaxes() + d)));
        this.saveVillage();
    }

    private void changePopulationThreshold(int d) {
        this.village.setPopulationThreshold(Math.max(0, Math.min(100, this.village.getPopulationThreshold() + d)));
        this.saveVillage();
    }

    private void changeMarriageThreshold(int d) {
        this.village.setMarriageThreshold(Math.max(0, Math.min(100, this.village.getMarriageThreshold() + d)));
        this.saveVillage();
    }

    private Button[] createValueChanger(int x, int y, int w, int h, Consumer<Boolean> onPress, ITextComponent tooltip) {
        Button[] buttons = new Button[3];
        buttons[1] = (Button)this.func_230480_a_((Widget)new Button(x - w / 2, y, w / 4, h, (ITextComponent)new StringTextComponent("<<"), b -> onPress.accept(false)));
        buttons[2] = (Button)this.func_230480_a_((Widget)new Button(x + w / 4, y, w / 4, h, (ITextComponent)new StringTextComponent(">>"), b -> onPress.accept(true)));
        buttons[0] = (Button)this.func_230480_a_((Widget)new Button(x - w / 4, y, w / 2, h, (ITextComponent)new StringTextComponent(""), b -> {}, (buttonWidget, matrixStack, mx, my) -> this.func_243308_b(matrixStack, FlowingText.wrap(tooltip, 160), mx, my)));
        return buttons;
    }

    protected void drawBuildingIcon(MatrixStack transform, int x, int y, int u, int v) {
        transform.func_227860_a_();
        transform.func_227861_a_((double)x - 6.6, (double)y - 6.6, 0.0);
        transform.func_227862_a_(0.66f, 0.66f, 0.66f);
        this.func_238474_b_(transform, 0, 0, u, v, 20, 20);
        transform.func_227865_b_();
    }

    public void func_231160_c_() {
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.setPage("waiting");
    }

    private void setPage(String page) {
        if (page.equals("close")) {
            assert (this.field_230706_i_ != null);
            this.field_230706_i_.func_147108_a(null);
            return;
        }
        this.page = page;
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        this.func_230480_a_((Widget)new Button(5, 5, 20, 20, (ITextComponent)new TranslationTextComponent("gui.button.backarrow"), b -> this.setPage("close")));
        int bx = this.field_230708_k_ / 2 - 180;
        int by = this.field_230709_l_ / 2 - 56;
        if (!(page.equals("rename") || page.equals("empty") || page.equals("waiting"))) {
            for (String p : new String[]{"map", "rank", "catalog", "villagers", "rules", "refresh"}) {
                Button widget = new Button(bx, by, 80, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint." + p), b -> this.setPage(p));
                this.func_230480_a_((Widget)widget);
                if (page.equals(p)) {
                    widget.field_230693_o_ = false;
                }
                by += 22;
            }
            by += 22;
        }
        switch (page) {
            case "empty": {
                bx = this.field_230708_k_ / 2 - 48;
                by = this.field_230709_l_ / 2;
                this.func_230480_a_((Widget)new Button(bx, by + 5, 96, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.addBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                    this.func_231175_as__();
                }));
                break;
            }
            case "refresh": {
                NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FULL_SCAN));
                NetworkHandler.sendToServer(new GetVillageRequest());
                assert (this.field_230706_i_ != null);
                assert (this.field_230706_i_.field_71439_g != null);
                this.field_230706_i_.field_71439_g.func_146105_b((ITextComponent)new TranslationTextComponent("blueprint.refreshed"), true);
                this.setPage("map");
                break;
            }
            case "advanced": {
                bx = this.field_230708_k_ / 2 + 180 - 64 - 16;
                by = this.field_230709_l_ / 2 - 56;
                TranslationTextComponent text = new TranslationTextComponent("gui.blueprint.autoScan");
                if (this.village.isAutoScan()) {
                    text.func_240699_a_(TextFormatting.GREEN);
                } else {
                    text.func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.STRIKETHROUGH);
                }
                this.func_230480_a_((Widget)new TooltipButtonWidget(bx, by, 96, 20, text, arg_0 -> this.lambda$setPage$7((String)page, arg_0)));
                this.func_230480_a_((Widget)new TooltipButtonWidget(bx, by += 22, 96, 20, new TranslationTextComponent("gui.blueprint.restrictAccess"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.FORCE_TYPE, "blocked"));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.func_230480_a_((Widget)new TooltipButtonWidget(bx, by += 22, 96, 20, "gui.blueprint.addRoom", b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD_ROOM));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 66;
                if (this.isVillage) {
                    this.func_230480_a_((Widget)new Button(bx, by, 96, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.renameVillage"), b -> this.setPage("rename")));
                }
                by += 22;
            }
            case "map": {
                bx = this.field_230708_k_ / 2 + 180 - 64 - 16;
                by = this.field_230709_l_ / 2 - 56 + 66;
                this.func_230480_a_((Widget)new Button(bx, by, 96, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.addBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.ADD));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                this.func_230480_a_((Widget)new Button(bx, by += 22, 96, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.removeBuilding"), b -> {
                    NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.REMOVE));
                    NetworkHandler.sendToServer(new GetVillageRequest());
                }));
                by += 22;
                if (page.equals("advanced")) break;
                this.func_230480_a_((Widget)new Button(bx, by, 96, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.advanced"), b -> this.setPage("advanced")));
                break;
            }
            case "rank": {
                break;
            }
            case "catalog": {
                int row = 0;
                int col = 0;
                int size = 21;
                int x = this.field_230708_k_ / 2 - 4 * size - 8;
                int y = (int)((double)(this.field_230709_l_ / 2) - 2.0 * (double)size);
                this.catalogButtons.clear();
                for (BuildingType bt : this.buildingTypes.values()) {
                    if (!bt.visible()) continue;
                    ImageButton widget = new ImageButton(row * size + x + 10, col * size + y - 10, 20, 20, bt.iconU(), bt.iconV() + 20, 20, ICON_TEXTURES, 256, 256, button -> {
                        this.selectBuilding(bt);
                        button.field_230693_o_ = false;
                        this.catalogButtons.forEach(b -> {
                            b.field_230693_o_ = true;
                        });
                    }, (ITextComponent)new TranslationTextComponent("buildingType." + bt.name()));
                    this.catalogButtons.add((Button)this.func_230480_a_((Widget)widget));
                    if (++row <= 4) continue;
                    row = 0;
                    ++col;
                }
                break;
            }
            case "villagers": {
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 24 - 20, this.field_230709_l_ / 2 + 54, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
                    if (this.pageNumber > 0) {
                        --this.pageNumber;
                    }
                }));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 24, this.field_230709_l_ / 2 + 54, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
                    if ((double)this.pageNumber < Math.ceil((double)this.village.getPopulation() / 9.0) - 1.0) {
                        ++this.pageNumber;
                    }
                }));
                this.buttonPage = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 24, this.field_230709_l_ / 2 + 54, 48, 20, (ITextComponent)new StringTextComponent("0/0)"), b -> {}));
                break;
            }
            case "rules": {
                this.buttonTaxes = this.createValueChanger(this.field_230708_k_ / 2, this.field_230709_l_ / 2 + -60 + 10, 80, 20, b -> this.changeTaxes(b != false ? 10 : -10), (ITextComponent)new TranslationTextComponent("gui.blueprint.tooltip.taxes"));
                this.toggleButtons(this.buttonTaxes, false);
                this.buttonBirths = this.createValueChanger(this.field_230708_k_ / 2, this.field_230709_l_ / 2 + -10 + 10, 80, 20, b -> this.changePopulationThreshold(b != false ? 10 : -10), (ITextComponent)new TranslationTextComponent("gui.blueprint.tooltip.births"));
                this.toggleButtons(this.buttonBirths, false);
                this.buttonMarriage = this.createValueChanger(this.field_230708_k_ / 2, this.field_230709_l_ / 2 + 40 + 10, 80, 20, b -> this.changeMarriageThreshold(b != false ? 10 : -10), (ITextComponent)new TranslationTextComponent("gui.blueprint.tooltip.marriage"));
                this.toggleButtons(this.buttonMarriage, false);
                break;
            }
            case "rename": {
                TextFieldWidget field = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 65, this.field_230709_l_ / 2 - 16, 130, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.renameVillage")));
                field.func_146203_f(32);
                field.func_146180_a(this.village.getName());
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 66, this.field_230709_l_ / 2 + 8, 64, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.cancel"), b -> this.setPage("map")));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 2, this.field_230709_l_ / 2 + 8, 64, 20, (ITextComponent)new TranslationTextComponent("gui.blueprint.rename"), b -> {
                    NetworkHandler.sendToServer(new RenameVillageMessage(this.village.getId(), field.func_146179_b()));
                    this.village.setName(field.func_146179_b());
                    this.setPage("map");
                }));
            }
        }
    }

    private void selectBuilding(BuildingType b) {
        this.selectedBuilding = b;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack transform, int sizeX, int sizeY, float offset) {
        this.func_230446_a_(transform);
        assert (this.field_230706_i_ != null);
        this.mouseX = (int)(this.field_230706_i_.field_71417_B.func_198024_e() * (double)this.field_230708_k_ / (double)this.field_230706_i_.func_228018_at_().func_198109_k());
        this.mouseY = (int)(this.field_230706_i_.field_71417_B.func_198026_f() * (double)this.field_230709_l_ / (double)this.field_230706_i_.func_228018_at_().func_198091_l());
        switch (this.page) {
            case "waiting": {
                BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.waiting"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)-5592406);
                break;
            }
            case "empty": {
                BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.empty"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 20), (int)-5592406);
                break;
            }
            case "map": {
                this.renderStats(transform);
            }
            case "advanced": {
                this.renderName(transform);
                this.renderMap(transform);
                break;
            }
            case "rank": {
                this.renderTasks(transform);
                this.renderStats(transform);
                break;
            }
            case "catalog": {
                this.renderCatalog(transform);
                break;
            }
            case "villagers": {
                this.renderVillagers(transform);
                break;
            }
            case "rules": {
                this.renderRules(transform);
            }
        }
        super.func_230430_a_(transform, sizeX, sizeY, offset);
    }

    private void renderName(MatrixStack transform) {
        transform.func_227860_a_();
        transform.func_227862_a_(2.0f, 2.0f, 2.0f);
        if (this.isVillage) {
            BlueprintScreen.func_238471_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (String)this.village.getName(), (int)(this.field_230708_k_ / 4), (int)(this.field_230709_l_ / 4 - 48), (int)-1);
        } else {
            BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.settlement"), (int)(this.field_230708_k_ / 4), (int)(this.field_230709_l_ / 4 - 48), (int)-1);
        }
        transform.func_227865_b_();
    }

    private void renderStats(MatrixStack transform) {
        int x = this.field_230708_k_ / 2 + (this.page.equals("rank") ? -70 : 105);
        int y = this.field_230709_l_ / 2 - 50;
        TranslationTextComponent rankStr = new TranslationTextComponent(this.rank.getTranslationKey());
        int rankColor = this.rank.ordinal() == 0 ? -65536 : -256;
        this.field_230712_o_.func_243246_a(transform, (ITextComponent)new TranslationTextComponent("gui.blueprint.currentRank", new Object[]{rankStr}), (float)x, (float)y, rankColor);
        this.field_230712_o_.func_243246_a(transform, (ITextComponent)new TranslationTextComponent("gui.blueprint.reputation", new Object[]{String.valueOf(this.reputation)}), (float)x, (float)(y + 11), this.rank.ordinal() == 0 ? -65536 : -1);
        this.field_230712_o_.func_243246_a(transform, (ITextComponent)new TranslationTextComponent("gui.blueprint.buildings", new Object[]{this.village.getBuildings().size()}), (float)x, (float)(y + 22), -1);
        this.field_230712_o_.func_243246_a(transform, (ITextComponent)new TranslationTextComponent("gui.blueprint.population", new Object[]{this.village.getPopulation(), this.village.getMaxPopulation()}), (float)x, (float)(y + 33), -1);
    }

    /*
     * WARNING - void declaration
     */
    private void renderMap(MatrixStack transform) {
        void var10_13;
        int mapSize = 75;
        int y = this.field_230709_l_ / 2 + 8;
        RectangleWidget.drawRectangle(transform, this.field_230708_k_ / 2 - mapSize, y - mapSize, this.field_230708_k_ / 2 + mapSize, y + mapSize, -120);
        transform.func_227860_a_();
        RenderSystemCompat.setShaderTexture(0, ICON_TEXTURES);
        float sc = Math.min((float)mapSize / (float)(this.village.getBox().getMaxBlockCount() + 3) * 2.0f, 2.0f);
        int mouseLocalX = (int)(((double)this.mouseX - (double)this.field_230708_k_ / 2.0) / (double)sc + (double)this.village.getCenter().func_177958_n());
        int mouseLocalY = (int)((float)(this.mouseY - y) / sc + (float)this.village.getCenter().func_177952_p());
        transform.func_227861_a_((double)this.field_230708_k_ / 2.0, (double)y, 0.0);
        transform.func_227862_a_(sc, sc, 0.0f);
        transform.func_227861_a_((double)(-this.village.getCenter().func_177958_n()), (double)(-this.village.getCenter().func_177952_p()), 0.0);
        assert (this.field_230706_i_ != null);
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        if (player != null) {
            RectangleWidget.drawRectangle(transform, (int)player.func_226277_ct_() - 1, (int)player.func_226281_cx_() - 1, (int)player.func_226277_ct_() + 1, (int)player.func_226281_cx_() + 1, -65281);
        }
        LinkedList<Building> hoverBuildings = new LinkedList<Building>();
        for (Building building : this.village.getBuildings().values()) {
            BuildingType bt = this.getBuildingType(building.getType());
            if (bt.isIcon()) {
                BlockPos blockPos = building.getCenter();
                this.drawBuildingIcon(transform, blockPos.func_177958_n(), blockPos.func_177952_p(), bt.iconU(), bt.iconV());
                int n = 6;
                Vector3i vector3i = new Vector3i(mouseLocalX, blockPos.func_177956_o(), mouseLocalY);
                if (!(blockPos.func_177951_i(vector3i) < (double)(n * n))) continue;
                hoverBuildings.add(building);
                continue;
            }
            BlockPos blockPos = building.getPos0();
            BlockPos blockPos2 = building.getPos1();
            RectangleWidget.drawRectangle(transform, blockPos.func_177958_n(), blockPos.func_177952_p(), blockPos2.func_177958_n(), blockPos2.func_177952_p(), bt.getColor());
            if (bt.visible()) {
                BlockPos c = building.getCenter();
                this.drawBuildingIcon(transform, c.func_177958_n(), c.func_177952_p(), bt.iconU(), bt.iconV());
            }
            int margin = 1;
            if (mouseLocalX < blockPos.func_177958_n() - margin || mouseLocalX > blockPos2.func_177958_n() + margin || mouseLocalY < blockPos.func_177952_p() - margin || mouseLocalY > blockPos2.func_177952_p() + margin) continue;
            hoverBuildings.add(building);
        }
        transform.func_227865_b_();
        hoverBuildings.sort((a, b) -> b.getCenter().func_177956_o() - a.getCenter().func_177956_o());
        LinkedList<List<ITextComponent>> tooltips = new LinkedList<List<ITextComponent>>();
        for (Object b2 : hoverBuildings) {
            tooltips.add(this.getBuildingTooltip((Building)b2));
        }
        boolean bl = false;
        for (List list : tooltips) {
            var10_13 += this.getTooltipHeight(list) + 9;
        }
        int py = this.mouseY - var10_13 / 2 + 12;
        for (List list : tooltips) {
            this.func_243308_b(transform, list, this.mouseX, py);
            py += this.getTooltipHeight(list) + 9;
        }
    }

    private List<ITextComponent> getBuildingTooltip(Building hoverBuilding) {
        LinkedList<ITextComponent> lines = new LinkedList<ITextComponent>();
        BuildingType bt = this.getBuildingType(hoverBuilding.getType());
        lines.add((ITextComponent)new TranslationTextComponent("buildingType." + bt.name()));
        if (!bt.grouped()) {
            lines.add((ITextComponent)new TranslationTextComponent("gui.blueprint.size", new Object[]{String.valueOf(hoverBuilding.getSize())}));
        }
        for (String string : hoverBuilding.getResidents().values()) {
            lines.add((ITextComponent)new StringTextComponent(string));
        }
        for (Map.Entry entry : hoverBuilding.getBlocks().entrySet()) {
            lines.add((ITextComponent)new StringTextComponent(((List)entry.getValue()).size() + " x ").func_230529_a_(this.getBlockName((ResourceLocation)entry.getKey())).func_240699_a_(TextFormatting.GRAY));
        }
        return lines;
    }

    private void renderTasks(MatrixStack transform) {
        if (this.rank == null) {
            return;
        }
        int y = this.field_230709_l_ / 2 + 5;
        int x = this.field_230708_k_ / 2 - 70;
        for (Task task : this.tasks.get((Object)this.rank.promote())) {
            boolean completed = this.completedTasks.contains(task.getId());
            IFormattableTextComponent t = task.getTranslatable().func_240699_a_(completed ? TextFormatting.STRIKETHROUGH : TextFormatting.RESET);
            this.field_230712_o_.func_243246_a(transform, (ITextComponent)t, (float)x, (float)y, completed ? -7798904 : -43691);
            y += 11;
        }
    }

    private void renderCatalog(MatrixStack transform) {
        transform.func_227860_a_();
        transform.func_227862_a_(2.0f, 2.0f, 2.0f);
        BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.catalogFull"), (int)(this.field_230708_k_ / 4), (int)(this.field_230709_l_ / 4 - 52), (int)-1);
        transform.func_227865_b_();
        BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.catalogHint").func_240699_a_(TextFormatting.GRAY), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 82), (int)-1);
        int x = this.field_230708_k_ / 2 + 35;
        int y = this.field_230709_l_ / 2 - 50;
        if (this.selectedBuilding != null) {
            this.field_230712_o_.func_243246_a(transform, (ITextComponent)new TranslationTextComponent("buildingType." + this.selectedBuilding.name()), (float)x, (float)y, this.selectedBuilding.getColor());
            List<ITextComponent> wrap = FlowingText.wrap((ITextComponent)new TranslationTextComponent("buildingType." + this.selectedBuilding.name() + ".description").func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC), 150);
            for (ITextComponent iTextComponent : wrap) {
                this.field_230712_o_.func_243246_a(transform, iTextComponent, (float)x, (float)(y + 12), -1);
                y += 10;
            }
            TranslationTextComponent size = this.selectedBuilding.size() == 0 ? new TranslationTextComponent("gui.blueprint.anySize") : new TranslationTextComponent("gui.blueprint.size", new Object[]{String.valueOf(this.selectedBuilding.size())});
            this.field_230712_o_.func_243246_a(transform, (ITextComponent)size, (float)x, (float)(y + 20), -2236963);
            for (Map.Entry<ResourceLocation, Integer> entry : this.selectedBuilding.getGroups().entrySet()) {
                this.field_230712_o_.func_243246_a(transform, (ITextComponent)new StringTextComponent(entry.getValue() + " x ").func_230529_a_(this.getBlockName(entry.getKey())), (float)x, (float)(y + 32), -1);
                y += 10;
            }
        } else {
            List<ITextComponent> wrap = FlowingText.wrap((ITextComponent)new TranslationTextComponent("gui.blueprint.buildingTypes").func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC), 150);
            for (ITextComponent iTextComponent : wrap) {
                this.field_230712_o_.func_243246_a(transform, iTextComponent, (float)x, (float)y, -1);
                y += 10;
            }
        }
    }

    private void renderVillagers(MatrixStack transform) {
        int index;
        int maxPages = (int)Math.ceil((double)this.village.getPopulation() / 9.0);
        this.buttonPage.func_238482_a_((ITextComponent)new StringTextComponent(this.pageNumber + 1 + "/" + maxPages));
        List villager = this.village.getBuildings().values().stream().flatMap(b -> b.getResidents().entrySet().stream()).sorted(Map.Entry.comparingByValue()).collect(Collectors.toList());
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < villager.size(); ++i) {
            int y = this.field_230709_l_ / 2 - 51 + i * 11;
            boolean hover = this.isMouseWithin(this.field_230708_k_ / 2 - 50, y - 1, 100, 11);
            BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent((String)((Map.Entry)villager.get(index)).getValue()), (int)(this.field_230708_k_ / 2), (int)y, (int)(hover ? -2631804 : -1));
            if (!hover) continue;
            this.selectedVillager = (UUID)((Map.Entry)villager.get(index)).getKey();
        }
    }

    private void renderRules(MatrixStack transform) {
        this.buttonTaxes[0].func_238482_a_((ITextComponent)new StringTextComponent(this.village.getTaxes() + "%"));
        this.buttonMarriage[0].func_238482_a_((ITextComponent)new StringTextComponent(this.village.getMarriageThreshold() + "%"));
        this.buttonBirths[0].func_238482_a_((ITextComponent)new StringTextComponent(this.village.getPopulationThreshold() + "%"));
        BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.taxes"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + -60), (int)-1);
        if (!this.rank.isAtLeast(Rank.MERCHANT)) {
            BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.rankTooLow"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + -60 + 15), (int)-1);
            this.toggleButtons(this.buttonTaxes, false);
        } else {
            this.toggleButtons(this.buttonTaxes, true);
        }
        BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.birth"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + -10), (int)-1);
        if (!this.rank.isAtLeast(Rank.NOBLE)) {
            BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.rankTooLow"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + -10 + 15), (int)-1);
            this.toggleButtons(this.buttonBirths, false);
        } else {
            this.toggleButtons(this.buttonBirths, true);
        }
        BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.marriage"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 40), (int)-1);
        if (!this.rank.isAtLeast(Rank.MAYOR)) {
            BlueprintScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.blueprint.rankTooLow"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 40 + 15), (int)-1);
            this.toggleButtons(this.buttonMarriage, false);
        } else {
            this.toggleButtons(this.buttonMarriage, true);
        }
    }

    private ITextComponent getBlockName(ResourceLocation id) {
        if (Registry.field_212618_g.func_212607_c(id)) {
            return new TranslationTextComponent(((Block)Registry.field_212618_g.func_82594_a(id)).func_149739_a());
        }
        return new TranslationTextComponent("tag." + id.toString());
    }

    private void toggleButtons(Button[] buttons, boolean active) {
        for (Button b : buttons) {
            b.field_230693_o_ = active;
            b.field_230694_p_ = active;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.page.equals("villagers") && this.selectedVillager != null) {
            assert (this.field_230706_i_ != null);
            this.field_230706_i_.func_147108_a((Screen)new FamilyTreeScreen(this.selectedVillager));
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public void setVillage(Village village) {
        this.village = village;
        if (village == null) {
            this.setPage("empty");
        } else if (this.page.equals("waiting")) {
            this.setPage("map");
        }
    }

    public void setRank(Rank rank, int reputation, boolean isVillage, Set<String> completedTasks, Map<Rank, List<Task>> tasks, Map<String, BuildingType> buildingTypes) {
        this.rank = rank;
        this.reputation = reputation;
        this.isVillage = isVillage;
        this.completedTasks = completedTasks;
        this.tasks = tasks;
        this.buildingTypes = buildingTypes;
    }

    private /* synthetic */ void lambda$setPage$7(String page, Button b) {
        NetworkHandler.sendToServer(new ReportBuildingMessage(ReportBuildingMessage.Action.AUTO_SCAN));
        NetworkHandler.sendToServer(new GetVillageRequest());
        this.village.toggleAutoScan();
        this.setPage(page);
    }
}

