/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import forge.net.mca.MCA;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.server.world.data.VillageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.server.ServerWorld;

public enum Constraint implements BiPredicate<VillagerLike<?>, ServerPlayerEntity>
{
    FAMILY("family", Relationship.IS_FAMILY.asConstraint()),
    NOT_FAMILY("!family", Relationship.IS_FAMILY.negate().asConstraint()),
    BABY("baby", (villager, player) -> villager.getAgeState() == AgeState.BABY),
    NOT_BABY("!baby", (villager, player) -> villager.getAgeState() != AgeState.BABY),
    TODDLER("toddler", (villager, player) -> villager.getAgeState() == AgeState.TODDLER),
    NOT_TODDLER("!toddler", (villager, player) -> villager.getAgeState() != AgeState.TODDLER),
    TEEN("teen", (villager, player) -> villager.getAgeState() == AgeState.TEEN),
    NOT_TEEN("!teen", (villager, player) -> villager.getAgeState() != AgeState.TEEN),
    ADULT("adult", (villager, player) -> villager.getAgeState() == AgeState.ADULT),
    NOT_ADULT("!adult", (villager, player) -> villager.getAgeState() != AgeState.ADULT),
    SPOUSE("spouse", Relationship.IS_MARRIED.asConstraint()),
    NOT_SPOUSE("!spouse", Relationship.IS_MARRIED.negate().asConstraint()),
    ENGAGED("engaged", Relationship.IS_ENGAGED.asConstraint()),
    NOT_ENGAGED("!engaged", Relationship.IS_ENGAGED.negate().asConstraint()),
    PROMISED("promised", Relationship.IS_PROMISED.asConstraint()),
    NOT_PROMISED("!promised", Relationship.IS_PROMISED.negate().asConstraint()),
    KIDS("kids", Relationship.IS_PARENT.asConstraint()),
    NOT_KIDS("!kids", Relationship.IS_PARENT.negate().asConstraint()),
    CLERIC("cleric", (villager, player) -> villager.func_213700_eh().func_221130_b() == VillagerProfession.field_221155_e),
    NOT_CLERIC("!cleric", (villager, player) -> villager.func_213700_eh().func_221130_b() != VillagerProfession.field_221155_e),
    ADVENTURER("adventurer", (villager, player) -> villager.func_213700_eh().func_221130_b() == ProfessionsMCA.ADVENTURER.get()),
    NOT_ADVENTURER("!adventurer", (villager, player) -> villager.func_213700_eh().func_221130_b() != ProfessionsMCA.ADVENTURER.get()),
    MERCENARY("mercenary", (villager, player) -> villager.func_213700_eh().func_221130_b() == ProfessionsMCA.MERCENARY.get()),
    NOT_MERCENARY("!mercenary", (villager, player) -> villager.func_213700_eh().func_221130_b() != ProfessionsMCA.MERCENARY.get()),
    OUTLAWED("outlawed", (villager, player) -> villager.func_213700_eh().func_221130_b() == ProfessionsMCA.OUTLAW.get()),
    NOT_OUTLAWED("!outlawed", (villager, player) -> villager.func_213700_eh().func_221130_b() != ProfessionsMCA.OUTLAW.get()),
    TRADER("trader", (villager, player) -> villager.canTradeWithProfession()),
    NOT_TRADER("!trader", (villager, player) -> !villager.canTradeWithProfession()),
    PEASANT("peasant", (villager, player) -> Constraint.isRankAtLeast(villager, player, Rank.PEASANT)),
    NOT_PEASANT("!peasant", (villager, player) -> !Constraint.isRankAtLeast(villager, player, Rank.PEASANT)),
    NOBLE("noble", (villager, player) -> Constraint.isRankAtLeast(villager, player, Rank.NOBLE)),
    NOT_NOBLE("!noble", (villager, player) -> !Constraint.isRankAtLeast(villager, player, Rank.NOBLE)),
    MAYOR("mayor", (villager, player) -> Constraint.isRankAtLeast(villager, player, Rank.MAYOR)),
    NOT_MAYOR("!mayor", (villager, player) -> !Constraint.isRankAtLeast(villager, player, Rank.MAYOR)),
    MONARCH("monarch", (villager, player) -> Constraint.isRankAtLeast(villager, player, Rank.MONARCH)),
    NOT_MONARCH("!monarch", (villager, player) -> !Constraint.isRankAtLeast(villager, player, Rank.MONARCH)),
    ORPHAN("orphan", Relationship.IS_ORPHAN.asConstraint()),
    NOT_ORPHAN("!orphan", Relationship.IS_ORPHAN.negate().asConstraint()),
    FOLLOWING("following", (villager, player) -> villager.getVillagerBrain().getMoveState() == MoveState.FOLLOW),
    NOT_FOLLOWING("!following", (villager, player) -> villager.getVillagerBrain().getMoveState() != MoveState.FOLLOW),
    STAYING("staying", (villager, player) -> villager.getVillagerBrain().getMoveState() == MoveState.STAY),
    NOT_STAYING("!staying", (villager, player) -> villager.getVillagerBrain().getMoveState() != MoveState.STAY),
    VILLAGE_HAS_SPACE("village_has_space", (villager, player) -> PlayerSaveData.get(player).getLastSeenVillage(VillageManager.get((ServerWorld)player.field_70170_p)).filter(Village::hasSpace).isPresent()),
    NOT_VILLAGE_HAS_SPACE("!village_has_space", (villager, player) -> !PlayerSaveData.get(player).getLastSeenVillage(VillageManager.get((ServerWorld)player.field_70170_p)).filter(Village::hasSpace).isPresent()),
    HIT_BY("hit_by", (villager, player) -> {
        if (villager instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)villager;
            return v.isHitBy((ServerPlayerEntity)player);
        }
        return false;
    }),
    NOT_HIT_BY("!hit_by", (villager, player) -> !HIT_BY.test((VillagerLike<?>)villager, (ServerPlayerEntity)player));

    public static final Map<String, Constraint> REGISTRY;
    private final String id;
    private final BiPredicate<VillagerLike<?>, ServerPlayerEntity> check;

    private static boolean isRankAtLeast(VillagerLike<?> villager, ServerPlayerEntity player, Rank rank) {
        return player != null && villager instanceof VillagerEntityMCA && ((VillagerEntityMCA)villager).getResidency().getHomeVillage().filter(village -> Tasks.getRank(village, player).isAtLeast(rank)).isPresent();
    }

    private Constraint(String id, BiPredicate<VillagerLike<?>, ServerPlayerEntity> check) {
        this.id = id;
        this.check = check;
    }

    @Override
    public boolean test(VillagerLike<?> t, ServerPlayerEntity u) {
        return this.check.test(t, u);
    }

    public static Set<Constraint> all() {
        return new HashSet<Constraint>(REGISTRY.values());
    }

    public static Set<Constraint> allMatching(VillagerLike<?> villager, ServerPlayerEntity player) {
        return Stream.of(Constraint.values()).filter(c -> c.test(villager, player)).collect(Collectors.toSet());
    }

    public static List<Constraint> fromStringList(String constraints) {
        if (MCA.isBlankString(constraints)) {
            return new ArrayList<Constraint>();
        }
        return Stream.of(constraints.split(",")).map(REGISTRY::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static {
        REGISTRY = Stream.of(Constraint.values()).collect(Collectors.toMap(a -> a.id, Function.identity()));
    }
}

