/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.MCAClient;
import forge.net.mca.client.gui.VillagerEditorScreen;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.c2s.DestinyMessage;
import forge.net.mca.util.compat.RenderSystemCompat;
import forge.net.mca.util.localization.FlowingText;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DestinyScreen
extends VillagerEditorScreen {
    private static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("mca:textures/banner.png");
    private final LinkedList<ITextComponent> story = new LinkedList();
    private String location;
    private boolean teleported = false;
    private final boolean allowTeleportation;
    private Button acceptWidget;

    public DestinyScreen(UUID playerUUID, boolean allowTeleportation) {
        super(playerUUID, playerUUID);
        this.allowTeleportation = allowTeleportation;
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    public void func_231175_as__() {
        if (!this.page.equals("general") && !this.page.equals("story")) {
            this.setPage("destiny");
        }
    }

    @Override
    protected String[] getPages() {
        return new String[]{"general", "body", "head", "traits"};
    }

    public void func_230446_a_(MatrixStack matrices) {
        assert (Minecraft.func_71410_x().field_71441_e != null);
        this.func_231165_f_((int)Minecraft.func_71410_x().field_71441_e.func_82737_E());
    }

    private void drawScaledText(MatrixStack transform, ITextComponent text, int x, int y, float scale) {
        transform.func_227860_a_();
        transform.func_227862_a_(scale, scale, scale);
        DestinyScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)text, (int)((int)((float)x / scale)), (int)((int)((float)y / scale)), (int)-1);
        transform.func_227865_b_();
    }

    @Override
    public void func_230430_a_(MatrixStack transform, int mouseX, int mouseY, float delta) {
        super.func_230430_a_(transform, mouseX, mouseY, delta);
        switch (this.page) {
            case "general": {
                this.drawScaledText(transform, (ITextComponent)new TranslationTextComponent("gui.destiny.whoareyou"), this.field_230708_k_ / 2, this.field_230709_l_ / 2 - 24, 1.5f);
                transform.func_227860_a_();
                transform.func_227862_a_(0.25f, 0.25f, 0.25f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystemCompat.setShaderTexture(0, LOGO_TEXTURE);
                AbstractGui.func_238463_a_((MatrixStack)transform, (int)(this.field_230708_k_ * 2 - 512), (int)-40, (float)0.0f, (float)0.0f, (int)1024, (int)512, (int)1024, (int)512);
                transform.func_227865_b_();
                break;
            }
            case "destiny": {
                this.drawScaledText(transform, (ITextComponent)new TranslationTextComponent("gui.destiny.journey"), this.field_230708_k_ / 2, this.field_230709_l_ / 2 - 48, 1.5f);
                break;
            }
            case "story": {
                List<ITextComponent> text = FlowingText.wrap(this.story.getFirst(), 256);
                int y = (int)((float)(this.field_230709_l_ / 2 - 20) - 7.5f * (float)text.size());
                for (ITextComponent t : text) {
                    this.drawScaledText(transform, t, this.field_230708_k_ / 2, y, 1.25f);
                    y += 15;
                }
                break;
            }
        }
    }

    @Override
    protected boolean shouldDrawEntity() {
        return !this.page.equals("general") && !this.page.equals("destiny") && !this.page.equals("story") && super.shouldDrawEntity();
    }

    @Override
    protected void setPage(String page) {
        if (page.equals("destiny") && !this.allowTeleportation) {
            NetworkHandler.sendToServer(new DestinyMessage(true));
            MCAClient.getDestinyManager().allowClosing();
            super.func_231175_as__();
            return;
        }
        if (page.equals("destiny") && Config.getInstance().destinyLocations.size() == 1) {
            this.selectStory(Config.getInstance().destinyLocations.get(0));
            return;
        }
        this.page = page;
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        switch (page) {
            case "general": {
                this.drawName(this.field_230708_k_ / 2 - 87, this.field_230709_l_ / 2, name -> {
                    this.updateName((String)name);
                    if (this.acceptWidget != null) {
                        this.acceptWidget.field_230693_o_ = !MCA.isBlankString(name);
                    }
                });
                this.drawGender(this.field_230708_k_ / 2 - 87, this.field_230709_l_ / 2 + 24);
                this.drawModel(this.field_230708_k_ / 2 - 87, this.field_230709_l_ / 2 + 24 + 22);
                this.acceptWidget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 32, this.field_230709_l_ / 2 + 60 + 22, 64, 20, (ITextComponent)new TranslationTextComponent("gui.button.accept"), sender -> this.setPage("body")));
                break;
            }
            case "destiny": {
                int x = 0;
                int y = 0;
                for (String location : Config.getInstance().destinyLocations) {
                    int rows = (int)Math.ceil((float)Config.getInstance().destinyLocations.size() / 3.0f);
                    float offsetX = y + 1 == rows ? (float)(2 - (Config.getInstance().destinyLocations.size() - 1) % 3) / 2.0f : 0.0f;
                    float offsetY = (float)Math.max(0, 3 - rows) / 2.0f;
                    this.func_230480_a_((Widget)new Button((int)((float)(this.field_230708_k_ / 2) - 144.0f + ((float)x + offsetX) * 96.0f), (int)((float)(this.field_230709_l_ / 2) + ((float)y + offsetY) * 20.0f - 16.0f), 96, 20, (ITextComponent)new TranslationTextComponent("gui.destiny." + location), sender -> this.selectStory(location)));
                    if (++x < 3) continue;
                    x = 0;
                    ++y;
                }
                break;
            }
            case "story": {
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 48, this.field_230709_l_ / 2 + 32, 96, 20, (ITextComponent)new TranslationTextComponent("gui.destiny.next"), sender -> {
                    if (!this.teleported) {
                        NetworkHandler.sendToServer(new DestinyMessage(this.location));
                        MCAClient.getDestinyManager().allowClosing();
                        this.teleported = true;
                    }
                    if (this.story.size() > 1) {
                        this.story.remove(0);
                    } else {
                        NetworkHandler.sendToServer(new DestinyMessage(true));
                        super.func_231175_as__();
                    }
                }));
                break;
            }
            default: {
                super.setPage(page);
            }
        }
    }

    private void selectStory(String location) {
        this.story.clear();
        this.story.add((ITextComponent)new TranslationTextComponent("destiny.story.reason"));
        Map<String, String> map = Config.getInstance().destinyLocationsToTranslationMap;
        this.story.add((ITextComponent)new TranslationTextComponent(map.getOrDefault(location, map.getOrDefault("default", "missing_default"))));
        this.story.add((ITextComponent)new TranslationTextComponent("destiny.story." + location));
        this.location = location;
        this.setPage("story");
    }
}

