/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import forge.net.mca.client.book.Book;
import forge.net.mca.client.book.pages.Page;
import forge.net.mca.client.gui.widget.ExtendedPageTurnWidget;
import forge.net.mca.util.compat.RenderSystemCompat;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ExtendedBookScreen
extends Screen {
    private int pageIndex;
    private ChangePageButton nextPageButton;
    private ChangePageButton previousPageButton;
    private final Book book;

    public ExtendedBookScreen(Book book) {
        super(NarratorChatListener.field_216868_a);
        this.book = book;
        book.open();
        book.setPage(0, false);
    }

    public boolean setPage(int index) {
        int i = MathHelper.func_76125_a((int)index, (int)0, (int)(this.book.getPageCount() - 1));
        if (i != this.pageIndex) {
            this.book.setPage(i, false);
            this.pageIndex = i;
            this.updatePageButtons();
            return true;
        }
        return false;
    }

    protected boolean jumpToPage(int page) {
        return this.setPage(page);
    }

    protected void func_231160_c_() {
        this.addCloseButton();
        this.addPageButtons();
    }

    protected void addCloseButton() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, 196, 200, 20, DialogTexts.field_240632_c_, buttonWidget -> this.field_230706_i_.func_147108_a(null)));
    }

    protected void addPageButtons() {
        int i = (this.field_230708_k_ - 192) / 2;
        this.nextPageButton = (ChangePageButton)this.func_230480_a_((Widget)new ExtendedPageTurnWidget(i + 116, 159, true, buttonWidget -> this.goToNextPage(), this.book.hasPageTurnSound(), this.book.getBackground()));
        this.previousPageButton = (ChangePageButton)this.func_230480_a_((Widget)new ExtendedPageTurnWidget(i + 43, 159, false, buttonWidget -> this.goToPreviousPage(), this.book.hasPageTurnSound(), this.book.getBackground()));
        this.updatePageButtons();
    }

    protected void goToPreviousPage() {
        if (this.book.getPage(this.pageIndex).previousPage()) {
            if (this.pageIndex > 0) {
                --this.pageIndex;
                this.book.setPage(this.pageIndex, true);
            }
            this.updatePageButtons();
        }
    }

    protected void goToNextPage() {
        if (this.book.getPage(this.pageIndex).nextPage()) {
            if (this.pageIndex < this.book.getPageCount() - 1) {
                ++this.pageIndex;
                this.book.setPage(this.pageIndex, false);
            }
            this.updatePageButtons();
        }
    }

    private void updatePageButtons() {
        this.nextPageButton.field_230694_p_ = this.pageIndex < this.book.getPageCount() - 1;
        this.previousPageButton.field_230694_p_ = this.pageIndex > 0;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        switch (keyCode) {
            case 266: {
                this.previousPageButton.func_230930_b_();
                return true;
            }
            case 267: {
                this.nextPageButton.func_230930_b_();
                return true;
            }
        }
        return false;
    }

    public FontRenderer getTextRenderer() {
        return this.field_230712_o_;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        Page page;
        this.func_230446_a_(matrices);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystemCompat.setShaderTexture(0, this.book.getBackground());
        int i = (this.field_230708_k_ - 192) / 2;
        this.func_238474_b_(matrices, i, 2, 0, 0, 192, 192);
        if (this.book.getPageCount() > 1) {
            IFormattableTextComponent pageIndexText = new TranslationTextComponent("book.pageIndicator", new Object[]{this.pageIndex + 1, Math.max(this.book.getPageCount(), 1)}).func_240699_a_(this.book.getTextFormatting());
            int k = this.field_230712_o_.func_238414_a_((ITextProperties)pageIndexText);
            this.field_230712_o_.func_243248_b(matrices, (ITextComponent)pageIndexText, (float)(i - k + 192 - 44), 18.0f, 0);
        }
        if ((page = this.book.getPage(this.pageIndex)) != null) {
            page.render(this, matrices, mouseX, mouseY, delta);
        }
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_230455_a_(Style style) {
        ClickEvent clickEvent = style.func_150235_h();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.func_150669_a() == ClickEvent.Action.CHANGE_PAGE) {
            try {
                return this.jumpToPage(Integer.parseInt(clickEvent.func_150668_b()) - 1);
            }
            catch (Exception var5) {
                return false;
            }
        }
        boolean handled = super.func_230455_a_(style);
        if (handled && clickEvent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
            this.field_230706_i_.func_147108_a(null);
        }
        return handled;
    }
}

