/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.InteractScreen;
import forge.net.mca.client.gui.MCAScreens;
import forge.net.mca.client.resources.Icon;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.network.c2s.GetFamilyTreeRequest;
import forge.net.mca.util.compat.RenderSystemCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FamilyTreeScreen
extends Screen {
    private static final int HORIZONTAL_SPACING = 20;
    private static final int VERTICAL_SPACING = 60;
    private static final int SPOUSE_HORIZONTAL_SPACING = 50;
    private UUID focusedEntityId;
    private final Map<UUID, FamilyTreeNode> family = new HashMap<UUID, FamilyTreeNode>();
    private final TreeNode emptyNode;
    private TreeNode tree = this.emptyNode = new TreeNode();
    @Nullable
    private TreeNode focused;
    private double scrollX;
    private double scrollY;
    private final Screen parent;

    public FamilyTreeScreen(UUID entityId) {
        super((ITextComponent)new TranslationTextComponent("gui.family_tree.title"));
        this.focusedEntityId = entityId;
        this.parent = Minecraft.func_71410_x().field_71462_r;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void setFamilyData(UUID uuid, Map<UUID, FamilyTreeNode> family) {
        this.focusedEntityId = uuid;
        this.family.putAll(family);
        this.rebuildTree();
    }

    private boolean focusEntity(UUID id) {
        this.focusedEntityId = id;
        NetworkHandler.sendToServer(new GetFamilyTreeRequest(id));
        return false;
    }

    public void func_231160_c_() {
        this.focusEntity(this.focusedEntityId);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 25, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), sender -> this.func_231175_as__()));
    }

    public void func_231175_as__() {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_147108_a(this.parent);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            this.scrollX += deltaX;
            this.scrollY += deltaY;
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.focused != null) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.focusEntity(this.focused.id)) {
                this.rebuildTree();
            }
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        FamilyTreeScreen.func_238467_a_((MatrixStack)matrices, (int)0, (int)30, (int)this.field_230708_k_, (int)(this.field_230709_l_ - 30), (int)0x66000000);
        this.focused = null;
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        double f = window.func_198100_s();
        int windowHeight = (int)Math.round((double)window.func_198087_p() * f);
        int x = 0;
        int y = (int)(30.0 * f);
        int w = (int)((double)this.field_230708_k_ * f);
        int h = (int)((double)(this.field_230709_l_ - 60) * f);
        GL11.glScissor((int)x, (int)(windowHeight - h - y), (int)w, (int)h);
        GL11.glEnable((int)3089);
        matrices.func_227860_a_();
        int xx = (int)(this.scrollX + (double)(this.field_230708_k_ / 2));
        int yy = (int)(this.scrollY + (double)(this.field_230709_l_ / 2));
        matrices.func_227861_a_((double)xx, (double)yy, 0.0);
        this.tree.render(matrices, mouseX - xx, mouseY - yy);
        matrices.func_227865_b_();
        GL11.glDisable((int)3089);
        FamilyTreeNode selected = this.family.get(this.focusedEntityId);
        ITextComponent label = selected == null ? this.field_230704_d_ : new StringTextComponent(selected.getName()).func_240702_b_("'s ").func_230529_a_(this.field_230704_d_);
        FamilyTreeScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)label, (int)(this.field_230708_k_ / 2), (int)10, (int)0xFFFFFF);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private void rebuildTree() {
        this.scrollX = 14.0;
        this.scrollY = -69.0;
        FamilyTreeNode focusedNode = this.family.get(this.focusedEntityId);
        this.focused = null;
        this.tree = this.emptyNode;
        if (focusedNode != null) {
            this.tree = this.insertParents(new TreeNode(focusedNode, true), focusedNode, 2);
        }
    }

    private TreeNode insertParents(TreeNode root, FamilyTreeNode focusedNode, int levels) {
        @Nullable FamilyTreeNode father = this.family.get(focusedNode.father());
        @Nullable FamilyTreeNode mother = this.family.get(focusedNode.mother());
        @Nullable FamilyTreeNode newRoot = father != null ? father : mother;
        TreeNode fNode = newRoot == null ? new TreeNode() : new TreeNode(newRoot, false);
        fNode.children.add(root);
        @Nullable FamilyTreeNode spouse = newRoot == father ? mother : father;
        TreeNode treeNode = fNode.spouse = spouse == null ? new TreeNode() : new TreeNode(spouse, false);
        if (newRoot != null && levels > 0) {
            return this.insertParents(fNode, newRoot, levels - 1);
        }
        return fNode;
    }

    private final class TreeNode {
        private boolean widthComputed;
        private int width;
        private int labelWidth;
        private final List<ITextComponent> label = new ArrayList<ITextComponent>();
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private Bounds bounds;
        TreeNode spouse;
        final UUID id;
        final boolean deceased;
        private final RelationshipState relationship;
        private final String defaultNodeName = "???";

        private TreeNode() {
            this.id = null;
            this.deceased = false;
            this.relationship = RelationshipState.SINGLE;
            this.label.add((ITextComponent)new StringTextComponent("???"));
        }

        public TreeNode(FamilyTreeNode node, boolean recurse) {
            this(node, new HashSet<UUID>(), recurse);
        }

        public TreeNode(FamilyTreeNode node, Set<UUID> parsed, boolean recurse) {
            this.id = node.id();
            this.deceased = node.isDeceased();
            this.relationship = node.getRelationshipState();
            StringTextComponent text = new StringTextComponent(MCA.isBlankString(node.getName()) ? "???" : node.getName());
            this.label.add((ITextComponent)text.func_230530_a_(text.func_150256_b().func_240718_a_(Color.func_240743_a_((int)node.gender().getColor()))));
            this.label.add((ITextComponent)node.getProfessionText().func_240699_a_(TextFormatting.GRAY));
            FamilyTreeNode father = (FamilyTreeNode)FamilyTreeScreen.this.family.get(node.father());
            FamilyTreeNode mother = (FamilyTreeNode)FamilyTreeScreen.this.family.get(node.mother());
            if ((father == null || father.isDeceased()) && (mother == null || mother.isDeceased())) {
                this.label.add((ITextComponent)new TranslationTextComponent("gui.family_tree.label.orphan").func_240699_a_(TextFormatting.GRAY));
            }
            if (node.getRelationshipState() != RelationshipState.SINGLE) {
                this.label.add((ITextComponent)new TranslationTextComponent("marriage." + node.getRelationshipState().base().getIcon()));
            }
            if (recurse) {
                node.children().forEach(child -> {
                    FamilyTreeNode e = (FamilyTreeNode)FamilyTreeScreen.this.family.get(child);
                    if (e != null) {
                        this.children.add(new TreeNode(e, parsed, parsed.add((UUID)child)));
                    }
                });
                FamilyTreeNode spouse = (FamilyTreeNode)FamilyTreeScreen.this.family.get(node.partner());
                if (spouse != null) {
                    this.spouse = new TreeNode(spouse, parsed, false);
                } else if (!this.children.isEmpty()) {
                    this.spouse = new TreeNode();
                }
            }
        }

        public void render(MatrixStack matrices, int mouseX, int mouseY) {
            boolean isFocused;
            Bounds bounds = this.getBounds();
            boolean bl = isFocused = this.id != null && bounds.contains(mouseX, mouseY);
            if (isFocused) {
                FamilyTreeScreen.this.focused = this;
            }
            int childrenStartX = -this.getWidth() / 2;
            for (TreeNode node : this.children) {
                int x = (childrenStartX += (node.getWidth() + 20) / 2) + 10;
                int y = 60;
                this.drawHook(matrices, x, y);
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)x, (double)y, 0.0);
                node.render(matrices, mouseX - x, mouseY - y);
                matrices.func_227865_b_();
                childrenStartX += (node.getWidth() + 20) / 2;
            }
            matrices.func_227860_a_();
            matrices.func_227861_a_(0.0, 0.0, 400.0);
            int fillColor = isFocused ? -267386816 : -267386864;
            int borderColor = isFocused ? -14155649 : 0x505000FF;
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)bounds.left, (int)(bounds.top + 1), (int)(bounds.left + 1), (int)(bounds.bottom - 1), (int)fillColor);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)(bounds.right - 1), (int)(bounds.top + 1), (int)bounds.right, (int)(bounds.bottom - 1), (int)fillColor);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)(bounds.left + 1), (int)bounds.top, (int)(bounds.right - 1), (int)bounds.bottom, (int)fillColor);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)(bounds.left + 1), (int)(bounds.top + 1), (int)(bounds.left + 2), (int)(bounds.bottom - 1), (int)borderColor);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)(bounds.right - 2), (int)(bounds.top + 1), (int)(bounds.right - 1), (int)(bounds.bottom - 1), (int)borderColor);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)(bounds.left + 2), (int)(bounds.top + 1), (int)(bounds.right - 2), (int)(bounds.top + 2), (int)borderColor);
            AbstractGui.func_238467_a_((MatrixStack)matrices, (int)(bounds.left + 2), (int)(bounds.bottom - 2), (int)(bounds.right - 2), (int)(bounds.bottom - 1), (int)borderColor);
            IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            int l = bounds.top + 5;
            int k = bounds.left + 6;
            if (this.deceased) {
                k += 20;
            }
            Matrix4f matrix4f = matrices.func_227866_c_().func_227870_a_();
            FontRenderer r = Minecraft.func_71410_x().field_71466_p;
            for (int s = 0; s < this.label.size(); ++s) {
                ITextComponent line = this.label.get(s);
                if (line != null) {
                    r.func_243247_a(line, (float)k, (float)l, -1, true, matrix4f, (IRenderTypeBuffer)immediate, false, 0, 0xF000F0);
                }
                if (s == 0) {
                    l += 2;
                }
                l += 10;
            }
            immediate.func_228461_a_();
            matrices.func_227865_b_();
            RenderSystemCompat.setShaderTexture(0, InteractScreen.ICON_TEXTURES);
            if (this.deceased) {
                Icon icon = MCAScreens.getInstance().getIcon("deceased");
                AbstractGui.func_238464_a_((MatrixStack)matrices, (int)(bounds.left + 6), (int)(bounds.top + 6), (int)0, (float)icon.u(), (float)icon.v(), (int)16, (int)16, (int)256, (int)256);
                if (isFocused && mouseX <= bounds.left + 20) {
                    matrices.func_227860_a_();
                    matrices.func_227861_a_(0.0, 0.0, 20.0);
                    FamilyTreeScreen.this.func_238652_a_(matrices, (ITextComponent)new TranslationTextComponent("gui.family_tree.label.deceased"), mouseX, mouseY);
                    matrices.func_227865_b_();
                }
            }
            if (this.spouse != null) {
                int x = bounds.left - 50;
                int y = bounds.top + bounds.bottom / 2;
                FamilyTreeScreen.this.func_238465_a_(matrices, x, bounds.left - 1, y, -1);
                if (this.relationship == RelationshipState.MARRIED_TO_PLAYER || this.relationship == RelationshipState.MARRIED_TO_VILLAGER || this.relationship == RelationshipState.ENGAGED || this.relationship == RelationshipState.PROMISED || this.relationship == RelationshipState.WIDOW) {
                    Icon icon = MCAScreens.getInstance().getIcon(this.relationship.getIcon());
                    AbstractGui.func_238464_a_((MatrixStack)matrices, (int)(bounds.left - 25 - 8), (int)(y - 8), (int)0, (float)icon.u(), (float)icon.v(), (int)16, (int)16, (int)256, (int)256);
                }
                int n = this.spouse.label.size();
                Objects.requireNonNull(FamilyTreeScreen.this.field_230712_o_);
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)(x -= this.spouse.getWidth() / 2 - 6), (double)(y -= n * 9 / 2), 0.0);
                this.spouse.render(matrices, mouseX - x, mouseY - y);
                matrices.func_227865_b_();
            }
        }

        private void drawHook(MatrixStack matrices, int endX, int endY) {
            int midY = endY / 2;
            FamilyTreeScreen.this.func_238473_b_(matrices, 0, 0, midY, -1);
            FamilyTreeScreen.this.func_238465_a_(matrices, 0, endX, midY, -1);
            FamilyTreeScreen.this.func_238473_b_(matrices, endX, midY, endY, -1);
        }

        public int getWidth() {
            if (!this.widthComputed) {
                this.widthComputed = true;
                this.labelWidth = this.label.stream().mapToInt(arg_0 -> ((FontRenderer)FamilyTreeScreen.this.field_230712_o_).func_238414_a_(arg_0)).max().orElse(0);
                if (this.deceased) {
                    this.labelWidth += 20;
                }
                this.width = Math.max(this.labelWidth + 10, this.children.stream().mapToInt(TreeNode::getWidth).sum()) + 10;
                if (this.spouse != null) {
                    this.width += this.spouse.getWidth() + 50;
                }
            }
            return this.width;
        }

        public Bounds getBounds() {
            if (this.bounds == null) {
                this.getWidth();
                int padding = 4;
                int n = -this.labelWidth / 2 - padding;
                int n2 = this.labelWidth / 2 + padding * 2;
                int n3 = -padding;
                Objects.requireNonNull(FamilyTreeScreen.this.field_230712_o_);
                this.bounds = new Bounds(n, n2, n3, 9 * this.label.size() + padding * 2);
            }
            return this.bounds;
        }
    }

    static final class Bounds {
        final int left;
        final int right;
        final int top;
        final int bottom;

        public Bounds(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public Bounds add(int x, int y) {
            return new Bounds(this.left + x, this.right + x, this.top + y, this.bottom + y);
        }

        public boolean contains(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX <= this.right && mouseY <= this.bottom;
        }
    }
}

