/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.network.c2s.FamilyTreeUUIDLookup;
import forge.net.mca.resources.data.SerializablePair;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FamilyTreeSearchScreen
extends Screen {
    static final int DATA_WIDTH = 120;
    private List<SerializablePair<UUID, SerializablePair<String, String>>> list = new LinkedList<SerializablePair<UUID, SerializablePair<String, String>>>();
    private Button buttonPage;
    private int pageNumber;
    private UUID selectedVillager;
    private int mouseX;
    private int mouseY;

    public FamilyTreeSearchScreen() {
        super((ITextComponent)new TranslationTextComponent("gui.family_tree.title"));
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231160_c_() {
        TextFieldWidget field = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 2 - 80, 120, 18, (ITextComponent)new TranslationTextComponent("structure_block.structure_name")));
        field.func_146203_f(32);
        field.func_212954_a(this::searchVillager);
        field.func_146195_b(true);
        this.func_231035_a_((IGuiEventListener)field);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 44, this.field_230709_l_ / 2 + 82, 88, 20, (ITextComponent)new TranslationTextComponent("gui.done"), sender -> this.func_231175_as__()));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 24 - 20, this.field_230709_l_ / 2 + 60, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
            if (this.pageNumber > 0) {
                --this.pageNumber;
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 24, this.field_230709_l_ / 2 + 60, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
            if ((double)this.pageNumber < Math.ceil((double)this.list.size() / 9.0) - 1.0) {
                ++this.pageNumber;
            }
        }));
        this.buttonPage = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 24, this.field_230709_l_ / 2 + 60, 48, 20, (ITextComponent)new StringTextComponent("0/0)"), b -> {}));
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        assert (this.field_230706_i_ != null);
        this.mouseX = (int)(this.field_230706_i_.field_71417_B.func_198024_e() * (double)this.field_230708_k_ / (double)this.field_230706_i_.func_228018_at_().func_198109_k());
        this.mouseY = (int)(this.field_230706_i_.field_71417_B.func_198026_f() * (double)this.field_230709_l_ / (double)this.field_230706_i_.func_228018_at_().func_198091_l());
        FamilyTreeSearchScreen.func_238467_a_((MatrixStack)matrices, (int)(this.field_230708_k_ / 2 - 60 - 10), (int)(this.field_230709_l_ / 2 - 110), (int)(this.field_230708_k_ / 2 + 60 + 10), (int)(this.field_230709_l_ / 2 + 110), (int)0x66000000);
        this.func_230446_a_(matrices);
        this.renderVillagers(matrices);
        FamilyTreeSearchScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.title.family_tree"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 100), (int)0xFFFFFF);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private void renderVillagers(MatrixStack transform) {
        int index;
        int maxPages = (int)Math.ceil((double)this.list.size() / 9.0);
        this.buttonPage.func_238482_a_((ITextComponent)new StringTextComponent(this.pageNumber + 1 + "/" + maxPages));
        this.selectedVillager = null;
        for (int i = 0; i < 9 && (index = i + this.pageNumber * 9) < this.list.size(); ++i) {
            int y = this.field_230709_l_ / 2 - 52 + i * 12;
            boolean hover = this.isMouseWithin(this.field_230708_k_ / 2 - 50, y - 1, 100, 12);
            SerializablePair<UUID, SerializablePair<String, String>> pair = this.list.get(index);
            String left = pair.getRight().getLeft();
            String right = pair.getRight().getRight();
            TranslationTextComponent text = MCA.isBlankString(left) && MCA.isBlankString(right) ? new TranslationTextComponent("gui.family_tree.child_of_0") : (MCA.isBlankString(left) ? new TranslationTextComponent("gui.family_tree.child_of_1", new Object[]{right}) : (MCA.isBlankString(right) ? new TranslationTextComponent("gui.family_tree.child_of_1", new Object[]{left}) : new TranslationTextComponent("gui.family_tree.child_of_2", new Object[]{left, right})));
            FamilyTreeSearchScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)text, (int)(this.field_230708_k_ / 2), (int)y, (int)(hover ? -2631804 : -1));
            if (!hover) continue;
            this.selectedVillager = pair.getLeft();
        }
    }

    private void searchVillager(String v) {
        if (!MCA.isBlankString(v)) {
            NetworkHandler.sendToServer(new FamilyTreeUUIDLookup(v));
        }
    }

    public void setList(List<SerializablePair<UUID, SerializablePair<String, String>>> list) {
        this.list = list;
    }

    protected boolean isMouseWithin(int x, int y, int w, int h) {
        return this.mouseX >= x && this.mouseX < x + w && this.mouseY >= y && this.mouseY < y + h;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.selectedVillager != null) {
            this.field_230706_i_.func_147108_a((Screen)new FamilyTreeScreen(this.selectedVillager));
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }
}

