/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.MCA;
import forge.net.mca.client.gui.AbstractDynamicScreen;
import forge.net.mca.client.gui.Button;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.brain.VillagerBrain;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.entity.ai.relationship.RelationshipState;
import forge.net.mca.network.c2s.GetInteractDataRequest;
import forge.net.mca.network.c2s.InteractionCloseRequest;
import forge.net.mca.network.c2s.InteractionDialogueInitMessage;
import forge.net.mca.network.c2s.InteractionDialogueMessage;
import forge.net.mca.network.c2s.InteractionVillagerMessage;
import forge.net.mca.resources.data.analysis.Analysis;
import forge.net.mca.resources.data.dialogue.Question;
import forge.net.mca.util.compat.RenderSystemCompat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class InteractScreen
extends AbstractDynamicScreen {
    public static final ResourceLocation ICON_TEXTURES = MCA.locate("textures/gui.png");
    private final VillagerLike<?> villager;
    private final PlayerEntity player;
    private boolean inGiftMode;
    private int timeSinceLastClick;
    private String father;
    private String mother;
    private RelationshipState marriageState;
    private ITextComponent spouse;
    private List<String> dialogAnswers;
    private String dialogAnswerHover;
    private List<IReorderingProcessor> dialogQuestionText;
    private String dialogQuestionId;
    private static Analysis<?> analysis;

    public InteractScreen(VillagerLike<?> villager) {
        super((ITextComponent)new StringTextComponent("Interact"));
        this.player = (PlayerEntity)Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g);
        this.villager = villager;
    }

    public void setParents(String father, String mother) {
        this.father = father;
        this.mother = mother;
    }

    public void setSpouse(RelationshipState marriageState, String spouse) {
        this.marriageState = marriageState;
        this.spouse = spouse == null ? new TranslationTextComponent("gui.interact.label.parentUnknown") : new StringTextComponent(spouse);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231175_as__() {
        Objects.requireNonNull(this.field_230706_i_).func_147108_a(null);
        NetworkHandler.sendToServer(new InteractionCloseRequest(this.villager.asEntity().func_110124_au()));
    }

    public void func_231160_c_() {
        NetworkHandler.sendToServer(new GetInteractDataRequest(this.villager.asEntity().func_110124_au()));
    }

    public void func_231023_e_() {
        ++this.timeSinceLastClick;
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float tickDelta) {
        super.func_230430_a_(matrices, mouseX, mouseY, tickDelta);
        this.drawIcons(matrices);
        this.drawTextPopups(matrices);
    }

    public boolean func_231043_a_(double x, double y, double d) {
        if (d < 0.0) {
            this.player.field_71071_by.field_70461_c = this.player.field_71071_by.field_70461_c == 8 ? 0 : this.player.field_71071_by.field_70461_c + 1;
        } else if (d > 0.0) {
            this.player.field_71071_by.field_70461_c = this.player.field_71071_by.field_70461_c == 0 ? 8 : this.player.field_71071_by.field_70461_c - 1;
        }
        return super.func_231043_a_(x, y, d);
    }

    public boolean func_231044_a_(double posX, double posY, int button) {
        super.func_231044_a_(posX, posY, button);
        if (button == 0 && this.dialogAnswerHover != null && this.dialogQuestionText != null) {
            NetworkHandler.sendToServer(new InteractionDialogueMessage(this.villager.asEntity().func_110124_au(), this.dialogQuestionId, this.dialogAnswerHover));
        }
        if (this.inGiftMode && button == 1) {
            NetworkHandler.sendToServer(new InteractionVillagerMessage("gui.button.gift", this.villager.asEntity().func_110124_au()));
            return true;
        }
        return false;
    }

    public boolean func_231046_a_(int keyChar, int keyCode, int unknown) {
        if (keyChar == 256) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                this.setLayout("interact");
            } else {
                this.func_231175_as__();
            }
            return true;
        }
        return false;
    }

    private void drawIcons(MatrixStack transform) {
        Memories memory = this.villager.getVillagerBrain().getMemoriesForPlayer(this.player);
        transform.func_227860_a_();
        transform.func_227862_a_(1.5f, 1.5f, 1.5f);
        RenderSystemCompat.setShaderTexture(0, ICON_TEXTURES);
        if (this.marriageState != null) {
            this.drawIcon(transform, this.marriageState.getIcon());
        }
        this.drawIcon(transform, memory.getHearts() < 0 ? "blackHeart" : (memory.getHearts() >= 100 ? "goldHeart" : "redHeart"));
        this.drawIcon(transform, "genes");
        if (this.canDrawParentsIcon()) {
            this.drawIcon(transform, "parents");
        }
        if (this.canDrawGiftIcon()) {
            this.drawIcon(transform, "gift");
        }
        if (analysis != null) {
            this.drawIcon(transform, "analysis");
        }
        transform.func_227865_b_();
    }

    private void drawTextPopups(MatrixStack transform) {
        int h = 17;
        if (this.inGiftMode) {
            this.func_238652_a_(transform, (ITextComponent)new TranslationTextComponent("gui.interact.label.giveGift"), 10, 28);
        } else {
            this.func_238652_a_(transform, this.villager.asEntity().func_200200_C_(), 10, 28);
        }
        this.func_238652_a_(transform, (ITextComponent)(this.villager.asEntity().func_70631_g_() ? this.villager.getAgeState().getName() : this.villager.getProfessionText()), 10, 30 + h);
        VillagerBrain<?> brain = this.villager.getVillagerBrain();
        this.func_238652_a_(transform, (ITextComponent)new TranslationTextComponent("gui.interact.label.mood", new Object[]{brain.getMood().getText()}).func_240699_a_(brain.getMood().getColor()), 10, 30 + h * 2);
        if (this.hoveringOverText(10, 30 + h * 3, 128)) {
            this.func_238652_a_(transform, brain.getPersonality().getDescription(), 10, 30 + h * 3);
        } else {
            this.func_238652_a_(transform, (ITextComponent)new TranslationTextComponent("gui.interact.label.personality", new Object[]{brain.getPersonality().getName()}).func_240699_a_(TextFormatting.WHITE), 10, 30 + h * 3);
        }
        Set<Traits.Trait> traits = this.villager.getTraits().getTraits();
        if (traits.size() > 0) {
            Object traitText;
            if (this.hoveringOverText(10, 30 + h * 4, 128)) {
                traitText = traits.stream().map(Traits.Trait::getDescription).collect(Collectors.toList());
                traitText.add(0, new TranslationTextComponent("traits.title"));
                this.func_243308_b(transform, (List)traitText, 10, 30 + h * 4);
            } else {
                traitText = new TranslationTextComponent("traits.title");
                traits.stream().map(Traits.Trait::getName).forEach(arg_0 -> InteractScreen.lambda$drawTextPopups$0((TranslationTextComponent)traitText, arg_0));
                this.func_238652_a_(transform, (ITextComponent)traitText, 10, 30 + h * 4);
            }
        }
        if (this.hoveringOverIcon("redHeart")) {
            int hearts = brain.getMemoriesForPlayer(this.player).getHearts();
            this.drawHoveringIconText(transform, (ITextComponent)new StringTextComponent(hearts + " hearts"), "redHeart");
        }
        if (this.marriageState != null && this.hoveringOverIcon("married") && this.villager instanceof CompassionateEntity) {
            String ms = this.marriageState.base().getIcon().toLowerCase(Locale.ENGLISH);
            this.drawHoveringIconText(transform, (ITextComponent)new TranslationTextComponent("gui.interact.label." + ms, new Object[]{this.spouse}), "married");
        }
        if (this.canDrawParentsIcon() && this.hoveringOverIcon("parents")) {
            this.drawHoveringIconText(transform, (ITextComponent)new TranslationTextComponent("gui.interact.label.parents", new Object[]{this.father == null ? new TranslationTextComponent("gui.interact.label.parentUnknown") : this.father, this.mother == null ? new TranslationTextComponent("gui.interact.label.parentUnknown") : this.mother}), "parents");
        }
        if (this.canDrawGiftIcon() && this.hoveringOverIcon("gift")) {
            this.drawHoveringIconText(transform, (ITextComponent)new TranslationTextComponent("gui.interact.label.gift"), "gift");
        }
        if (this.hoveringOverIcon("genes")) {
            LinkedList<ITextComponent> lines = new LinkedList<ITextComponent>();
            lines.add((ITextComponent)new StringTextComponent("Genes"));
            for (Genetics.Gene gene : this.villager.getGenetics()) {
                String key = gene.getType().getTranslationKey();
                int value = (int)(gene.get() * 100.0f);
                lines.add((ITextComponent)new TranslationTextComponent("gene.tooltip", new Object[]{new TranslationTextComponent(key), value}));
            }
            this.drawHoveringIconText(transform, lines, "genes");
        }
        if (this.hoveringOverIcon("analysis") && analysis != null) {
            LinkedList<ITextComponent> lines = new LinkedList<ITextComponent>();
            lines.add((ITextComponent)new TranslationTextComponent("analysis.title").func_240699_a_(TextFormatting.GRAY));
            for (Analysis.AnalysisElement d : analysis) {
                lines.add((ITextComponent)new TranslationTextComponent("analysis." + d.getKey()).func_230529_a_((ITextComponent)new StringTextComponent(": " + (d.isPositive() ? "+" : "") + d.getValue())).func_240699_a_(d.isPositive() ? TextFormatting.GREEN : TextFormatting.RED));
            }
            String chance = analysis.getTotalAsString();
            lines.add((ITextComponent)new TranslationTextComponent("analysis.total").func_240702_b_(": " + (String)chance));
            this.drawHoveringIconText(transform, lines, "analysis");
        }
        if (this.dialogQuestionText != null) {
            InteractScreen.func_238467_a_((MatrixStack)transform, (int)(this.field_230708_k_ / 2 - 85), (int)(this.field_230709_l_ / 2 - 50 - 10 * this.dialogQuestionText.size()), (int)(this.field_230708_k_ / 2 + 85), (int)(this.field_230709_l_ / 2 - 30 + 10 * this.dialogAnswers.size()), (int)0x77000000);
            int i = -this.dialogQuestionText.size();
            for (IReorderingProcessor t : this.dialogQuestionText) {
                this.field_230712_o_.func_238407_a_(transform, t, (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_243245_a(t) / 2.0f, (float)this.field_230709_l_ / 2.0f - 50.0f + (float)(++i * 10), -1);
            }
            this.dialogAnswerHover = null;
            this.func_238465_a_(transform, this.field_230708_k_ / 2 - 75, this.field_230708_k_ / 2 + 75, this.field_230709_l_ / 2 - 40, -1426063361);
            int y = this.field_230709_l_ / 2 - 35;
            for (String a : this.dialogAnswers) {
                boolean hover = this.hoveringOver(this.field_230708_k_ / 2 - 100, y - 3, 200, 10);
                InteractScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent(Question.getTranslationKey(this.dialogQuestionId, a)), (int)(this.field_230708_k_ / 2), (int)y, (int)(hover ? -2631804 : -1426063361));
                if (hover) {
                    this.dialogAnswerHover = a;
                }
                y += 10;
            }
        }
    }

    private boolean hoveringOverText(int x, int y, int w) {
        return this.hoveringOver(x + 8, y - 16, w, 16);
    }

    private boolean canDrawParentsIcon() {
        return this.father != null || this.mother != null;
    }

    private boolean canDrawGiftIcon() {
        return false;
    }

    public void setDialogue(String dialogue, List<String> answers, boolean silent) {
        this.dialogQuestionId = dialogue;
        this.dialogAnswers = answers;
        TranslationTextComponent translatable = this.villager.getTranslatable(this.player, Question.getTranslationKey(this.dialogQuestionId), new Object[0]);
        this.dialogQuestionText = this.field_230712_o_.func_238425_b_((ITextProperties)translatable, 160);
        if (!silent) {
            this.villager.sendChatMessage((IFormattableTextComponent)translatable, (Entity)this.player);
        }
    }

    @Override
    protected void buttonPressed(Button button) {
        String id = button.identifier();
        if (this.timeSinceLastClick <= 2) {
            return;
        }
        this.timeSinceLastClick = 0;
        if (id.equals("gui.button.interact")) {
            this.setLayout("interact");
        } else if (id.equals("gui.button.command")) {
            this.setLayout("command");
            this.disableButton("gui.button." + this.villager.getVillagerBrain().getMoveState().name().toLowerCase(Locale.ENGLISH));
        } else if (id.equals("gui.button.clothing")) {
            this.setLayout("clothing");
        } else if (id.equals("gui.button.familyTree")) {
            Minecraft.func_71410_x().func_147108_a((Screen)new FamilyTreeScreen(this.villager.asEntity().func_110124_au()));
        } else if (id.equals("gui.button.talk")) {
            this.field_230705_e_.clear();
            this.field_230710_m_.clear();
            NetworkHandler.sendToServer(new InteractionDialogueInitMessage(this.villager.asEntity().func_110124_au()));
        } else if (id.equals("gui.button.work")) {
            this.setLayout("work");
            this.disableButton("gui.button." + this.villager.getVillagerBrain().getCurrentJob().name().toLowerCase(Locale.ENGLISH));
        } else if (id.equals("gui.button.professions")) {
            this.setLayout("professions");
        } else if (id.equals("gui.button.backarrow")) {
            if (this.inGiftMode) {
                this.inGiftMode = false;
                this.setLayout("interact");
            } else if (this.getActiveScreen().equals("locations")) {
                this.setLayout("interact");
            } else {
                this.setLayout("main");
            }
        } else if (id.equals("gui.button.locations")) {
            this.setLayout("locations");
        } else if (button.notifyServer()) {
            if (!button.targetServer()) {
                NetworkHandler.sendToServer(new InteractionVillagerMessage(id, this.villager.asEntity().func_110124_au()));
            }
        } else if (id.equals("gui.button.gift")) {
            this.inGiftMode = true;
            this.disableAllButtons();
        }
    }

    public static void setAnalysis(Analysis<?> analysis) {
        InteractScreen.analysis = analysis;
    }

    private static /* synthetic */ void lambda$drawTextPopups$0(TranslationTextComponent traitText, ITextComponent t) {
        if (traitText.func_150253_a().size() > 0) {
            traitText.func_230529_a_((ITextComponent)new StringTextComponent(", "));
        }
        traitText.func_230529_a_(t);
    }
}

