/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.client.gui.widget.ColorPickerWidget;
import forge.net.mca.client.gui.widget.GeneSliderWidget;
import forge.net.mca.client.gui.widget.NamedTextFieldWidget;
import forge.net.mca.client.gui.widget.TooltipButtonWidget;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.Personality;
import forge.net.mca.network.c2s.GetVillagerRequest;
import forge.net.mca.network.c2s.SkinListRequest;
import forge.net.mca.network.c2s.VillagerEditorSyncRequest;
import forge.net.mca.network.c2s.VillagerNameRequest;
import forge.net.mca.resources.ClothingList;
import forge.net.mca.resources.HairList;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class VillagerEditorScreen
extends Screen {
    final UUID villagerUUID;
    final UUID playerUUID;
    final boolean allowPlayerModel;
    final boolean allowVillagerModel;
    private int villagerBreedingAge;
    protected String page;
    protected final VillagerEntityMCA villager;
    protected final VillagerEntityMCA villagerVisualization;
    protected static final int DATA_WIDTH = 175;
    private int traitPage;
    private static final int TRAITS_PER_PAGE = 8;
    protected CompoundNBT villagerData;
    private TextFieldWidget villagerNameField;
    private int clothingPage;
    private int clothingPageCount;
    private Button pageButtonWidget;
    private List<String> filteredClothing;
    private List<String> filteredHair;
    private static HashMap<String, ClothingList.Clothing> clothing = new HashMap();
    private static HashMap<String, HairList.Hair> hair = new HashMap();
    private Gender filterGender;
    private String searchString;
    private int hoveredClothingId;
    int CLOTHES_H;
    int CLOTHES_V;
    int CLOTHES_PER_PAGE;
    Button widgetMasculine;
    Button widgetFeminine;
    private Button villagerSkinWidget;
    private Button playerSkinWidget;
    private Button vanillaSkinWidget;
    private Button doneWidget;
    private Button genderButtonFemale;
    private Button genderButtonMale;

    public VillagerEditorScreen(UUID villagerUUID, UUID playerUUID, boolean allowPlayerModel, boolean allowVillagerModel) {
        super((ITextComponent)new TranslationTextComponent("gui.VillagerEditorScreen.title"));
        this.villager = Objects.requireNonNull((VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).func_200721_a((World)Minecraft.func_71410_x().field_71441_e));
        this.villagerVisualization = Objects.requireNonNull((VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).func_200721_a((World)Minecraft.func_71410_x().field_71441_e));
        this.traitPage = 0;
        this.filteredClothing = new LinkedList<String>();
        this.filteredHair = new LinkedList<String>();
        this.filterGender = Gender.NEUTRAL;
        this.searchString = "";
        this.CLOTHES_H = 8;
        this.CLOTHES_V = 2;
        this.CLOTHES_PER_PAGE = this.CLOTHES_H * this.CLOTHES_V + 1;
        this.villagerUUID = villagerUUID;
        this.playerUUID = playerUUID;
        this.allowPlayerModel = allowPlayerModel;
        this.allowVillagerModel = allowVillagerModel;
        if (clothing.isEmpty()) {
            NetworkHandler.sendToServer(new SkinListRequest());
        }
        this.requestVillagerData();
        this.setPage(this.page != null ? this.page : "loading");
    }

    public VillagerEditorScreen(UUID villagerUUID, UUID playerUUID) {
        this(villagerUUID, playerUUID, MCA.isPlayerRendererAllowed(), MCA.isVillagerRendererAllowed());
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_231160_c_() {
        this.setPage(this.page);
    }

    private int doubleGeneSliders(int y, Genetics.GeneType ... genes) {
        boolean right = false;
        Genetics genetics = this.villager.getGenetics();
        for (Genetics.GeneType g : genes) {
            this.func_230480_a_((Widget)new GeneSliderWidget(this.field_230708_k_ / 2 + (right ? 87 : 0), y, 87, 20, (ITextComponent)new TranslationTextComponent(g.getTranslationKey()), genetics.getGene(g), b -> genetics.setGene(g, b.floatValue())));
            if (right) {
                y += 20;
            }
            right = !right;
        }
        return y + 4 + (right ? 20 : 0);
    }

    private int integerChanger(int y, Consumer<Integer> onClick, Supplier<ITextComponent> content) {
        int bw = 22;
        Button current = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + bw * 2, y, 175 - bw * 4, 20, content.get(), b -> {}));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, y, bw, 20, (ITextComponent)new StringTextComponent("-1"), b -> {
            onClick.accept(-1);
            current.func_238482_a_((ITextComponent)content.get());
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + bw, y, bw, 20, (ITextComponent)new StringTextComponent("-10"), b -> {
            onClick.accept(-10);
            current.func_238482_a_((ITextComponent)content.get());
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 175 - bw * 2, y, bw, 20, (ITextComponent)new StringTextComponent("+10"), b -> {
            onClick.accept(10);
            current.func_238482_a_((ITextComponent)content.get());
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 175 - bw, y, bw, 20, (ITextComponent)new StringTextComponent("+1"), b -> {
            onClick.accept(1);
            current.func_238482_a_((ITextComponent)content.get());
        }));
        return y + 22;
    }

    protected void setPage(String page) {
        this.page = page;
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        if (page.equals("loading")) {
            return;
        }
        if (this.shouldShowPageSelection()) {
            String[] pages = this.getPages();
            int w = 350 / pages.length;
            int x = (int)((double)this.field_230708_k_ / 2.0 - (double)pages.length / 2.0 * (double)w);
            for (String string : pages) {
                ((Button)this.func_230480_a_((Widget)new Button((int)x, (int)(this.field_230709_l_ / 2 - 105), (int)w, (int)20, (ITextComponent)new TranslationTextComponent((String)new StringBuilder().append((String)"gui.villager_editor.page.").append((String)string).toString()), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$setPage$6(java.lang.String net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((VillagerEditorScreen)this, (String)string)))).field_230693_o_ = !string.equals(page);
                x += w;
            }
            this.doneWidget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 175 + 20, this.field_230709_l_ / 2 + 85, 135, 20, (ITextComponent)new TranslationTextComponent("gui.done"), sender -> {
                this.syncVillagerData();
                this.func_231175_as__();
            }));
        }
        int y = this.field_230709_l_ / 2 - 80;
        int margin = 40;
        Genetics genetics = this.villager.getGenetics();
        switch (page) {
            case "general": {
                TextFieldWidget textFieldWidget;
                this.drawName(this.field_230708_k_ / 2, y);
                this.drawGender(this.field_230708_k_ / 2, y += 20);
                y += 22;
                if (this.villagerUUID.equals(this.playerUUID)) {
                    this.drawModel(this.field_230708_k_ / 2, y);
                    y += 22;
                }
                if (!this.villagerUUID.equals(this.playerUUID)) {
                    this.func_230480_a_((Widget)new GeneSliderWidget(this.field_230708_k_ / 2, y, 175, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.age"), 1.0 + (double)this.villagerBreedingAge / (double)AgeState.getMaxAge(), b -> {
                        this.villagerBreedingAge = -((int)((1.0 - b) * (double)AgeState.getMaxAge())) + 1;
                        this.villager.func_70873_a(this.villagerBreedingAge);
                        this.villager.func_213323_x_();
                    }));
                    y += 28;
                }
                for (String who : new String[]{"father", "mother", "spouse"}) {
                    textFieldWidget = (TextFieldWidget)this.func_230480_a_((Widget)new NamedTextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2, y, 175, 18, (ITextComponent)new TranslationTextComponent("gui.villager_editor.relation." + who)));
                    textFieldWidget.func_146203_f(64);
                    textFieldWidget.func_146180_a(this.villagerData.func_74779_i("tree_" + who + "_name"));
                    textFieldWidget.func_212954_a(name -> this.villagerData.func_74778_a("tree_" + who + "_new", name));
                    y += 20;
                }
                textFieldWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2, y += 4, 175, 18, (ITextComponent)new StringTextComponent("UUID")));
                textFieldWidget.func_146203_f(64);
                textFieldWidget.func_146180_a(this.villagerUUID.toString());
                break;
            }
            case "body": {
                y = this.doubleGeneSliders(y, Genetics.SIZE, Genetics.WIDTH, Genetics.BREAST, Genetics.SKIN);
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.randClothing"), b -> this.sendCommand("clothing")));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 87, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.selectClothing"), b -> this.setPage("clothing")));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, y += 22, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.prev"), b -> {
                    CompoundNBT compound = new CompoundNBT();
                    compound.func_74768_a("offset", -1);
                    this.sendCommand("clothing", compound);
                }));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 87, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.next"), b -> {
                    CompoundNBT compound = new CompoundNBT();
                    compound.func_74768_a("offset", 1);
                    this.sendCommand("clothing", compound);
                }));
                this.func_230480_a_(new ColorPickerWidget(this.field_230708_k_ / 2 + margin, y += 22, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.HEMOGLOBIN), genetics.getGene(Genetics.MELANIN), MCA.locate("textures/colormap/villager_skin.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.HEMOGLOBIN, vx.floatValue());
                    genetics.setGene(Genetics.MELANIN, vy.floatValue());
                }));
                break;
            }
            case "head": {
                y = this.doubleGeneSliders(y, Genetics.FACE, Genetics.VOICE);
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.randHair"), b -> this.sendCommand("hair")));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 87, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.selectHair"), b -> this.setPage("hair")));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, y += 22, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.prev"), b -> {
                    CompoundNBT compound = new CompoundNBT();
                    compound.func_74768_a("offset", -1);
                    this.sendCommand("hair", compound);
                }));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 87, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.next"), b -> {
                    CompoundNBT compound = new CompoundNBT();
                    compound.func_74768_a("offset", 1);
                    this.sendCommand("hair", compound);
                }));
                this.func_230480_a_(new ColorPickerWidget(this.field_230708_k_ / 2 + margin, y += 22, 175 - margin * 2, 175 - margin * 2, genetics.getGene(Genetics.PHEOMELANIN), genetics.getGene(Genetics.EUMELANIN), MCA.locate("textures/colormap/villager_hair.png"), (vx, vy) -> {
                    genetics.setGene(Genetics.PHEOMELANIN, vx.floatValue());
                    genetics.setGene(Genetics.EUMELANIN, vy.floatValue());
                }));
                break;
            }
            case "personality": {
                LinkedList<Button> linkedList = new LinkedList<Button>();
                int row = 0;
                int BUTTONS_PER_ROW = 2;
                for (Personality p : Personality.values()) {
                    if (p == Personality.UNASSIGNED) continue;
                    if (row == 2) {
                        row = 0;
                        y += 19;
                    }
                    Button widget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 87 * row, y, 87, 20, p.getName(), b -> {
                        this.villager.getVillagerBrain().setPersonality(p);
                        personalityButtons.forEach(v -> {
                            v.field_230693_o_ = true;
                        });
                        b.field_230693_o_ = false;
                    }));
                    widget.field_230693_o_ = p != this.villager.getVillagerBrain().getPersonality();
                    linkedList.add(widget);
                    ++row;
                }
                break;
            }
            case "traits": {
                int index;
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, y, 32, 20, (ITextComponent)new StringTextComponent("<"), b -> this.setTraitPage(this.traitPage - 1)));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 175 - 32, y, 32, 20, (ITextComponent)new StringTextComponent(">"), b -> this.setTraitPage(this.traitPage + 1)));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 32, y, 111, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.page", new Object[]{this.traitPage + 1}), b -> ++this.traitPage));
                y += 22;
                Traits.Trait[] traits = (Traits.Trait[])Arrays.stream(Traits.Trait.values()).filter((? super T e) -> {
                    if (this.villagerUUID.equals(this.playerUUID)) {
                        return Config.getInstance().bypassTraitRestrictions || e.isUsableOnPlayer();
                    }
                    return true;
                }).toArray(Traits.Trait[]::new);
                for (int i = 0; i < 8 && (index = i + this.traitPage * 8) < traits.length; ++i) {
                    Traits.Trait t = traits[index];
                    IFormattableTextComponent name2 = t.getName().func_230531_f_().func_240699_a_(this.villager.getTraits().hasTrait(t) ? TextFormatting.GREEN : TextFormatting.GRAY);
                    this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2, y, 175, 20, (ITextComponent)name2, b -> {
                        if (this.villager.getTraits().hasTrait(t)) {
                            this.villager.getTraits().removeTrait(t);
                        } else {
                            this.villager.getTraits().addTrait(t);
                        }
                        b.func_238482_a_((ITextComponent)t.getName().func_230531_f_().func_240699_a_(this.villager.getTraits().hasTrait(t) ? TextFormatting.GREEN : TextFormatting.GRAY));
                    }));
                    y += 20;
                }
                break;
            }
            case "debug": {
                boolean right = false;
                LinkedList<Button> professionButtons = new LinkedList<Button>();
                for (VillagerProfession p : new VillagerProfession[]{VillagerProfession.field_221151_a, (VillagerProfession)ProfessionsMCA.GUARD.get(), (VillagerProfession)ProfessionsMCA.ARCHER.get(), (VillagerProfession)ProfessionsMCA.OUTLAW.get(), (VillagerProfession)ProfessionsMCA.ADVENTURER.get(), (VillagerProfession)ProfessionsMCA.CULTIST.get()}) {
                    TranslationTextComponent text = new TranslationTextComponent("entity.minecraft.villager." + p);
                    Button widget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + (right ? 87 : 0), y, 87, 20, (ITextComponent)text, b -> {
                        CompoundNBT compound = new CompoundNBT();
                        compound.func_74778_a("profession", Registry.field_218370_L.func_177774_c((Object)p).toString());
                        this.syncVillagerData();
                        NetworkHandler.sendToServer(new VillagerEditorSyncRequest("profession", this.villagerUUID, compound));
                        this.requestVillagerData();
                        professionButtons.forEach(button -> {
                            button.field_230693_o_ = true;
                        });
                        b.field_230693_o_ = false;
                    }));
                    professionButtons.add(widget);
                    boolean bl = widget.field_230693_o_ = this.villager.getProfession() != p;
                    if (right) {
                        y += 20;
                    }
                    right = !right;
                }
                this.func_230480_a_((Widget)new GeneSliderWidget(this.field_230708_k_ / 2, y += 4, 175, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.infection"), this.villager.getInfectionProgress(), b -> {
                    this.villager.setInfected(b > 0.0);
                    this.villager.setInfectionProgress(b.floatValue());
                }));
                y += 22;
                assert (this.field_230706_i_ != null);
                assert (this.field_230706_i_.field_71439_g != null);
                Memories player = this.villager.getVillagerBrain().getMemoriesForPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
                y = this.integerChanger(y, player::modHearts, () -> new StringTextComponent(player.getHearts() + " hearts"));
                this.integerChanger(y, v -> this.villager.getVillagerBrain().modifyMoodValue((int)v), () -> new StringTextComponent(this.villager.getVillagerBrain().getMoodValue() + " mood"));
                break;
            }
            case "clothing": 
            case "hair": {
                this.filterGender = this.villager.getGenetics().getGender();
                this.searchString = "";
                TextFieldWidget textFieldWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 87, this.field_230709_l_ / 2 - 100, 175, 18, (ITextComponent)new TranslationTextComponent("gui.villager_editor.search")));
                textFieldWidget.func_146203_f(64);
                textFieldWidget.func_212954_a(v -> {
                    this.searchString = v;
                    this.filter();
                });
                y = this.field_230709_l_ / 2 + 85;
                this.pageButtonWidget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 30, y, 60, 20, (ITextComponent)new StringTextComponent(""), b -> {}));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 32 - 28, y, 28, 20, (ITextComponent)new StringTextComponent("<<"), b -> {
                    this.clothingPage = Math.max(0, this.clothingPage - 1);
                    this.updateClothingPageWidget();
                }));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 32, y, 28, 20, (ITextComponent)new StringTextComponent(">>"), b -> {
                    this.clothingPage = Math.max(0, Math.min(this.clothingPageCount - 1, this.clothingPage + 1));
                    this.updateClothingPageWidget();
                }));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 32 + 32, y, 128, 20, (ITextComponent)new TranslationTextComponent("gui.button.done"), b -> {
                    if (page.equals("clothing")) {
                        this.setPage("body");
                    } else {
                        this.setPage("head");
                    }
                }));
                this.widgetMasculine = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 32 - 96 - 64, y, 64, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.masculine"), b -> {
                    this.filterGender = Gender.MALE;
                    this.filter();
                    this.widgetMasculine.field_230693_o_ = false;
                    this.widgetFeminine.field_230693_o_ = true;
                }));
                this.widgetMasculine.field_230693_o_ = this.filterGender != Gender.MALE;
                this.widgetFeminine = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 32 - 96 - 64 + 64, y, 64, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.feminine"), b -> {
                    this.filterGender = Gender.FEMALE;
                    this.filter();
                    this.widgetMasculine.field_230693_o_ = true;
                    this.widgetFeminine.field_230693_o_ = false;
                }));
                this.widgetFeminine.field_230693_o_ = this.filterGender != Gender.FEMALE;
                this.filter();
            }
        }
    }

    private void updateClothingPageWidget() {
        if (this.pageButtonWidget != null) {
            this.pageButtonWidget.func_238482_a_((ITextComponent)new StringTextComponent(String.format("%d / %d", this.clothingPage + 1, this.clothingPageCount)));
        }
    }

    private void filter() {
        if (Objects.equals(this.page, "clothing")) {
            this.filteredClothing = this.filter(clothing);
        } else {
            this.filteredHair = this.filter(hair);
        }
    }

    private <T extends ClothingList.ListEntry> List<String> filter(HashMap<String, T> map) {
        List<String> filtered = map.entrySet().stream().filter((? super T v) -> this.filterGender == ((ClothingList.ListEntry)v.getValue()).gender || ((ClothingList.ListEntry)v.getValue()).gender == Gender.NEUTRAL).filter((? super T v) -> {
            if (v.getValue() instanceof ClothingList.Clothing) {
                ClothingList.Clothing c = (ClothingList.Clothing)v.getValue();
                return !c.exclude;
            }
            return true;
        }).filter((? super T v) -> MCA.isBlankString(this.searchString) || ((String)v.getKey()).contains(this.searchString)).map(Map.Entry::getKey).collect(Collectors.toList());
        this.clothingPageCount = (int)Math.ceil((float)filtered.size() / (float)this.CLOTHES_PER_PAGE);
        this.clothingPage = Math.max(0, Math.min(this.clothingPage, this.clothingPageCount - 1));
        this.updateClothingPageWidget();
        return filtered;
    }

    protected String[] getPages() {
        if (this.villagerUUID.equals(this.playerUUID)) {
            return new String[]{"general", "body", "head", "traits"};
        }
        return new String[]{"general", "body", "head", "personality", "traits", "debug"};
    }

    protected void drawName(int x, int y) {
        this.drawName(x, y, name -> {
            this.updateName((String)name);
            if (this.doneWidget != null) {
                this.doneWidget.field_230693_o_ = !MCA.isBlankString(name);
            }
        });
    }

    protected void drawName(int x, int y, Consumer<String> onChanged) {
        this.villagerNameField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, x, y, 116, 18, (ITextComponent)new TranslationTextComponent("structure_block.structure_name")));
        this.villagerNameField.func_146203_f(32);
        this.villagerNameField.func_146180_a(this.getName().func_150261_e());
        this.villagerNameField.func_212954_a(onChanged);
        this.func_230480_a_((Widget)new Button(x + 116 + 1, y - 1, 56, 20, (ITextComponent)new TranslationTextComponent("gui.button.random"), b -> NetworkHandler.sendToServer(new VillagerNameRequest(this.villager.getGenetics().getGender()))));
    }

    public ITextComponent getName() {
        ITextComponent villagerName = null;
        boolean isPlayer = this.villagerUUID.equals(this.playerUUID);
        if (isPlayer) {
            assert (this.field_230706_i_ != null);
            assert (this.field_230706_i_.field_71439_g != null);
            villagerName = this.field_230706_i_.field_71439_g.func_200201_e();
        } else if (this.villager.func_145818_k_()) {
            villagerName = this.villager.func_200201_e();
        }
        if (villagerName == null || MCA.isBlankString(villagerName.func_150261_e())) {
            if (isPlayer) {
                assert (this.field_230706_i_ != null);
                assert (this.field_230706_i_.field_71439_g != null);
                villagerName = this.field_230706_i_.field_71439_g.func_200200_C_();
            } else {
                villagerName = this.villager.func_200200_C_();
            }
            if (villagerName == null || MCA.isBlankString(villagerName.func_150261_e())) {
                NetworkHandler.sendToServer(new VillagerNameRequest(this.villager.getGenetics().getGender()));
            } else {
                this.updateName(villagerName.func_150261_e());
            }
        }
        return villagerName;
    }

    public void updateName(String name) {
        if (!MCA.isBlankString(name)) {
            ITextComponent newName = ITextComponent.func_244388_a((String)name);
            boolean isPlayer = this.villagerUUID.equals(this.playerUUID);
            if (isPlayer) {
                assert (this.field_230706_i_ != null);
                assert (this.field_230706_i_.field_71439_g != null);
                ITextComponent realName = this.field_230706_i_.field_71439_g.func_200200_C_();
                if (realName.func_150261_e().equals(name)) {
                    newName = null;
                }
                this.field_230706_i_.field_71439_g.func_200203_b(newName);
                this.field_230706_i_.field_71439_g.func_174805_g(newName != null);
                if (this.field_230706_i_.field_71439_g.func_174833_aM()) {
                    this.villager.func_200203_b(newName);
                } else {
                    this.villager.setName(realName.func_150261_e());
                }
            } else {
                this.villager.func_200203_b(newName);
            }
        }
    }

    void drawGender(int x, int y) {
        this.genderButtonFemale = new Button(x, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.feminine"), sender -> {
            this.villager.getGenetics().setGender(Gender.FEMALE);
            this.sendCommand("gender");
            this.genderButtonFemale.field_230693_o_ = false;
            this.genderButtonMale.field_230693_o_ = true;
        });
        this.func_230480_a_((Widget)this.genderButtonFemale);
        this.genderButtonMale = new Button(x + 87, y, 87, 20, (ITextComponent)new TranslationTextComponent("gui.villager_editor.masculine"), sender -> {
            this.villager.getGenetics().setGender(Gender.MALE);
            this.sendCommand("gender");
            this.genderButtonFemale.field_230693_o_ = true;
            this.genderButtonMale.field_230693_o_ = false;
        });
        this.func_230480_a_((Widget)this.genderButtonMale);
        this.genderButtonFemale.field_230693_o_ = this.villager.getGenetics().getGender() != Gender.FEMALE;
        this.genderButtonMale.field_230693_o_ = this.villager.getGenetics().getGender() != Gender.MALE;
    }

    void drawModel(int x, int y) {
        if (this.allowPlayerModel && this.allowVillagerModel) {
            this.villagerSkinWidget = (Button)this.func_230480_a_((Widget)new TooltipButtonWidget(x, y, 58, 20, "gui.villager_editor.villager_skin", b -> {
                this.villagerData.func_74768_a("playerModel", VillagerLike.PlayerModel.VILLAGER.ordinal());
                this.syncVillagerData();
                this.playerSkinWidget.field_230693_o_ = true;
                this.villagerSkinWidget.field_230693_o_ = false;
                this.vanillaSkinWidget.field_230693_o_ = true;
            }));
            this.villagerSkinWidget.field_230693_o_ = this.villagerData.func_74762_e("playerModel") != VillagerLike.PlayerModel.VILLAGER.ordinal();
            this.playerSkinWidget = (Button)this.func_230480_a_((Widget)new TooltipButtonWidget(x + 58, y, 58, 20, "gui.villager_editor.player_skin", b -> {
                this.villagerData.func_74768_a("playerModel", VillagerLike.PlayerModel.PLAYER.ordinal());
                this.syncVillagerData();
                this.playerSkinWidget.field_230693_o_ = false;
                this.villagerSkinWidget.field_230693_o_ = true;
                this.vanillaSkinWidget.field_230693_o_ = true;
            }));
            this.playerSkinWidget.field_230693_o_ = this.villagerData.func_74762_e("playerModel") != VillagerLike.PlayerModel.PLAYER.ordinal();
            this.vanillaSkinWidget = (Button)this.func_230480_a_((Widget)new TooltipButtonWidget(x + 116, y, 58, 20, "gui.villager_editor.vanilla_skin", b -> {
                this.villagerData.func_74768_a("playerModel", VillagerLike.PlayerModel.VANILLA.ordinal());
                this.syncVillagerData();
                this.villagerSkinWidget.field_230693_o_ = true;
                this.playerSkinWidget.field_230693_o_ = true;
                this.vanillaSkinWidget.field_230693_o_ = false;
            }));
            this.vanillaSkinWidget.field_230693_o_ = this.villagerData.func_74762_e("playerModel") != VillagerLike.PlayerModel.VANILLA.ordinal();
        }
    }

    private void sendCommand(String command) {
        this.sendCommand(command, new CompoundNBT());
    }

    private void sendCommand(String command, CompoundNBT nbt) {
        this.syncVillagerData();
        NetworkHandler.sendToServer(new VillagerEditorSyncRequest(command, this.villagerUUID, nbt));
        this.requestVillagerData();
    }

    private void setTraitPage(int i) {
        Traits.Trait[] traits = (Traits.Trait[])Arrays.stream(Traits.Trait.values()).filter((? super T e) -> {
            if (this.villagerUUID.equals(this.playerUUID)) {
                return Config.getInstance().bypassTraitRestrictions || e.isUsableOnPlayer();
            }
            return true;
        }).toArray(Traits.Trait[]::new);
        int maxPage = (int)Math.ceil((double)traits.length / 8.0) - 1;
        this.traitPage = Math.max(0, Math.min(maxPage, i));
        this.setPage("traits");
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.page.equals("clothing") && this.hoveredClothingId >= 0 && this.filteredClothing.size() > this.hoveredClothingId) {
            this.villager.setClothes(this.filteredClothing.get(this.hoveredClothingId));
            this.setPage("body");
            this.eventCallback("clothing");
            return true;
        }
        if (this.page.equals("hair") && this.hoveredClothingId >= 0 && this.filteredHair.size() > this.hoveredClothingId) {
            this.villager.setHair(this.filteredHair.get(this.hoveredClothingId));
            this.setPage("head");
            this.eventCallback("hair");
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected void eventCallback(String event) {
    }

    protected boolean shouldUsePlayerModel() {
        return false;
    }

    protected boolean shouldPrintPlayerHint() {
        return true;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        VillagerEditorScreen.func_238467_a_((MatrixStack)matrices, (int)0, (int)20, (int)this.field_230708_k_, (int)(this.field_230709_l_ - 20), (int)0x66000000);
        if (this.villager == null) {
            return;
        }
        this.villager.field_70173_aa = (int)(System.currentTimeMillis() / 50L);
        if (this.shouldDrawEntity()) {
            int x = this.field_230708_k_ / 2 - 87;
            int y = this.field_230709_l_ / 2 + 70;
            if (this.villagerUUID.equals(this.playerUUID) && this.shouldUsePlayerModel()) {
                assert (Minecraft.func_71410_x().field_71439_g != null);
                InventoryScreen.func_228187_a_((int)x, (int)y, (int)60, (float)(x - mouseX), (float)(y - 50 - mouseY), (LivingEntity)Minecraft.func_71410_x().field_71439_g);
            } else {
                InventoryScreen.func_228187_a_((int)x, (int)y, (int)60, (float)(x - mouseX), (float)(y - 50 - mouseY), (LivingEntity)this.villager);
            }
            if (this.shouldPrintPlayerHint() && this.villagerUUID.equals(this.playerUUID) && this.villagerData.func_74762_e("playerModel") != VillagerLike.PlayerModel.VILLAGER.ordinal()) {
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)x, (double)(y - 145), 0.0);
                matrices.func_227862_a_(0.5f, 0.5f, 0.5f);
                VillagerEditorScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.villager_editor.model_hint"), (int)0, (int)0, (int)-1426063361);
                matrices.func_227865_b_();
            }
        }
        if (this.page.equals("clothing") || this.page.equals("hair")) {
            CompoundNBT nbt = new CompoundNBT();
            this.villager.func_213281_b(nbt);
            this.villagerVisualization.func_70037_a(nbt);
            this.villagerVisualization.func_70873_a(this.villager.func_70874_b());
            this.villagerVisualization.func_213323_x_();
            int i = 0;
            this.hoveredClothingId = -1;
            block0: for (int y = 0; y < this.CLOTHES_V; ++y) {
                for (int x = 0; x < this.CLOTHES_H + y; ++x) {
                    int index = this.clothingPage * this.CLOTHES_PER_PAGE + i;
                    if ((this.page.equals("clothing") ? this.filteredClothing : this.filteredHair).size() <= index) continue block0;
                    this.villagerVisualization.field_184619_aG = (float)System.currentTimeMillis() / 50.0f + (float)i * 17.0f;
                    this.villagerVisualization.field_70721_aZ = 1.5f;
                    if (this.page.equals("clothing")) {
                        this.villagerVisualization.setClothes(this.filteredClothing.get(index));
                    } else {
                        this.villagerVisualization.setHair(this.filteredHair.get(index));
                    }
                    int cx = this.field_230708_k_ / 2 + (int)(((double)x - (double)this.CLOTHES_H / 2.0 + 0.5 - 0.5 * (double)(y % 2)) * 40.0);
                    int cy = this.field_230709_l_ / 2 + 25 + (int)(((double)y - (double)this.CLOTHES_V / 2.0 + 0.5) * 65.0);
                    if (Math.abs(cx - mouseX) <= 20 && Math.abs(cy - mouseY - 30) <= 30) {
                        this.hoveredClothingId = index;
                    }
                    InventoryScreen.func_228187_a_((int)cx, (int)cy, (int)(this.hoveredClothingId == index ? 35 : 30), (float)((float)(-(mouseX - cx)) / 2.0f), (float)((float)(-(mouseY - cy - 64)) / 2.0f), (LivingEntity)this.villagerVisualization);
                    ++i;
                }
            }
        }
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    protected boolean shouldDrawEntity() {
        return !this.page.equals("loading") && !this.page.equals("clothing") && !this.page.equals("hair");
    }

    protected boolean shouldShowPageSelection() {
        return !this.page.equals("clothing") && !this.page.equals("hair");
    }

    public void setVillagerName(String name) {
        this.villagerNameField.func_146180_a(name);
        this.updateName(name);
    }

    public void setVillagerData(CompoundNBT villagerData) {
        if (this.villager != null) {
            this.villagerData = villagerData;
            this.villager.func_70037_a(villagerData);
            this.villagerBreedingAge = villagerData.func_74762_e("Age");
            this.villager.func_70873_a(this.villagerBreedingAge);
            this.villager.func_213323_x_();
        }
        if (this.page.equals("loading")) {
            this.setPage("general");
        } else {
            this.setPage(this.page);
        }
    }

    private void requestVillagerData() {
        NetworkHandler.sendToServer(new GetVillagerRequest(this.villagerUUID));
    }

    void syncVillagerData() {
        CompoundNBT nbt = this.villagerData;
        this.villager.func_213281_b(nbt);
        nbt.func_74768_a("Age", this.villagerBreedingAge);
        NetworkHandler.sendToServer(new VillagerEditorSyncRequest("sync", this.villagerUUID, nbt));
    }

    public void setSkinList(HashMap<String, ClothingList.Clothing> clothing, HashMap<String, HairList.Hair> hair) {
        VillagerEditorScreen.clothing = clothing;
        VillagerEditorScreen.hair = hair;
        this.filter();
    }

    private /* synthetic */ void lambda$setPage$6(String p, Button sender) {
        this.setPage(p);
    }
}

