/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.network.c2s.CallToPlayerMessage;
import forge.net.mca.network.c2s.GetFamilyRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WhistleScreen
extends Screen {
    private List<String> keys = new ArrayList<String>();
    private CompoundNBT villagerData = new CompoundNBT();
    private VillagerEntityMCA dummy;
    private Button selectionLeftButton;
    private Button selectionRightButton;
    private Button villagerNameButton;
    private Button callButton;
    private int loadingAnimationTicks;
    private int selectedIndex;

    public WhistleScreen() {
        super((ITextComponent)new TranslationTextComponent("gui.whistle.title"));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.loadingAnimationTicks != -1) {
            ++this.loadingAnimationTicks;
        }
        if (this.loadingAnimationTicks >= 20) {
            this.loadingAnimationTicks = 0;
        }
    }

    public void func_231160_c_() {
        NetworkHandler.sendToServer(new GetFamilyRequest());
        this.selectionLeftButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 123, this.field_230709_l_ / 2 + 65, 20, 20, (ITextComponent)new StringTextComponent("<<"), b -> {
            this.selectedIndex = this.selectedIndex == 0 ? this.keys.size() - 1 : --this.selectedIndex;
            this.setVillagerData(this.selectedIndex);
        }));
        this.selectionRightButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 103, this.field_230709_l_ / 2 + 65, 20, 20, (ITextComponent)new StringTextComponent(">>"), b -> {
            this.selectedIndex = this.selectedIndex == this.keys.size() - 1 ? 0 : ++this.selectedIndex;
            this.setVillagerData(this.selectedIndex);
        }));
        this.villagerNameButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 65, 200, 20, (ITextComponent)new StringTextComponent(""), b -> {}));
        this.callButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + 90, 60, 20, (ITextComponent)new TranslationTextComponent("gui.button.call"), b -> {
            NetworkHandler.sendToServer(new CallToPlayerMessage(UUID.fromString(this.keys.get(this.selectedIndex))));
            Objects.requireNonNull(this.field_230706_i_).func_147108_a(null);
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 40, this.field_230709_l_ / 2 + 90, 60, 20, (ITextComponent)new TranslationTextComponent("gui.button.exit"), b -> Objects.requireNonNull(this.field_230706_i_).func_147108_a(null)));
        this.toggleButtons(false);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(MatrixStack transform, int sizeX, int sizeY, float offset) {
        this.func_230446_a_(transform);
        WhistleScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.whistle.title"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 100), (int)0xFFFFFF);
        if (this.loadingAnimationTicks != -1) {
            String loadingMsg = new String(new char[this.loadingAnimationTicks / 5 % 4]).replace("\u0000", ".");
            WhistleScreen.func_238475_b_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.loading").func_230529_a_((ITextComponent)new StringTextComponent(loadingMsg)), (int)(this.field_230708_k_ / 2 - 20), (int)(this.field_230709_l_ / 2 - 10), (int)0xFFFFFF);
        } else if (this.keys.size() == 0) {
            WhistleScreen.func_238472_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.whistle.noFamily"), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 50), (int)0xFFFFFF);
        } else {
            WhistleScreen.func_238471_a_((MatrixStack)transform, (FontRenderer)this.field_230712_o_, (String)(this.selectedIndex + 1 + " / " + this.keys.size()), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + 50), (int)0xFFFFFF);
        }
        this.drawDummy();
        super.func_230430_a_(transform, sizeX, sizeY, offset);
    }

    private void drawDummy() {
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2 + 45;
        if (this.dummy != null) {
            InventoryScreen.func_228187_a_((int)posX, (int)posY, (int)60, (float)0.0f, (float)0.0f, (LivingEntity)this.dummy);
        }
    }

    public void setVillagerData(@NotNull CompoundNBT data) {
        this.villagerData = data;
        this.keys = new ArrayList<String>(data.func_150296_c());
        this.loadingAnimationTicks = -1;
        this.selectedIndex = 0;
        this.setVillagerData(0);
    }

    private void setVillagerData(int index) {
        if (this.keys.size() > 0) {
            CompoundNBT firstData = this.villagerData.func_74775_l(this.keys.get(index));
            this.dummy = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
            this.dummy.func_70037_a(firstData);
            this.villagerNameButton.func_238482_a_(this.dummy.func_145748_c_());
            this.toggleButtons(true);
        } else {
            this.toggleButtons(false);
        }
    }

    private void toggleButtons(boolean enabled) {
        this.selectionLeftButton.field_230693_o_ = enabled;
        this.selectionRightButton.field_230693_o_ = enabled;
        this.callButton.field_230693_o_ = enabled;
    }
}

