/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import forge.net.mca.MCAClient;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import java.util.UUID;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.World;

public interface CommonVillagerModel<T extends LivingEntity> {
    public ModelRenderer getBreastPart();

    public ModelRenderer getBodyPart();

    public Iterable<ModelRenderer> getCommonHeadParts();

    public Iterable<ModelRenderer> getCommonBodyParts();

    public Iterable<ModelRenderer> getBreastParts();

    public VillagerDimensions.Mutable getDimensions();

    public float getBreastSize();

    public void setBreastSize(float var1);

    default public void renderCommon(MatrixStack matrices, IVertexBuilder vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        float breastSize;
        float headSize = this.getDimensions().getHead();
        matrices.func_227860_a_();
        matrices.func_227862_a_(headSize, headSize, headSize);
        this.getCommonHeadParts().forEach(a -> a.func_228309_a_(matrices, vertices, light, overlay, red, green, blue, alpha));
        matrices.func_227865_b_();
        this.getCommonBodyParts().forEach(a -> a.func_228309_a_(matrices, vertices, light, overlay, red, green, blue, alpha));
        if (this.getBreastPart().field_78806_j && this.getBodyPart().field_78806_j && (breastSize = this.getBreastSize() * this.getDimensions().getBreasts()) > 0.0f) {
            matrices.func_227860_a_();
            matrices.func_227862_a_(breastSize * 0.2f + 1.05f, breastSize * 0.75f + 0.75f, breastSize * 0.75f + 0.75f);
            for (ModelRenderer part : this.getBreastParts()) {
                part.func_228309_a_(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
            matrices.func_227865_b_();
        }
    }

    default public void applyVillagerDimensions(VillagerLike<?> villager, boolean isSneaking) {
        this.getDimensions().set(villager.getVillagerDimensions());
        this.setBreastSize(villager.getGenetics().getBreastSize());
        this.getBreastPart().field_78806_j = villager.getGenetics().getGender() == Gender.FEMALE;
        for (ModelRenderer part : this.getBreastParts()) {
            part.field_78795_f = 0.9424779f + this.getBodyPart().field_78795_f;
            float cy = 0.0f;
            float cz = 0.0f;
            if (isSneaking) {
                cy = 3.0f;
                cz = 1.5f;
            }
            part.func_78793_a(0.25f, (float)(5.0 - Math.pow(this.getBreastSize(), 0.5) * 2.5 + (double)cy), -1.5f + this.getBreastSize() * 0.25f + cz);
        }
    }

    default public void copyCommonAttributes(CommonVillagerModel<T> target) {
        target.getDimensions().set(this.getDimensions());
        target.setBreastSize(this.getBreastSize());
    }

    public static VillagerLike<?> getVillager(World world, UUID uuid) {
        if (MCAClient.fallbackVillager == null) {
            MCAClient.fallbackVillager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).func_200721_a(world);
        }
        return MCAClient.playerData.getOrDefault(uuid, MCAClient.fallbackVillager);
    }

    public static VillagerLike<?> getVillager(Entity villager) {
        if (villager instanceof VillagerLike) {
            return (VillagerLike)villager;
        }
        return CommonVillagerModel.getVillager(villager.func_130014_f_(), villager.func_110124_au());
    }
}

