/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import forge.net.mca.util.compat.model.ModelPartCompat;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;

public class PlayerEntityExtendedModel<T extends LivingEntity>
extends PlayerModel<T>
implements CommonVillagerModel<T> {
    public final ModelRenderer breasts;
    public final ModelRenderer breastsWear;
    VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.ADULT);
    float breastSize;

    public PlayerEntityExtendedModel(ModelPartCompat root) {
        super(0.0f, false);
        this.breasts = root.getChild("breasts");
        this.breastsWear = root.getChild("breastplate");
    }

    public void func_217148_a(BipedModel<T> target) {
        super.func_217148_a(target);
        if (target instanceof PlayerEntityExtendedModel) {
            PlayerEntityExtendedModel playerTarget = (PlayerEntityExtendedModel)target;
            this.copyAttributes(playerTarget);
        }
    }

    private void copyAttributes(PlayerEntityExtendedModel<T> target) {
        target.field_178733_c.func_217177_a(this.field_178733_c);
        target.field_178731_d.func_217177_a(this.field_178731_d);
        target.field_178734_a.func_217177_a(this.field_178734_a);
        target.field_178732_b.func_217177_a(this.field_178732_b);
        target.field_178730_v.func_217177_a(this.field_178730_v);
        target.breastsWear.func_217177_a(this.breastsWear);
        this.copyCommonAttributes(target);
        target.breasts.field_78806_j = this.breasts.field_78806_j;
        target.breasts.func_217177_a(this.breasts);
    }

    public void func_225598_a_(MatrixStack matrices, IVertexBuilder vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.renderCommon(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    @Override
    public ModelRenderer getBreastPart() {
        return this.breasts;
    }

    @Override
    public ModelRenderer getBodyPart() {
        return this.field_78115_e;
    }

    @Override
    public Iterable<ModelRenderer> getCommonHeadParts() {
        return this.func_225602_a_();
    }

    @Override
    public Iterable<ModelRenderer> getCommonBodyParts() {
        return this.func_225600_b_();
    }

    @Override
    public Iterable<ModelRenderer> getBreastParts() {
        return ImmutableList.of((Object)this.breasts, (Object)this.breastsWear);
    }

    @Override
    public VillagerDimensions.Mutable getDimensions() {
        return this.dimensions;
    }

    @Override
    public float getBreastSize() {
        return this.breastSize;
    }

    @Override
    public void setBreastSize(float breastSize) {
        this.breastSize = breastSize;
    }

    public void func_225597_a_(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (CommonVillagerModel.getVillager(villager).getAgeState() == AgeState.BABY && !villager.func_184218_aH()) {
            limbDistance = (float)Math.sin((float)((LivingEntity)villager).field_70173_aa / 12.0f);
            limbAngle = (float)Math.cos((float)((LivingEntity)villager).field_70173_aa / 9.0f) * 3.0f;
            headYaw += (float)Math.sin((float)((LivingEntity)villager).field_70173_aa / 2.0f);
        }
        super.func_225597_a_(villager, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.applyVillagerDimensions(CommonVillagerModel.getVillager(villager), villager.func_213453_ef());
    }
}

