/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import forge.net.mca.Config;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import forge.net.mca.util.compat.model.BipedEntityModelCompat;
import forge.net.mca.util.compat.model.Dilation;
import forge.net.mca.util.compat.model.ModelData;
import forge.net.mca.util.compat.model.ModelPartBuilder;
import forge.net.mca.util.compat.model.ModelPartCompat;
import forge.net.mca.util.compat.model.ModelPartData;
import forge.net.mca.util.compat.model.ModelTransform;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;

public class VillagerEntityBaseModelMCA<T extends LivingEntity>
extends BipedModel<T>
implements CommonVillagerModel<T> {
    protected static final String BREASTS = "breasts";
    public final ModelRenderer breasts;
    VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.ADULT);
    float breastSize;

    public VillagerEntityBaseModelMCA(ModelPartCompat root) {
        super(root.getOriginalDilation(), 0.0f, root.getTextureWidth(), root.getTextureHeight());
        this.breasts = root.getChild(BREASTS);
    }

    public static ModelData getModelData(Dilation dilation) {
        ModelData modelData = BipedEntityModelCompat.getModelData(dilation, 0.0f);
        ModelPartData data = modelData.getRoot();
        data.addChild(BREASTS, VillagerEntityBaseModelMCA.newBreasts(dilation, 0), ModelTransform.NONE);
        return modelData;
    }

    protected static ModelPartBuilder newBreasts(Dilation dilation, int oy) {
        ModelPartBuilder builder = ModelPartBuilder.create();
        if (Config.getInstance().enableBoobs) {
            builder.uv(18, 21 + oy).cuboid(-3.25f, -1.25f, -1.5f, 6.0f, 3.0f, 3.0f, dilation);
        }
        return builder;
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.field_78116_c, (Object)this.field_178720_f);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.field_78115_e, (Object)this.field_178723_h, (Object)this.field_178724_i, (Object)this.field_178721_j, (Object)this.field_178722_k);
    }

    public void func_212843_a_(T entity, float limbAngle, float limbDistance, float tickDelta) {
        super.func_212843_a_(entity, limbDistance, limbAngle, tickDelta);
        this.field_217113_d |= ((VillagerLike)entity).getAgeState() == AgeState.BABY;
    }

    public void func_225597_a_(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((VillagerLike)villager).getAgeState() == AgeState.BABY && !villager.func_184218_aH()) {
            limbDistance = (float)Math.sin((float)((LivingEntity)villager).field_70173_aa / 12.0f);
            limbAngle = (float)Math.cos((float)((LivingEntity)villager).field_70173_aa / 9.0f) * 3.0f;
            headYaw += (float)Math.sin((float)((LivingEntity)villager).field_70173_aa / 2.0f);
        }
        if (villager.func_70631_g_()) {
            limbAngle /= 3.0f;
        }
        super.func_225597_a_(villager, limbAngle /= 0.2f + ((VillagerLike)villager).getRawScaleFactor(), limbDistance, animationProgress, headYaw, headPitch);
        if (((VillagerLike)villager).getVillagerBrain().isPanicking()) {
            float toRadians = (float)Math.PI / 180;
            float armRaise = ((float)Math.sin(animationProgress / 5.0f) * 30.0f - 180.0f + (float)Math.sin(animationProgress / 3.0f) * 3.0f) * toRadians;
            float waveSideways = ((float)Math.sin(animationProgress / 2.0f) * 12.0f - 17.0f) * toRadians;
            this.field_178724_i.field_78795_f = armRaise;
            this.field_178724_i.field_78808_h = -waveSideways;
            this.field_178723_h.field_78795_f = -armRaise;
            this.field_178723_h.field_78808_h = waveSideways;
        }
        this.applyVillagerDimensions((VillagerLike)villager, villager.func_213453_ef());
    }

    public void func_217148_a(BipedModel<T> target) {
        super.func_217148_a(target);
        if (target instanceof VillagerEntityBaseModelMCA) {
            VillagerEntityBaseModelMCA m = (VillagerEntityBaseModelMCA)target;
            this.copyCommonAttributes(m);
            m.breasts.field_78806_j = this.breasts.field_78806_j;
            m.breasts.func_217177_a(this.breasts);
        }
    }

    public void func_225598_a_(MatrixStack matrices, IVertexBuilder vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.renderCommon(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    @Override
    public ModelRenderer getBreastPart() {
        return this.breasts;
    }

    @Override
    public ModelRenderer getBodyPart() {
        return this.field_78115_e;
    }

    @Override
    public Iterable<ModelRenderer> getCommonHeadParts() {
        return this.func_225602_a_();
    }

    @Override
    public Iterable<ModelRenderer> getCommonBodyParts() {
        return this.func_225600_b_();
    }

    @Override
    public Iterable<ModelRenderer> getBreastParts() {
        return ImmutableList.of((Object)this.breasts);
    }

    @Override
    public VillagerDimensions.Mutable getDimensions() {
        return this.dimensions;
    }

    @Override
    public float getBreastSize() {
        return this.breastSize;
    }

    @Override
    public void setBreastSize(float breastSize) {
        this.breastSize = breastSize;
    }
}

