/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.model;

import com.google.common.collect.ImmutableList;
import forge.net.mca.client.model.VillagerEntityBaseModelMCA;
import forge.net.mca.util.compat.model.Dilation;
import forge.net.mca.util.compat.model.ModelData;
import forge.net.mca.util.compat.model.ModelPartBuilder;
import forge.net.mca.util.compat.model.ModelPartCompat;
import forge.net.mca.util.compat.model.ModelPartData;
import forge.net.mca.util.compat.model.ModelTransform;
import forge.net.mca.util.compat.model.PlayerEntityModelCompat;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;

public class VillagerEntityModelMCA<T extends LivingEntity>
extends VillagerEntityBaseModelMCA<T> {
    protected static final String BREASTPLATE = "breastplate";
    public final ModelRenderer breastsWear;
    public final ModelRenderer leftArmwear;
    public final ModelRenderer rightArmwear;
    public final ModelRenderer leftLegwear;
    public final ModelRenderer rightLegwear;
    public final ModelRenderer bodyWear;
    private boolean wearsHidden;

    public VillagerEntityModelMCA(ModelPartCompat tree) {
        super(tree);
        this.bodyWear = tree.getChild("jacket");
        this.leftArmwear = tree.getChild("left_sleeve");
        this.rightArmwear = tree.getChild("right_sleeve");
        this.leftLegwear = tree.getChild("left_pants");
        this.rightLegwear = tree.getChild("right_pants");
        this.breastsWear = tree.getChild(BREASTPLATE);
    }

    public static ModelData hairData(Dilation dilation) {
        ModelData modelData = VillagerEntityModelMCA.bodyData(dilation);
        ModelPartData root = modelData.getRoot();
        root.addChild("hat", ModelPartBuilder.create().uv(32, 0).cuboid(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation.add(0.3f)), ModelTransform.NONE);
        return modelData;
    }

    public static ModelData bodyData(Dilation dilation) {
        return VillagerEntityModelMCA.bodyData(dilation, false);
    }

    public static ModelData bodyData(Dilation dilation, boolean slim) {
        ModelData modelData = PlayerEntityModelCompat.getTexturedModelData(dilation, slim);
        ModelPartData root = modelData.getRoot();
        root.addChild("breasts", VillagerEntityModelMCA.newBreasts(dilation, 0), ModelTransform.NONE);
        root.addChild(BREASTPLATE, VillagerEntityModelMCA.newBreasts(dilation.add(0.1f), 16), ModelTransform.NONE);
        return modelData;
    }

    @Override
    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.field_78115_e, (Object)this.field_178723_h, (Object)this.field_178724_i, (Object)this.field_178721_j, (Object)this.field_178722_k, (Object)this.bodyWear, (Object)this.leftLegwear, (Object)this.rightLegwear, (Object)this.leftArmwear, (Object)this.rightArmwear);
    }

    @Override
    public Iterable<ModelRenderer> getBreastParts() {
        return ImmutableList.of((Object)this.breasts, (Object)this.breastsWear);
    }

    @Override
    public void func_225597_a_(T villager, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        super.func_225597_a_(villager, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        this.leftLegwear.func_217177_a(this.field_178722_k);
        this.rightLegwear.func_217177_a(this.field_178721_j);
        this.leftArmwear.func_217177_a(this.field_178724_i);
        this.rightArmwear.func_217177_a(this.field_178723_h);
        this.bodyWear.func_217177_a(this.field_78115_e);
        this.breastsWear.func_217177_a(this.breasts);
    }

    public void func_178719_a(boolean visible) {
        super.func_178719_a(visible);
        this.leftArmwear.field_78806_j = !this.wearsHidden && visible;
        this.rightArmwear.field_78806_j = !this.wearsHidden && visible;
        this.leftLegwear.field_78806_j = !this.wearsHidden && visible;
        this.rightLegwear.field_78806_j = !this.wearsHidden && visible;
        this.bodyWear.field_78806_j = !this.wearsHidden && visible;
    }

    public VillagerEntityModelMCA<T> hideWears() {
        this.wearsHidden = true;
        this.breastsWear.field_78806_j = false;
        this.leftArmwear.field_78806_j = false;
        this.rightArmwear.field_78806_j = false;
        this.leftLegwear.field_78806_j = false;
        this.rightLegwear.field_78806_j = false;
        this.bodyWear.field_78806_j = false;
        return this;
    }

    @Override
    public void func_217148_a(BipedModel<T> target) {
        super.func_217148_a(target);
        if (target instanceof VillagerEntityModelMCA) {
            this.copyAttributes((VillagerEntityModelMCA)target);
        }
    }

    private void copyAttributes(VillagerEntityModelMCA<T> target) {
        target.leftLegwear.func_217177_a(this.leftLegwear);
        target.rightLegwear.func_217177_a(this.rightLegwear);
        target.leftArmwear.func_217177_a(this.leftArmwear);
        target.rightArmwear.func_217177_a(this.rightArmwear);
        target.bodyWear.func_217177_a(this.bodyWear);
        target.breastsWear.func_217177_a(this.breastsWear);
    }
}

