/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.block.TombstoneBlock;
import forge.net.mca.util.compat.TextRendererCompat;
import forge.net.mca.util.localization.FlowingText;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class TombstoneBlockEntityRenderer
extends TileEntityRenderer<TombstoneBlock.Data> {
    public TombstoneBlockEntityRenderer(TileEntityRendererDispatcher context) {
        super(context);
    }

    public void render(TombstoneBlock.Data entity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        if (!entity.hasEntity()) {
            return;
        }
        BlockState state = entity.func_195044_w();
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.5, 0.5, 0.5);
        Direction facing = ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing.func_185119_l()));
        matrices.func_227861_a_(0.0, 0.0, 0.0);
        matrices.func_227862_a_(0.010416667f, 0.010416667f, 0.010416667f);
        matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        TombstoneBlock block = (TombstoneBlock)state.func_177230_c();
        matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(block.getRotation()));
        Vector3d offset = block.getNameplateOffset();
        matrices.func_227861_a_(offset.func_82615_a(), offset.func_82617_b(), offset.func_82616_c());
        int maxLineWidth = block.getLineWidth();
        FontRenderer text = this.field_228858_b_.func_147548_a();
        float y = this.drawText(text, text.func_238425_b_((ITextProperties)new TranslationTextComponent("block.mca.tombstone.header"), maxLineWidth), 0.0f, matrices, vertexConsumers, light);
        y += 5.0f;
        FlowingText name = entity.getOrCreateEntityName(n -> FlowingText.Factory.wrapLines(text, n, maxLineWidth - 10, block.getMaxNameHeight()));
        matrices.func_227860_a_();
        matrices.func_227862_a_(name.scale(), name.scale(), name.scale());
        y = this.drawText(text, name.lines(), y / name.scale(), matrices, vertexConsumers, light) * name.scale();
        matrices.func_227865_b_();
        this.drawText(text, text.func_238425_b_((ITextProperties)new TranslationTextComponent("block.mca.tombstone.footer." + entity.getGender().binary().getStrName()), maxLineWidth), y += 5.0f, matrices, vertexConsumers, light);
        matrices.func_227865_b_();
    }

    private float drawText(FontRenderer text, List<IReorderingProcessor> lines, float y, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light) {
        for (IReorderingProcessor line : lines) {
            float x = (float)(-text.func_243245_a(line)) / 2.0f;
            TextRendererCompat.drawWithOutline(text, line, x, y, 0xFFFFFF, 0, matrices.func_227866_c_().func_227870_a_(), vertexConsumers, light);
            y += 10.0f;
        }
        return y;
    }
}

