/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import forge.net.mca.Config;
import forge.net.mca.client.model.VillagerEntityBaseModelMCA;
import forge.net.mca.client.model.VillagerEntityModelMCA;
import forge.net.mca.entity.Infectable;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.util.compat.model.Dilation;
import forge.net.mca.util.compat.model.TexturedModelData;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class VillagerLikeEntityMCARenderer<T extends MobEntity>
extends BipedRenderer<T, VillagerEntityModelMCA<T>> {
    public VillagerLikeEntityMCARenderer(EntityRendererManager ctx, VillagerEntityModelMCA<T> model) {
        super(ctx, model, 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, this.createArmorModel(0.3f), this.createArmorModel(0.55f)));
    }

    private VillagerEntityBaseModelMCA<T> createArmorModel(float modelSize) {
        return new VillagerEntityBaseModelMCA(TexturedModelData.of(VillagerEntityBaseModelMCA.getModelData(new Dilation(modelSize)), 64, 32).createModel());
    }

    protected void scale(T villager, MatrixStack matrices, float tickDelta) {
        float height = ((VillagerLike)villager).getRawScaleFactor();
        float width = ((VillagerLike)villager).getHorizontalScaleFactor();
        matrices.func_227862_a_(width, height, width);
        if (((VillagerLike)villager).getAgeState() == AgeState.BABY && !villager.func_184218_aH()) {
            matrices.func_227861_a_(0.0, (double)0.6f, 0.0);
        }
    }

    @Nullable
    protected RenderType getRenderLayer(T entity, boolean showBody, boolean translucent, boolean showOutlines) {
        if (((VillagerLike)entity).hasCustomSkin()) {
            Minecraft minecraftClient = Minecraft.func_71410_x();
            Map map = minecraftClient.func_152342_ad().func_152788_a(((VillagerLike)entity).getGameProfile());
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.func_228644_e_((ResourceLocation)minecraftClient.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.func_228640_c_((ResourceLocation)DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)((VillagerLike)entity).getGameProfile())));
        }
        return null;
    }

    protected boolean func_177070_b(T villager) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return player != null && player.func_70068_e(villager) < 25.0 && Config.getInstance().showNameTags && !villager.func_98034_c((PlayerEntity)player);
    }

    protected boolean isShaking(T entity) {
        return ((Infectable)entity).getInfectionProgress() > 0.2f;
    }
}

