/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render.layer;

import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.render.layer.VillagerLayer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class ClothingLayer<T extends LivingEntity, M extends BipedModel<T>>
extends VillagerLayer<T, M> {
    private final String variant;

    public ClothingLayer(IEntityRenderer<T, M> renderer, M model, String variant) {
        super(renderer, model);
        this.variant = variant;
    }

    @Override
    protected ResourceLocation getSkin(T villager) {
        String v = CommonVillagerModel.getVillager(villager).isBurned() ? "burnt" : this.variant;
        return this.cached(CommonVillagerModel.getVillager(villager).getClothes() + v, clothes -> {
            ResourceLocation id = new ResourceLocation(CommonVillagerModel.getVillager((Entity)villager).getClothes());
            ResourceLocation idNew = new ResourceLocation(id.func_110624_b(), id.func_110623_a().replace("normal", v));
            if (this.canUse(idNew)) {
                return idNew;
            }
            return id;
        });
    }
}

