/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render.layer;

import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Traits;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class FaceLayer<T extends LivingEntity, M extends BipedModel<T>>
extends VillagerLayer<T, M> {
    private static final int FACE_COUNT = 22;
    private final String variant;

    public FaceLayer(IEntityRenderer<T, M> renderer, M model, String variant) {
        super(renderer, model);
        this.variant = variant;
        model.func_178719_a(false);
        ((BipedModel)model).field_78116_c.field_78806_j = true;
    }

    @Override
    protected boolean isTranslucent() {
        return true;
    }

    @Override
    protected ResourceLocation getSkin(T villager) {
        int index = (int)Math.min(21.0f, Math.max(0.0f, CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.FACE) * 22.0f));
        int time = ((LivingEntity)villager).field_70173_aa / 2 + (int)(CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.HEMOGLOBIN) * 65536.0f);
        boolean blink = time % 50 == 1 || time % 57 == 1 || villager.func_70608_bn() || villager.func_233643_dh_();
        boolean hasHeterochromia = this.variant.equals("normal") && CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.Trait.HETEROCHROMIA);
        return this.cached(String.format("mca:skins/face/%s/%s/%d%s.png", this.variant, CommonVillagerModel.getVillager(villager).getGenetics().getGender().getStrName(), index, blink ? "_blink" : (hasHeterochromia ? "_hetero" : "")), ResourceLocation::new);
    }
}

