/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render.layer;

import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.client.resources.ColorPalette;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.util.compat.SheepEntityCompat;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;

public class HairLayer<T extends LivingEntity, M extends BipedModel<T>>
extends VillagerLayer<T, M> {
    public HairLayer(IEntityRenderer<T, M> renderer, M model) {
        super(renderer, model);
        this.model.field_178722_k.field_78806_j = false;
        this.model.field_178721_j.field_78806_j = false;
    }

    @Override
    protected ResourceLocation getSkin(T villager) {
        return this.cached(CommonVillagerModel.getVillager(villager).getHair(), ResourceLocation::new);
    }

    @Override
    protected ResourceLocation getOverlay(T villager) {
        return this.cached(CommonVillagerModel.getVillager(villager).getHair().replace(".png", "_overlay.png"), ResourceLocation::new);
    }

    private float[] getRainbow(LivingEntity entity, float tickDelta) {
        int n = Math.abs(entity.field_70173_aa) / 25 + entity.func_145782_y();
        int o = DyeColor.values().length;
        int p = n % o;
        int q = (n + 1) % o;
        float r = ((float)(Math.abs(entity.field_70173_aa) % 25) + tickDelta) / 25.0f;
        float[] fs = SheepEntityCompat.getRgbColor(DyeColor.func_196056_a((int)p));
        float[] gs = SheepEntityCompat.getRgbColor(DyeColor.func_196056_a((int)q));
        return new float[]{fs[0] * (1.0f - r) + gs[0] * r, fs[1] * (1.0f - r) + gs[1] * r, fs[2] * (1.0f - r) + gs[2] * r};
    }

    @Override
    protected float[] getColor(T villager, float tickDelta) {
        if (CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.Trait.RAINBOW)) {
            return this.getRainbow((LivingEntity)villager, tickDelta);
        }
        float[] hairDye = CommonVillagerModel.getVillager(villager).getHairDye();
        if (hairDye[0] > 0.0f) {
            return hairDye;
        }
        float albinism = CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.Trait.ALBINISM) ? 0.1f : 1.0f;
        return ColorPalette.HAIR.getColor(CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.EUMELANIN) * albinism, CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.PHEOMELANIN) * albinism, 0.0f);
    }
}

