/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import forge.net.mca.MCAClient;
import forge.net.mca.client.model.CommonVillagerModel;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import org.jetbrains.annotations.Nullable;

public abstract class VillagerLayer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final Map<String, ResourceLocation> TEXTURE_CACHE = Maps.newHashMap();
    private static final Map<ResourceLocation, Boolean> TEXTURE_EXIST_CACHE = Maps.newHashMap();
    public final M model;

    public VillagerLayer(IEntityRenderer<T, M> renderer, M model) {
        super(renderer);
        this.model = model;
    }

    @Nullable
    protected ResourceLocation getSkin(T villager) {
        return null;
    }

    @Nullable
    protected ResourceLocation getOverlay(T villager) {
        return null;
    }

    protected float[] getColor(T villager, float tickDelta) {
        return DEFAULT_COLOR;
    }

    protected boolean isTranslucent() {
        return false;
    }

    public void render(MatrixStack transform, IRenderTypeBuffer provider, int light, T villager, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (villager.func_82150_aj()) {
            return;
        }
        if (CommonVillagerModel.getVillager(villager).hasCustomSkin()) {
            return;
        }
        if (villager instanceof PlayerEntity && !MCAClient.useVillagerRenderer(villager.func_110124_au())) {
            return;
        }
        ((BipedModel)this.func_215332_c()).func_217148_a(this.model);
        this.renderFinal(transform, provider, light, villager, tickDelta);
    }

    public void renderFinal(MatrixStack transform, IRenderTypeBuffer provider, int light, T villager, float tickDelta) {
        ResourceLocation overlay;
        int tint = LivingRenderer.func_229117_c_(villager, (float)0.0f);
        ResourceLocation skin = this.getSkin(villager);
        if (this.canUse(skin)) {
            float[] color = this.getColor(villager, tickDelta);
            this.renderModel(transform, provider, light, this.model, color[0], color[1], color[2], skin, tint);
        }
        if (this.canUse(overlay = this.getOverlay(villager))) {
            this.renderModel(transform, provider, light, this.model, 1.0f, 1.0f, 1.0f, overlay, tint);
        }
    }

    private void renderModel(MatrixStack transform, IRenderTypeBuffer provider, int light, M model, float r, float g, float b, ResourceLocation texture, int overlay) {
        IVertexBuilder buffer = provider.getBuffer(this.isTranslucent() ? RenderType.func_228644_e_((ResourceLocation)texture) : RenderType.func_228640_c_((ResourceLocation)texture));
        model.func_225598_a_(transform, buffer, light, overlay, r, g, b, 1.0f);
    }

    protected final boolean canUse(ResourceLocation texture) {
        return TEXTURE_EXIST_CACHE.computeIfAbsent(texture, s -> texture != null && Minecraft.func_71410_x().func_195551_G().func_219533_b(texture));
    }

    @Nullable
    protected final ResourceLocation cached(String name, Function<String, ResourceLocation> supplier) {
        return TEXTURE_CACHE.computeIfAbsent(name, s -> {
            try {
                return (ResourceLocation)supplier.apply((String)s);
            }
            catch (ResourceLocationException ignored) {
                return null;
            }
        });
    }
}

