/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.resources;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ColorPalette {
    static final Map<ResourceLocation, ColorPalette> REGISTRY = new HashMap<ResourceLocation, ColorPalette>();
    public static final ColorPalette SKIN = new ColorPalette(new ResourceLocation("mca", "textures/colormap/villager_skin.png"));
    public static final ColorPalette HAIR = new ColorPalette(new ResourceLocation("mca", "textures/colormap/villager_hair.png"));
    static final Data EMPTY = new Data(1, 1, new int[]{0xFFFFFF});
    private final ResourceLocation id;
    Data data = EMPTY;

    public ColorPalette(ResourceLocation id) {
        this.id = id;
        REGISTRY.put(id, this);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public float[] getColor(float u, float v, float greenShift) {
        int x = ColorPalette.clampFloor(v, this.data.width - 1);
        int y = ColorPalette.clampFloor(u, this.data.height - 1);
        int color = this.data.colors[y * this.data.height + x];
        float[] result = new float[]{(float)NativeImage.func_227795_d_((int)color) / 255.0f, (float)NativeImage.func_227793_c_((int)color) / 255.0f, (float)NativeImage.func_227791_b_((int)color) / 255.0f};
        if (greenShift > 0.0f) {
            ColorPalette.applyGreenShift(result, greenShift);
        }
        return result;
    }

    private static void applyGreenShift(float[] color, float greenShift) {
        float percentDown = 1.0f - greenShift / 1.8f;
        color[0] = MathHelper.func_76131_a((float)(color[0] * percentDown), (float)0.0f, (float)1.0f);
        color[1] = MathHelper.func_76131_a((float)(color[1] * percentDown), (float)0.0f, (float)1.0f);
        color[2] = MathHelper.func_76131_a((float)(color[2] * percentDown), (float)0.0f, (float)1.0f);
    }

    private static int clampFloor(float v, int max) {
        return (int)Math.floor(MathHelper.func_76131_a((float)(v * (float)max), (float)0.0f, (float)max));
    }

    static class Data {
        final int width;
        final int height;
        final int[] colors;

        public Data(int width, int height, int[] colors) {
            this.width = width;
            this.height = height;
            this.colors = colors;
        }
    }
}

