/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.resources;

import forge.net.mca.MCA;
import forge.net.mca.client.resources.ColorPalette;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ColorPaletteLoader
extends ReloadListener<Map<ResourceLocation, ColorPalette.Data>> {
    protected static final ResourceLocation ID = new ResourceLocation("mca", "color_palettes");

    protected Map<ResourceLocation, ColorPalette.Data> prepare(IResourceManager manager, IProfiler profiler) {
        return ColorPalette.REGISTRY.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.loadPalette((ResourceLocation)entry.getKey(), manager)));
    }

    private ColorPalette.Data loadPalette(ResourceLocation id, IResourceManager manager) {
        ColorPalette.Data data;
        block8: {
            NativeImage img = NativeImage.func_195713_a((InputStream)manager.func_199002_a(id).func_199027_b());
            try {
                data = new ColorPalette.Data(img.func_195702_a(), img.func_195714_b(), img.func_195716_c());
                if (img == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (img != null) {
                        try {
                            img.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    MCA.LOGGER.error("Failed to load color palette from `{}`", (Object)id, (Object)e);
                    return ColorPalette.EMPTY;
                }
            }
            img.close();
        }
        return data;
    }

    protected void apply(Map<ResourceLocation, ColorPalette.Data> palettes, IResourceManager manager, IProfiler profiler) {
        palettes.forEach((id, data) -> {
            if (ColorPalette.REGISTRY.containsKey(id)) {
                ColorPalette.REGISTRY.get((Object)id).data = Objects.requireNonNull(data);
            }
        });
    }
}

