/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity;

import forge.net.mca.Config;
import forge.net.mca.SoundsMCA;
import forge.net.mca.entity.ReaperAttackState;
import forge.net.mca.entity.ai.goal.GrimReaperIdleGoal;
import forge.net.mca.entity.ai.goal.GrimReaperMeleeGoal;
import forge.net.mca.entity.ai.goal.GrimReaperRestGoal;
import forge.net.mca.entity.ai.goal.GrimReaperTargetGoal;
import forge.net.mca.item.ItemsMCA;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CEnumParameter;
import forge.net.mca.util.network.datasync.CParameter;
import forge.net.mca.util.network.datasync.CTrackedEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class GrimReaperEntity
extends CreatureEntity
implements CTrackedEntity<GrimReaperEntity> {
    public static final CEnumParameter<ReaperAttackState> ATTACK_STAGE = CParameter.create("attackStage", ReaperAttackState.IDLE);
    public static final CDataManager<GrimReaperEntity> DATA = new CDataManager.Builder<GrimReaperEntity>(GrimReaperEntity.class).addAll(ATTACK_STAGE).build();
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public GrimReaperEntity(EntityType<? extends GrimReaperEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 100;
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
        this.getTypeDataManager().register(this);
    }

    @Override
    public CDataManager<GrimReaperEntity> getTypeDataManager() {
        return DATA;
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233822_e_, (double)0.3f).func_233815_a_(Attributes.field_233819_b_, 40.0);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (Goal)new GrimReaperTargetGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new GrimReaperRestGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new GrimReaperMeleeGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new GrimReaperIdleGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public MovementController func_70605_aq() {
        return this.field_70765_h;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_70106_y();
        }
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected PathNavigator func_175447_b(World world) {
        FlyingPathNavigator navigator = new FlyingPathNavigator((MobEntity)this, world){

            public boolean func_188555_b(BlockPos pos) {
                return true;
            }
        };
        navigator.func_192879_a(false);
        navigator.func_212239_d(false);
        navigator.func_192878_b(true);
        return navigator;
    }

    protected void func_213333_a(DamageSource source, int lootingLvl, boolean hitByPlayer) {
        super.func_213333_a(source, lootingLvl, hitByPlayer);
        ItemEntity itementity = this.func_199703_a((IItemProvider)ItemsMCA.SCYTHE.get());
        if (itementity != null) {
            itementity.func_174873_u();
        }
    }

    public ReaperAttackState getAttackState() {
        return (ReaperAttackState)((Object)this.getTrackedValue(ATTACK_STAGE));
    }

    public void setAttackState(ReaperAttackState state) {
        if (this.getAttackState() == state) {
            return;
        }
        this.setTrackedValue(ATTACK_STAGE, (Object)state);
        switch (state) {
            case PRE: {
                this.func_184185_a((SoundEvent)SoundsMCA.REAPER_SCYTHE_OUT.get(), 1.0f, 1.0f);
                break;
            }
            case POST: {
                this.func_184185_a((SoundEvent)SoundsMCA.REAPER_SCYTHE_SWING.get(), 1.0f, 1.0f);
                break;
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76368_d || source == DamageSource.field_76370_b || source.func_94541_c() || source == DamageSource.field_76372_a) {
            if (source == DamageSource.field_76368_d) {
                this.func_70634_a(this.func_226277_ct_(), this.func_226278_cu_() + 3.0, this.func_226281_cx_());
            }
            return false;
        }
        Entity attacker = source.func_76364_f();
        if (!this.field_70170_p.field_72995_K && this.getAttackState() == ReaperAttackState.BLOCK && attacker != null) {
            double deltaX = this.func_226277_ct_() - attacker.func_226277_ct_();
            double deltaZ = this.func_226281_cx_() - attacker.func_226281_cx_();
            this.func_184185_a((SoundEvent)SoundsMCA.REAPER_BLOCK.get(), 1.0f, 1.0f);
            this.func_70634_a(attacker.func_226277_ct_() - deltaX * 2.0, attacker.func_226278_cu_() + 2.0, this.func_226281_cx_() - deltaZ * 2.0);
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextFloat() >= 0.3f && attacker != null) {
            double deltaX = this.func_226277_ct_() - attacker.func_226277_ct_();
            double deltaZ = this.func_226281_cx_() - attacker.func_226281_cx_();
            this.func_70634_a(attacker.func_226277_ct_() - deltaX * 2.0, attacker.func_226278_cu_() + 2.0, this.func_226281_cx_() - deltaZ * 2.0);
        }
        if (attacker instanceof ArrowEntity) {
            ArrowEntity arrow = (ArrowEntity)attacker;
            if (this.getAttackState() != ReaperAttackState.REST) {
                Entity owner = arrow.func_234616_v_();
                if (owner != null) {
                    double newX = owner.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() >= 0.5f ? 2 : -2);
                    double newZ = owner.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() >= 0.5f ? 2 : -2);
                    this.func_70634_a(newX, owner.func_226278_cu_(), newZ);
                }
                arrow.func_70106_y();
            }
            return false;
        }
        if (this.getAttackState() == ReaperAttackState.REST) {
            damage = (float)((double)damage * 0.25);
        }
        return super.func_70097_a(source, damage);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)SoundsMCA.REAPER_IDLE.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundsMCA.REAPER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187851_gB;
    }

    public void func_70071_h_() {
        LivingEntity entityToAttack;
        super.func_70071_h_();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (!Config.getInstance().allowGrimReaper) {
            this.func_70106_y();
        }
        if (this.func_110143_aJ() <= 0.0f) {
            this.func_213317_d(Vector3d.field_186680_a);
            return;
        }
        PlayerEntity player = this.field_70170_p.func_217362_a((Entity)this, 10.0);
        if (player != null) {
            this.func_70671_ap().func_220679_a(player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_());
        }
        if ((entityToAttack = this.func_70638_az()) != null && entityToAttack.func_233643_dh_()) {
            this.func_70624_b(null);
            this.setAttackState(ReaperAttackState.IDLE);
        }
        this.field_70143_R = 0.0f;
    }

    public void func_70634_a(double x, double y, double z) {
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            super.func_70634_a(x, y, z);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }
}

