/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.MCAClient;
import forge.net.mca.ParticleTypesMCA;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.SoundsMCA;
import forge.net.mca.TagsMCA;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.UpdatableInventory;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import forge.net.mca.entity.ai.BreedableRelationship;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.LongTermMemory;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.entity.ai.Messenger;
import forge.net.mca.entity.ai.Mood;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.entity.ai.Residency;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.VillagerNavigation;
import forge.net.mca.entity.ai.brain.VillagerBrain;
import forge.net.mca.entity.ai.brain.VillagerTasksMCA;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.Personality;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.entity.interaction.VillagerCommandHandler;
import forge.net.mca.item.ItemsMCA;
import forge.net.mca.network.c2s.InteractionVillagerMessage;
import forge.net.mca.resources.Names;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.util.InventoryUtils;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerEntityMCA
extends VillagerEntity
implements VillagerLike<VillagerEntityMCA>,
INamedContainerProvider,
CompassionateEntity<BreedableRelationship>,
ICrossbowUser {
    private static final CDataParameter<Float> INFECTION_PROGRESS = CParameter.create("infectionProgress", 0.0f);
    private static final CDataParameter<Integer> GROWTH_AMOUNT = CParameter.create("growthAmount", -AgeState.getMaxAge());
    private static final CDataManager<VillagerEntityMCA> DATA = VillagerEntityMCA.createTrackedData(VillagerEntityMCA.class).build();
    private VillagerLike.PlayerModel playerModel;
    private int despawnDelay;
    private int burned;
    private final VillagerBrain<VillagerEntityMCA> mcaBrain = new VillagerBrain<VillagerEntityMCA>(this);
    private final LongTermMemory longTermMemory = new LongTermMemory(this);
    final UUID EXTRA_HEALTH_EFFECT_ID = UUID.fromString("87f56a96-686f-4796-b035-22e16ee9e038");
    private final Genetics genetics = new Genetics(this);
    private final Traits traits = new Traits(this);
    private final Residency residency = new Residency(this);
    private final BreedableRelationship relations = new BreedableRelationship(this);
    private final VillagerCommandHandler interactions = new VillagerCommandHandler(this);
    private final UpdatableInventory inventory = new UpdatableInventory(27);
    private final VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.UNASSIGNED);
    private int prevGrowthAmount;
    private boolean recalcDimensionsBlocked;
    private GameProfile gameProfile;

    @Override
    public VillagerLike.PlayerModel getPlayerModel() {
        return this.playerModel;
    }

    @Override
    public boolean isBurned() {
        return this.burned > 0;
    }

    public void func_213766_ei() {
        Optional<Village> village;
        super.func_213766_ei();
        if (!this.field_70170_p.field_72995_K && (village = this.residency.getHomeVillage()).isPresent() && Config.getInstance().villagerRestockNotification) {
            village.get().broadCastMessage((ServerWorld)this.field_70170_p, "events.restock", this.func_200200_C_().getString());
        }
    }

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(Class<E> type) {
        return VillagerLike.createTrackedData(type).addAll(INFECTION_PROGRESS, GROWTH_AMOUNT).add(Residency::createTrackedData).add(BreedableRelationship::createTrackedData);
    }

    public VillagerEntityMCA(EntityType<VillagerEntityMCA> type, World w, Gender gender) {
        super(type, w);
        this.inventory.func_110134_a(this::onInvChange);
        this.genetics.setGender(gender);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.getTypeDataManager().register(this);
    }

    @Override
    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public void updateCustomSkin() {
        if (!MCA.isBlankString((String)this.getTrackedValue(CUSTOM_SKIN))) {
            this.gameProfile = new GameProfile(null, (String)this.getTrackedValue(CUSTOM_SKIN));
            this.gameProfile = SkullTileEntity.func_174884_b((GameProfile)this.gameProfile);
        } else {
            this.gameProfile = null;
        }
    }

    @Override
    public CDataManager<VillagerEntityMCA> getTypeDataManager() {
        return DATA;
    }

    protected PathNavigator func_175447_b(World world) {
        return new VillagerNavigation((MobEntity)this, world);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        return VillagerTasksMCA.initializeTasks(this, (Brain<VillagerEntityMCA>)VillagerTasksMCA.createProfile().func_233748_a_(dynamic));
    }

    public void func_213770_a(ServerWorld world) {
        Brain<VillagerEntityMCA> brain = this.getMCABrain();
        brain.func_218227_b(world, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        VillagerTasksMCA.initializeTasks(this, this.getMCABrain());
    }

    public Brain<VillagerEntityMCA> getMCABrain() {
        return this.field_213378_br;
    }

    @Override
    public Genetics getGenetics() {
        return this.genetics;
    }

    @Override
    public Traits getTraits() {
        return this.traits;
    }

    @Override
    public BreedableRelationship getRelationships() {
        return this.relations;
    }

    @Override
    public VillagerBrain<?> getVillagerBrain() {
        return this.mcaBrain;
    }

    public LongTermMemory getLongTermMemory() {
        return this.longTermMemory;
    }

    public Residency getResidency() {
        return this.residency;
    }

    public VillagerCommandHandler getInteractions() {
        return this.interactions;
    }

    protected ITextComponent func_225513_by_() {
        return this.getProfessionText();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT entityNbt) {
        ILivingEntityData data = super.func_213386_a(world, difficulty, spawnReason, entityData, entityNbt);
        this.initialize(spawnReason);
        this.setAgeState(AgeState.byCurrentAge(this.func_70874_b()));
        FamilyTreeNode entry = this.getRelationships().getFamilyEntry();
        if (!FamilyTreeNode.isValid(entry.father()) && !FamilyTreeNode.isValid(entry.mother())) {
            FamilyTree tree = FamilyTree.get(world.func_201672_e());
            FamilyTreeNode father = tree.getOrCreate(UUID.randomUUID(), Names.pickCitizenName(Gender.MALE), Gender.MALE);
            FamilyTreeNode mother = tree.getOrCreate(UUID.randomUUID(), Names.pickCitizenName(Gender.FEMALE), Gender.FEMALE);
            father.setDeceased(true);
            mother.setDeceased(true);
            entry.setFather(father);
            entry.setMother(mother);
        }
        return data;
    }

    public final VillagerProfession getProfession() {
        return this.func_213700_eh().func_221130_b();
    }

    public final void setProfession(VillagerProfession profession) {
        this.func_213753_a(this.func_213700_eh().func_221126_a(profession));
        this.func_213770_a((ServerWorld)this.field_70170_p);
    }

    @Override
    public ResourceLocation getProfessionId() {
        return Registry.field_218370_L.func_177774_c((Object)this.getProfession());
    }

    @Override
    public boolean isProfessionImportant() {
        return ProfessionsMCA.isImportant.contains(this.getProfession());
    }

    @Override
    public boolean doesProfessionRequireHome() {
        return !ProfessionsMCA.needsNoHome.contains(this.getProfession());
    }

    @Override
    public boolean canTradeWithProfession() {
        return !ProfessionsMCA.canNotTrade.contains(this.getProfession());
    }

    public void func_213753_a(VillagerData data) {
        boolean hasChanged = !this.field_70170_p.field_72995_K && this.getProfession() != data.func_221130_b() && data.func_221130_b() != ProfessionsMCA.OUTLAW.get();
        super.func_213753_a(data);
        if (hasChanged) {
            this.randomizeClothes();
            this.getRelationships().getFamilyEntry().setProfession(data.func_221130_b());
        }
    }

    public void func_82227_f(boolean isBaby) {
        this.func_70873_a(isBaby ? -AgeState.getMaxAge() : 0);
    }

    public boolean func_70631_g_() {
        return super.func_70631_g_();
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (name != null) {
            this.setName(name.getString());
        }
    }

    public int func_70874_b() {
        return super.func_70874_b();
    }

    public void func_70873_a(int age) {
        super.func_70873_a(age);
        if (age != -2) {
            this.setTrackedValue(GROWTH_AMOUNT, age);
            this.setAgeState(AgeState.byCurrentAge(age));
            AgeState current = this.getAgeState();
            AgeState next = current.getNext();
            if (current != next) {
                this.dimensions.interpolate(current, next, AgeState.getDelta(age));
            } else {
                this.dimensions.set(current);
            }
        }
    }

    public int func_223107_f(PlayerEntity player) {
        return super.func_223107_f(player);
    }

    public boolean func_70652_k(Entity target) {
        boolean damageDealt;
        int i;
        this.attackedEntity(target);
        if (this.mcaBrain.getPersonality() == Personality.PEACEFUL && this.func_110143_aJ() == this.func_110138_aP()) {
            return false;
        }
        float damage = this.getProfession() == ProfessionsMCA.GUARD.get() ? 9.0f : 3.0f;
        float knockback = 1.0f;
        damage *= this.mcaBrain.getPersonality().getDamageModifier();
        if (target instanceof LivingEntity) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)target).func_70668_bt());
            knockback += (float)EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
            target.func_70015_d(i * 4);
        }
        if (damageDealt = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).func_233627_a_(knockback / 2.0f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            this.func_174815_a((LivingEntity)this, target);
            this.func_130011_c(target);
        }
        return damageDealt;
    }

    private void attackedEntity(Entity target) {
        if (target instanceof PlayerEntity) {
            this.pardonPlayers((PlayerEntity)target);
        }
    }

    private void pardonPlayers() {
        this.pardonPlayers(1);
    }

    public void pardonPlayers(int amount) {
        int bounty = this.getSmallBounty();
        if (bounty <= amount) {
            this.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.SMALL_BOUNTY.get());
            this.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
            this.func_213375_cj().func_218189_b((MemoryModuleType)MemoryModuleTypeMCA.HIT_BY_PLAYER.get());
        } else {
            this.func_213375_cj().func_218205_a((MemoryModuleType)MemoryModuleTypeMCA.SMALL_BOUNTY.get(), (Object)(bounty - amount));
        }
    }

    private void pardonPlayers(PlayerEntity attacker) {
        this.pardonPlayers();
        int bounty = this.getSmallBounty();
        if (bounty <= this.getMaxWarnings(attacker)) {
            this.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
        }
    }

    public boolean canInteractWithItemStackInHand(ItemStack stack) {
        return stack.func_77973_b() != ItemsMCA.VILLAGER_EDITOR.get() && stack.func_77973_b() != ItemsMCA.NEEDLE_AND_THREAD.get() && stack.func_77973_b() != ItemsMCA.COMB.get() && stack.func_77973_b() != ItemsMCA.POTION_OF_FEMINITY.get() && stack.func_77973_b() != ItemsMCA.POTION_OF_MASCULINITY.get();
    }

    public final ActionResultType func_184199_a(PlayerEntity player, Vector3d pos, @NotNull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean isOnBlacklist = Config.getInstance().villagerInteractionItemBlacklist.contains(Registry.field_212630_s.func_177774_c((Object)stack.func_77973_b()).toString());
        if (hand.equals((Object)Hand.MAIN_HAND) && !isOnBlacklist && !stack.func_77973_b().func_206844_a(TagsMCA.Items.VILLAGER_EGGS) && this.canInteractWithItemStackInHand(stack) && !this.getVillagerBrain().isPanicking()) {
            this.getDialogueType(player);
            if (player.func_225608_bj_()) {
                if (player instanceof ServerPlayerEntity) {
                    ServerPlayerEntity e = (ServerPlayerEntity)player;
                    NetworkHandler.sendToPlayer(new InteractionVillagerMessage("trade", this.field_96093_i), e);
                }
            } else {
                this.playWelcomeSound();
                return this.interactions.interactAt(player, pos, hand);
            }
        }
        return super.func_184199_a(player, pos, hand);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_77973_b().func_206844_a(TagsMCA.Items.VILLAGER_EGGS) && this.func_70089_S() && !this.func_213716_dX() && !this.func_70608_bn() && this.canInteractWithItemStackInHand(stack) && !this.getVillagerBrain().isPanicking()) {
            if (this.func_70631_g_()) {
                this.sayNo();
            } else {
                boolean hasOffers;
                boolean bl = hasOffers = !this.func_213706_dY().isEmpty();
                if (hand == Hand.MAIN_HAND) {
                    if (!hasOffers && !this.field_70170_p.field_72995_K) {
                        this.sayNo();
                    }
                    player.func_195066_a(Stats.field_188074_H);
                }
                if (hasOffers && !this.field_70170_p.field_72995_K) {
                    this.beginTradeWith(player);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private void sayNo() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(this.getNoSound(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    private void beginTradeWith(PlayerEntity customer) {
        this.prepareOffersFor(customer);
        this.func_70932_a_(customer);
        this.func_213707_a(customer, this.func_145748_c_(), this.func_213700_eh().func_221132_c());
    }

    private void prepareOffersFor(PlayerEntity player) {
        int reputation = this.func_223107_f(player);
        if (reputation != 0) {
            for (MerchantOffer tradeOffer : this.func_213706_dY()) {
                tradeOffer.func_222207_a(-MathHelper.func_76141_d((float)((float)reputation * tradeOffer.func_222211_m())));
            }
        }
        if (player.func_70644_a(Effects.field_220310_F)) {
            EffectInstance statusEffect = player.func_70660_b(Effects.field_220310_F);
            int amplifier = statusEffect.func_76458_c();
            for (MerchantOffer tradeOffer2 : this.func_213706_dY()) {
                double d = 0.3 + 0.0625 * (double)amplifier;
                int k = (int)Math.floor(d * (double)tradeOffer2.func_222218_a().func_190916_E());
                tradeOffer2.func_222207_a(-Math.max(k, 1));
            }
        }
    }

    public VillagerEntityMCA createChild(ServerWorld world, AgeableEntity partner) {
        VillagerEntityMCA child = partner instanceof VillagerEntityMCA ? this.relations.getPregnancy().createChild(Gender.getRandom(), (VillagerEntityMCA)partner) : this.relations.getPregnancy().createChild(Gender.getRandom());
        child.func_213753_a(child.func_213700_eh().func_221134_a(this.getRandomType(partner)));
        child.func_213386_a((IServerWorld)world, world.func_175649_E(child.func_233580_cy_()), SpawnReason.BREEDING, null, null);
        return child;
    }

    private VillagerType getRandomType(AgeableEntity partner) {
        double d = this.field_70146_Z.nextDouble();
        if (d < 0.5) {
            return VillagerType.func_242371_a((Optional)this.field_70170_p.func_242406_i(this.func_233580_cy_()));
        }
        if (d < 0.75) {
            return this.func_213700_eh().func_221129_a();
        }
        return ((VillagerEntity)partner).func_213700_eh().func_221129_a();
    }

    public final boolean func_70097_a(DamageSource source, float damageAmount) {
        Entity attacker;
        if (!Config.getInstance().canHurtBabies && !source.func_151517_h() && this.getAgeState() == AgeState.BABY) {
            if (source.func_76346_g() instanceof PlayerEntity) {
                Messenger.sendEventMessage(this.field_70170_p, (ITextComponent)new TranslationTextComponent("villager.baby_hit"));
            }
            return super.func_70097_a(source, 0.0f);
        }
        if (this.getProfession() == ProfessionsMCA.GUARD.get()) {
            damageAmount = (float)((double)damageAmount * 0.5);
        }
        damageAmount *= this.mcaBrain.getPersonality().getWeaknessModifier();
        if (!this.field_70170_p.field_72995_K) {
            if (source.func_76346_g() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)source.func_76346_g();
                if (!this.isGuard() || this.getSmallBounty() == 0) {
                    if (this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                        this.sendChatMessage(player, "villager.badly_hurt", new Object[0]);
                    } else {
                        this.sendChatMessage(player, "villager.hurt", new Object[0]);
                    }
                }
                int trustIssues = (int)((1.0 - (double)(this.func_110143_aJ() / this.func_110138_aP()) * 0.75) * (3.0 + 2.0 * (double)damageAmount));
                this.getVillagerBrain().getMemoriesForPlayer(player).modHearts(-trustIssues);
            }
            if (source.func_76364_f() instanceof ZombieEntity && this.getProfession() != ProfessionsMCA.GUARD.get() && Config.getInstance().enableInfection && (double)this.field_70146_Z.nextFloat() < (double)Config.getInstance().infectionChance / 100.0 && this.field_70146_Z.nextFloat() > (float)(this.func_213700_eh().func_221132_c() - 1) * Config.getInstance().infectionChanceDecreasePerLevel && (!this.getResidency().getHomeVillage().filter(v -> v.hasBuilding("infirmary")).isPresent() || this.field_70146_Z.nextBoolean())) {
                this.setInfected(true);
                this.sendChatToAllAround("villager.bitten", new Object[0]);
                MCA.LOGGER.info(this.func_200200_C_() + " has been infected");
            }
        }
        Entity entity = attacker = source != null ? source.func_76346_g() : null;
        if (attacker instanceof LivingEntity && !this.isHostile() && !this.isFriend(attacker.func_200600_R())) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            this.func_213375_cj().func_218226_a((MemoryModuleType)MemoryModuleTypeMCA.HIT_BY_PLAYER.get(), Optional.of(livingEntity));
            this.func_213375_cj().func_218205_a((MemoryModuleType)MemoryModuleTypeMCA.SMALL_BOUNTY.get(), (Object)(this.getSmallBounty() + 1));
            Vector3d pos = this.func_213303_ch();
            this.field_70170_p.func_217357_a(VillagerEntityMCA.class, new AxisAlignedBB(pos, pos).func_186662_g(32.0)).forEach(v -> {
                double d = this.func_70068_e((Entity)v);
                int n = v.func_70638_az() == null ? 1024 : 64;
                if (d <= (double)n) {
                    if (attacker instanceof PlayerEntity) {
                        int bounty = v.getSmallBounty();
                        PlayerEntity player = (PlayerEntity)attacker;
                        if (v.isGuard()) {
                            int maxWarning = v.getMaxWarnings(player);
                            if (bounty > maxWarning) {
                                v.func_213375_cj().func_218205_a(MemoryModuleType.field_234103_o_, (Object)livingEntity);
                            } else if (bounty == 0 || bounty == maxWarning) {
                                v.sendChatMessage(player, "villager.warning", new Object[0]);
                            }
                            v.func_213375_cj().func_218205_a((MemoryModuleType)MemoryModuleTypeMCA.SMALL_BOUNTY.get(), (Object)(bounty + 1));
                        }
                    } else if (v.isGuard()) {
                        v.func_213375_cj().func_218205_a(MemoryModuleType.field_234103_o_, (Object)livingEntity);
                    }
                }
            });
        }
        if (attacker instanceof IronGolemEntity) {
            IronGolemEntity golem = (IronGolemEntity)attacker;
            golem.func_241356_K__();
            try {
                Field targetSelector = MobEntity.class.getDeclaredField("targetSelector");
                ((GoalSelector)targetSelector.get(attacker)).func_220888_c().forEach(g -> {
                    if (g.func_220772_j() instanceof TargetGoal) {
                        g.func_220772_j().func_75251_c();
                    }
                });
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            damageAmount = (float)((double)damageAmount * 0.0);
        }
        return super.func_70097_a(source, damageAmount);
    }

    public boolean isGuard() {
        return this.getProfession() == ProfessionsMCA.GUARD.get() || this.getProfession() == ProfessionsMCA.ARCHER.get();
    }

    public int getSmallBounty() {
        return this.func_213375_cj().func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.SMALL_BOUNTY.get()).orElse(0);
    }

    public boolean isHitBy(ServerPlayerEntity player) {
        return this.func_213375_cj().func_218207_c((MemoryModuleType)MemoryModuleTypeMCA.HIT_BY_PLAYER.get()).filter(v -> v == player).isPresent();
    }

    private int getMaxWarnings(PlayerEntity attacker) {
        return this.getVillagerBrain().getMemoriesForPlayer(attacker).getHearts() / Config.getInstance().heartsForPardonHit;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
        --this.burned;
        if (this.func_70027_ad()) {
            this.burned = Config.getInstance().burnedClothingTickLength;
        }
        if (this.burned > 0) {
            this.spawnBurntParticles();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 200 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                ItemStack food = this.func_184614_ca();
                if (food.func_222117_E()) {
                    this.func_213357_a(this.field_70170_p, food);
                } else if (!this.findAndEquipToMain(i -> i.func_222117_E() && i.func_77973_b().func_219967_s().func_221466_a() > 0 && i.func_77973_b().func_219967_s().func_221464_f().stream().allMatch(e -> ((EffectInstance)e.getFirst()).func_188419_a().func_188408_i()))) {
                    this.func_70691_i(1.0f);
                }
            }
            this.tickDespawnDelay();
            this.residency.tick();
            this.relations.tick(this.field_70173_aa);
            this.inventory.update((Entity)this);
            if (this.field_70173_aa % Config.getInstance().pardonPlayerTicks == 0) {
                this.pardonPlayers();
            }
            this.mcaBrain.think();
            if (this.field_70173_aa % Config.getInstance().giftDesaturationReset == 0) {
                this.getRelationships().getGiftSaturation().pop();
            }
        }
    }

    protected boolean findAndEquipToMain(Predicate<ItemStack> predicate) {
        ItemStack replacement;
        int slot = InventoryUtils.getFirstSlotContainingItem((IInventory)this.func_213715_ed(), predicate);
        if (slot > -1 && !(replacement = this.func_213715_ed().func_70301_a(slot).func_77979_a(1)).func_190926_b()) {
            this.func_184611_a(this.getDominantHand(), replacement);
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int age = (Integer)this.getTrackedValue(GROWTH_AMOUNT);
        if (age != this.prevGrowthAmount || this.recalcDimensionsBlocked) {
            this.prevGrowthAmount = age;
            this.func_213323_x_();
        }
        if (this.field_70170_p.field_72995_K) {
            Mood mood;
            if (this.relations.isProcreating()) {
                this.field_70759_as += 50.0f;
            }
            if ((mood = this.mcaBrain.getMood()).getParticle() != null && this.field_70173_aa % mood.getParticleInterval() == 0 && this.field_70170_p.field_73012_v.nextBoolean()) {
                this.func_213718_a((IParticleData)mood.getParticle());
            }
        } else {
            ModifiableAttributeInstance instance;
            float infection = this.getInfectionProgress();
            if (infection > 0.0f && this.field_70173_aa % 20 == 0) {
                if (infection > 0.2f && this.field_70170_p.field_73012_v.nextInt(25) == 0) {
                    this.sendChatToAllAround("villager.sickness", new Object[0]);
                }
                this.setInfectionProgress(infection += 1.0f / (float)Config.getInstance().infectionTime);
                if (infection > 1.0f) {
                    this.func_233656_b_(EntityType.field_200727_aF, false);
                    this.func_70106_y();
                }
            }
            if (this.field_70173_aa % 90 == 0 && this.mcaBrain.isPanicking()) {
                this.sendChatToAllAround("villager.scream", new Object[0]);
            }
            if (this.field_70173_aa % 60 == 0 && this.field_70146_Z.nextInt(50) == 0 && this.traits.hasTrait(Traits.Trait.SIRBEN)) {
                this.sendChatToAllAround("sirben", new Object[0]);
            }
            if ((instance = this.func_233645_dx_().func_233779_a_(Attributes.field_233818_a_)) != null) {
                int level = this.func_213700_eh().func_221132_c() - 1;
                instance.func_188479_b(this.EXTRA_HEALTH_EFFECT_ID);
                instance.func_233767_b_(new AttributeModifier(this.EXTRA_HEALTH_EFFECT_ID, "level health boost", (double)(Config.getInstance().villagerHealthBonusPerLevel * level), AttributeModifier.Operation.ADDITION));
            }
            if (this.field_70173_aa % 12000 == 0) {
                int base = Math.round((float)this.mcaBrain.getMoodValue() / 12.0f);
                int value = this.field_70146_Z.nextInt(7) - 3;
                this.mcaBrain.modifyMoodValue(value - base);
            }
        }
    }

    public void func_213323_x_() {
        AgeState current = this.getAgeState();
        AgeState next = current.getNext();
        VillagerDimensions.Mutable old = new VillagerDimensions.Mutable(this.dimensions);
        if (next != current) {
            this.dimensions.interpolate(current, next, AgeState.getDelta(((Integer)this.getTrackedValue(GROWTH_AMOUNT)).intValue()));
        } else {
            this.dimensions.set(current);
        }
        boolean oldOnGround = this.field_70122_E;
        super.func_213323_x_();
        this.field_70122_E = oldOnGround;
        if (!this.field_70148_d && !this.field_70170_p.func_226669_j_((Entity)this)) {
            this.dimensions.set(old);
            super.func_213323_x_();
            this.recalcDimensionsBlocked = true;
        } else {
            this.recalcDimensionsBlocked = false;
        }
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        if (stack.func_222117_E()) {
            this.func_70691_i(stack.func_77973_b().func_219967_s().func_221466_a());
        }
        return super.func_213357_a(world, stack);
    }

    public void func_70098_U() {
        super.func_70098_U();
        Entity vehicle = this.func_184187_bx();
        if (vehicle instanceof CreatureEntity) {
            this.field_70761_aq = ((CreatureEntity)vehicle).field_70761_aq;
        }
        if (vehicle instanceof PlayerEntity) {
            Vector3d offset;
            boolean head;
            List passengers = vehicle.func_184188_bt();
            float yaw = -((PlayerEntity)vehicle).field_70761_aq * ((float)Math.PI / 180);
            boolean left = passengers.get(0) == this;
            boolean bl = head = passengers.size() > 2 && passengers.get(2) == this;
            Vector3d vector3d = head ? new Vector3d(0.0, (double)0.35f, 0.0) : (offset = new Vector3d(left ? (double)0.4f : (double)-0.4f, (double)0.05f, 0.0).func_178785_b(yaw));
            if (this.field_70170_p.field_72995_K && MCAClient.useGeneticsRenderer(vehicle.func_110124_au())) {
                float height = CommonVillagerModel.getVillager(vehicle).getRawScaleFactor();
                offset = offset.func_216372_d(1.0, (double)height, 1.0);
                offset = offset.func_72441_c(0.0, vehicle.func_70042_X() * (double)height - vehicle.func_70042_X(), 0.0);
            }
            Vector3d pos = this.func_213303_ch();
            this.func_226288_n_(pos.func_82615_a() + offset.func_82615_a(), pos.func_82617_b() + offset.func_82617_b(), pos.func_82616_c() + offset.func_82616_c());
            if (vehicle.func_225608_bj_()) {
                this.func_184210_p();
            }
        }
    }

    public double func_70033_W() {
        Entity vehicle = this.func_184187_bx();
        if (vehicle instanceof PlayerEntity) {
            return -0.2;
        }
        return -0.35;
    }

    public double func_70042_X() {
        return super.func_70042_X();
    }

    public EntitySize func_213305_a(Pose pose) {
        Entity vehicle = this.func_184187_bx();
        if (vehicle instanceof PlayerEntity) {
            return field_213377_as;
        }
        if (pose == Pose.SLEEPING) {
            return field_213377_as;
        }
        float height = this.func_213355_cm() * 2.0f;
        float width = this.getHorizontalScaleFactor() * 0.6f;
        return EntitySize.func_220314_b((float)width, (float)height);
    }

    public void func_70645_a(DamageSource cause) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            this.func_184201_a(slot, ItemStack.field_190927_a);
        }
        super.func_70645_a(cause);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if ((cause.func_76346_g() instanceof ZombieEntity || cause.func_76346_g() instanceof ZombieVillagerEntity) && this.getInfectionProgress() >= 0.6f) {
            boolean wasRemoved = this.field_70128_L;
            this.field_70128_L = false;
            this.func_233656_b_(EntityType.field_200727_aF, false);
            this.field_70128_L = wasRemoved;
            return;
        }
        InventoryUtils.dropAllItems((Entity)this, (IInventory)this.inventory);
        this.relations.onDeath(cause);
        Optional<Village> village = this.residency.getHomeVillage();
        if (village.isPresent()) {
            ServerWorld servRef = (ServerWorld)this.field_70170_p;
            Map<UUID, Memories> memories = this.mcaBrain.getMemories();
            if (cause.func_76346_g() != null) {
                servRef.func_217369_A().forEach(player -> {
                    Rank relationToVillage = Tasks.getRank((Village)village.get(), player);
                    ResourceLocation causeId = EntityType.func_200718_a((EntityType)cause.func_76346_g().func_200600_R());
                    CriterionMCA.FATE.trigger((ServerPlayerEntity)player, causeId, relationToVillage);
                });
            }
            for (Map.Entry<UUID, Memories> entry : memories.entrySet()) {
                village.get().pushHearts(entry.getKey(), entry.getValue().getHearts());
                village.get().markDirty(servRef);
            }
        }
        this.residency.leaveHome();
    }

    public MovementController func_70605_aq() {
        return this.isRidingHorse() ? this.field_70765_h : super.func_70605_aq();
    }

    public JumpController func_70683_ar() {
        return this.field_70767_i;
    }

    public PathNavigator func_70661_as() {
        return this.isRidingHorse() ? this.field_70699_by : super.func_70661_as();
    }

    protected boolean isRidingHorse() {
        return this.func_184218_aH() && this.func_184187_bx() instanceof AbstractHorseEntity;
    }

    public void func_70634_a(double destX, double destY, double destZ) {
        Entity rootVehicle;
        if (this.func_184218_aH() && (rootVehicle = this.func_184208_bv()) instanceof MobEntity) {
            rootVehicle.func_70634_a(destX, destY, destZ);
            return;
        }
        super.func_70634_a(destX, destY, destZ);
    }

    public SoundEvent func_184615_bR() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_SCREAM.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_SCREAM.get();
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.func_184615_bR();
        }
        return null;
    }

    public SoundEvent getSurprisedSound() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_SURPRISE.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_SURPRISE.get();
        }
        return (SoundEvent)SoundsMCA.SILENT.get();
    }

    @Nullable
    protected final SoundEvent func_184639_G() {
        if (Config.getInstance().useMCAVoices) {
            if (this.getAgeState() == AgeState.BABY) {
                return (SoundEvent)SoundsMCA.VILLAGER_BABY_LAUGH.get();
            }
            if (this.func_70608_bn()) {
                return this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_SNORE.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_SNORE.get();
            }
            if (this.getVillagerBrain().isPanicking()) {
                return this.func_184615_bR();
            }
            if (this.isInfected() && this.field_70146_Z.nextBoolean()) {
                return this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_COUGH.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_COUGH.get();
            }
            if (this.field_70146_Z.nextBoolean() && this.getTraits().hasTrait(Traits.Trait.SIRBEN)) {
                return (SoundEvent)SoundsMCA.SIRBEN.get();
            }
            Mood mood = this.getVillagerBrain().getMood();
            if (mood.getSoundInterval() > 0 && this.field_70173_aa % mood.getSoundInterval() == 0) {
                return this.getGenetics().getGender() == Gender.MALE ? mood.getSoundMale() : mood.getSoundFemale();
            }
            return null;
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.func_184639_G();
        }
        return null;
    }

    protected final SoundEvent func_184601_bQ(DamageSource cause) {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_HURT.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_HURT.get();
        }
        return super.func_184601_bQ(cause);
    }

    public final void playWelcomeSound() {
        if (Config.getInstance().useMCAVoices && !this.getVillagerBrain().isPanicking() && this.getAgeState() != AgeState.BABY) {
            this.func_184185_a(this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_GREET.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_GREET.get(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public final void playSurprisedSound() {
        if (Config.getInstance().useMCAVoices) {
            this.func_184185_a(this.getSurprisedSound(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public SoundEvent func_213714_ea() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_YES.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_YES.get();
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.func_213714_ea();
        }
        return (SoundEvent)SoundsMCA.SILENT.get();
    }

    public SoundEvent getNoSound() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_NO.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_NO.get();
        }
        if (Config.getInstance().useVanillaVoices) {
            return SoundEvents.field_187913_gm;
        }
        return (SoundEvent)SoundsMCA.SILENT.get();
    }

    protected SoundEvent func_213721_r(boolean sold) {
        if (Config.getInstance().useMCAVoices) {
            return sold ? this.func_213714_ea() : this.getNoSound();
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.func_213721_r(sold);
        }
        return (SoundEvent)SoundsMCA.SILENT.get();
    }

    public void func_213711_eb() {
        if (Config.getInstance().useMCAVoices) {
            this.func_184185_a(this.getGenetics().getGender() == Gender.MALE ? (SoundEvent)SoundsMCA.VILLAGER_MALE_CELEBRATE.get() : (SoundEvent)SoundsMCA.VILLAGER_FEMALE_CELEBRATE.get(), this.func_70599_aP(), this.func_70647_i());
        } else if (Config.getInstance().useVanillaVoices) {
            super.func_213711_eb();
        } else {
            this.func_184185_a((SoundEvent)SoundsMCA.SILENT.get(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public float func_70647_i() {
        float r = (this.field_70146_Z.nextFloat() - 0.5f) * 0.05f;
        float g = (this.genetics.getGene(Genetics.VOICE) - 0.5f) * 0.3f;
        float a = MathHelper.func_219799_g((float)AgeState.getDelta(this.field_70173_aa), (float)this.getAgeState().getPitch(), (float)this.getAgeState().getNext().getPitch());
        return a + r + g;
    }

    public final ITextComponent func_145748_c_() {
        ITextComponent name = super.func_145748_c_();
        if (this.getVillagerBrain() != null) {
            Chore chore;
            MoveState state = this.getVillagerBrain().getMoveState();
            if (state != MoveState.MOVE) {
                name = name.func_230532_e_().func_240702_b_(" (").func_230529_a_(state.getName()).func_240702_b_(")");
            }
            if ((chore = this.getVillagerBrain().getCurrentJob()) != Chore.NONE) {
                name = name.func_230532_e_().func_240702_b_(" (").func_230529_a_(chore.getName()).func_240702_b_(")");
            }
        }
        if (this.isInfected()) {
            return name.func_230532_e_().func_240699_a_(TextFormatting.GREEN);
        }
        if (this.getProfession() == ProfessionsMCA.OUTLAW.get()) {
            return name.func_230532_e_().func_240699_a_(TextFormatting.RED);
        }
        return name;
    }

    @Nullable
    public final ITextComponent func_200201_e() {
        String value = (String)this.getTrackedValue(VILLAGER_NAME);
        return MCA.isBlankString(value) ? null : new StringTextComponent(value);
    }

    @Override
    public float getInfectionProgress() {
        return ((Float)this.getTrackedValue(INFECTION_PROGRESS)).floatValue();
    }

    @Override
    public void setInfectionProgress(float progress) {
        this.setTrackedValue(INFECTION_PROGRESS, Float.valueOf(progress));
    }

    @Override
    public void playSpeechEffect() {
        if (this.isSpeechImpaired()) {
            this.func_184185_a(SoundEvents.field_187899_gZ, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213718_a(IParticleData parameters) {
        super.func_213718_a(parameters);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return ChestContainer.func_216992_a((int)i, (PlayerInventory)playerInventory, (IInventory)this.inventory);
    }

    @Override
    public VillagerDimensions getVillagerDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean setAgeState(AgeState state) {
        if (VillagerLike.super.setAgeState(state)) {
            if (!this.field_70170_p.field_72995_K) {
                this.relations.getParents().filter(e -> e instanceof ServerPlayerEntity).map(ServerPlayerEntity.class::cast).forEach(e -> CriterionMCA.CHILD_AGE_STATE_CHANGE.trigger((ServerPlayerEntity)e, state.name()));
                if (state == AgeState.ADULT) {
                    this.relations.getParents().filter(e -> e instanceof PlayerEntity).map(PlayerEntity.class::cast).forEach(p -> this.sendEventMessage((ITextComponent)new TranslationTextComponent("notify.child.grownup", new Object[]{this.func_200200_C_()}), (PlayerEntity)p));
                }
                this.func_213770_a((ServerWorld)this.field_70170_p);
                this.randomizeClothes();
            }
            return true;
        }
        return false;
    }

    public float func_213355_cm() {
        return Math.min(0.999f, this.getRawScaleFactor());
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_213355_cm() * 1.75f;
    }

    public void func_184206_a(DataParameter<?> par) {
        if (this.getTypeDataManager().isParam(AGE_STATE, par) || this.getTypeDataManager().isParam(Genetics.SIZE.getParam(), par)) {
            this.func_213323_x_();
        }
        if (this.getTypeDataManager().isParam(CUSTOM_SKIN, par)) {
            this.updateCustomSkin();
        }
        super.func_184206_a(par);
    }

    public Inventory func_213715_ed() {
        return this.inventory;
    }

    public void moveTowards(BlockPos pos, float speed, int closeEnoughDist) {
        this.field_213378_br.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(pos, speed, closeEnoughDist));
        this.lookAt(pos);
    }

    public void moveTowards(BlockPos pos, float speed) {
        this.moveTowards(pos, speed, 1);
    }

    public void moveTowards(BlockPos pos) {
        this.moveTowards(pos, 0.5f);
    }

    public void lookAt(BlockPos pos) {
        this.field_213378_br.func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(pos));
    }

    public void func_70103_a(byte id) {
        switch (id) {
            case 15: {
                this.field_70170_p.func_217404_b((IParticleData)ParticleTypesMCA.NEG_INTERACTION.get(), true, this.func_226277_ct_(), this.func_226280_cw_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                break;
            }
            case 16: {
                this.field_70170_p.func_217404_b((IParticleData)ParticleTypesMCA.POS_INTERACTION.get(), true, this.func_226277_ct_(), this.func_226280_cw_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                break;
            }
            case 17: {
                this.func_213718_a((IParticleData)ParticleTypes.field_197615_h);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void onInvChange(IInventory inventoryFromListener) {
    }

    public void setInventory(UpdatableInventory inventory) {
        CompoundNBT nbt = new CompoundNBT();
        InventoryUtils.saveToNBT(inventory, nbt);
        InventoryUtils.readFromNBT(this.inventory, nbt);
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> type, boolean keepInventory) {
        VillagerLike zombie;
        this.residency.leaveHome();
        MobEntity mob = !this.field_70128_L && type == EntityType.field_200727_aF ? super.func_233656_b_(this.getGenetics().getGender().getZombieType(), keepInventory) : super.func_233656_b_(type, keepInventory);
        if (mob instanceof VillagerLike) {
            zombie = (VillagerLike)mob;
            zombie.copyVillagerAttributesFrom(this);
        }
        if (mob instanceof ZombieVillagerEntity) {
            zombie = (ZombieVillagerEntity)mob;
            zombie.func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(zombie.func_233580_cy_()), SpawnReason.CONVERSION, (ILivingEntityData)new ZombieEntity.GroupData(false, true), null);
            zombie.func_213792_a(this.func_213700_eh());
            zombie.func_223727_a((INBT)this.func_223722_es().func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
            zombie.func_213790_g(this.func_213706_dY().func_222199_a());
            zombie.func_213789_a(this.func_213708_dV());
            zombie.func_184221_a(this.func_110124_au());
            zombie.func_110163_bv();
            this.field_70170_p.func_217378_a(null, 1026, this.func_233580_cy_(), 0);
        }
        if (mob instanceof ZombieVillagerEntityMCA) {
            zombie = (ZombieVillagerEntityMCA)mob;
            ((ZombieVillagerEntityMCA)zombie).setInventory(this.inventory);
        }
        return (T)mob;
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.getTypeDataManager().load(this, nbt);
        this.relations.readFromNbt(nbt);
        this.longTermMemory.readFromNbt(nbt);
        this.playerModel = VillagerLike.PlayerModel.VALUES[nbt.func_74762_e("playerModel")];
        this.updateSpeed();
        this.inventory.func_174888_l();
        InventoryUtils.readFromNBT(this.inventory, nbt);
        if (nbt.func_74764_b("DespawnDelay")) {
            this.despawnDelay = nbt.func_74762_e("DespawnDelay");
        }
        if (nbt.func_74764_b("clothes")) {
            this.validateClothes();
        }
    }

    public final void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.getTypeDataManager().save(this, nbt);
        this.relations.writeToNbt(nbt);
        this.longTermMemory.writeToNbt(nbt);
        nbt.func_74768_a("DespawnDelay", this.despawnDelay);
        InventoryUtils.saveToNBT(this.inventory, nbt);
    }

    @Override
    public boolean isHostile() {
        return this.getProfession() == ProfessionsMCA.OUTLAW.get();
    }

    public boolean isFriend(EntityType<?> type) {
        return type == EntityType.field_200757_aw || type == EntitiesMCA.FEMALE_VILLAGER.get() || type == EntitiesMCA.MALE_VILLAGER.get();
    }

    public boolean func_230280_a_(ShootableItem weapon) {
        return true;
    }

    public void func_234281_b_(LivingEntity arg, float f) {
        Hand lv = ProjectileHelper.func_221274_a((LivingEntity)arg, (Item)Items.field_222114_py);
        ItemStack lv2 = arg.func_184586_b(lv);
        if (arg.func_233631_a_(Items.field_222114_py)) {
            CrossbowItem.func_220014_a((World)arg.field_70170_p, (LivingEntity)arg, (Hand)lv, (ItemStack)lv2, (float)f, (float)4.0f);
        }
        this.func_230283_U__();
    }

    public void func_213671_a(boolean charging) {
    }

    public void func_230284_a_(LivingEntity target, ItemStack crossbow, ProjectileEntity projectile, float multiShotSpray) {
        this.func_234279_a_((LivingEntity)this, target, projectile, multiShotSpray, 1.6f);
    }

    public void func_230283_U__() {
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightning) {
        this.getTraits().addTrait(Traits.Trait.ELECTRIFIED);
    }

    public void func_82196_d(LivingEntity target, float pullProgress) {
        this.func_70624_b(target);
        this.attackedEntity((Entity)target);
        if (this.func_233631_a_(Items.field_222114_py)) {
            this.func_234281_b_((LivingEntity)this, 1.75f);
        } else if (this.func_233631_a_(Items.field_151031_f)) {
            ItemStack itemStack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)Items.field_151031_f)));
            AbstractArrowEntity persistentProjectileEntity = this.createArrowProjectile(itemStack, pullProgress);
            double x = target.func_226277_ct_() - this.func_226277_ct_();
            double y = target.func_226283_e_(0.3333333333333333) - persistentProjectileEntity.func_226278_cu_();
            double z = target.func_226281_cx_() - this.func_226281_cx_();
            double vel = Math.sqrt(x * x + z * z);
            persistentProjectileEntity.func_70186_c(x, y + vel * (double)0.2f, z, 1.6f, 3.0f);
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_217376_c((Entity)persistentProjectileEntity);
        }
    }

    protected AbstractArrowEntity createArrowProjectile(ItemStack arrow, float damageModifier) {
        return ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)arrow, (float)damageModifier);
    }

    public ItemStack func_213356_f(ItemStack stack) {
        if (stack.func_77973_b() instanceof ShootableItem) {
            Predicate predicate = ((ShootableItem)stack.func_77973_b()).func_220006_d();
            ItemStack itemStack = ShootableItem.func_220005_a((LivingEntity)this, (Predicate)predicate);
            return itemStack.func_190926_b() ? new ItemStack((IItemProvider)Items.field_151032_g) : itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static AttributeModifierMap.MutableAttribute createVillagerAttributes() {
        return VillagerEntity.func_234551_eU_().func_233815_a_(Attributes.field_233818_a_, (double)Config.getInstance().villagerMaxHealth);
    }

    private void tickDespawnDelay() {
        if (this.despawnDelay > 0 && !this.func_213716_dX() && --this.despawnDelay == 0) {
            if (this.getVillagerBrain().getMemories().values().stream().anyMatch(m -> this.field_70146_Z.nextInt(100) < m.getHearts())) {
                this.setProfession(VillagerProfession.field_221151_a);
                this.setDespawnDelay(0);
            } else {
                this.func_70106_y();
            }
        }
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public boolean requiresHome() {
        return this.getProfession() != ProfessionsMCA.ADVENTURER.get();
    }

    public void makeMercenary(ServerPlayerEntity player) {
        this.setProfession((VillagerProfession)ProfessionsMCA.MERCENARY.get());
        this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151040_l));
        this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151036_c));
        this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151035_b));
        this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151019_K));
        this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151112_aM));
        this.inventory.func_174894_a(new ItemStack((IItemProvider)Items.field_151025_P, 16));
    }
}

