/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity;

import forge.net.mca.MCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.Names;
import forge.net.mca.util.WorldUtils;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.MerchantOffers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class VillagerFactory {
    private final World world;
    private Optional<String> name = Optional.empty();
    private Optional<Gender> gender = Optional.empty();
    private Optional<VillagerProfession> profession = Optional.empty();
    private Optional<VillagerType> type = Optional.empty();
    private OptionalInt level = OptionalInt.empty();
    private Optional<MerchantOffers> offers = Optional.empty();
    private OptionalInt age = OptionalInt.empty();
    private Optional<Vector3d> position = Optional.empty();

    private VillagerFactory(World world) {
        this.world = world;
    }

    public static VillagerFactory newVillager(World world) {
        return new VillagerFactory(world);
    }

    public VillagerFactory withGender(Gender gender) {
        this.gender = Optional.ofNullable(gender);
        return this;
    }

    public VillagerFactory withType(VillagerType type) {
        this.type = Optional.ofNullable(type);
        return this;
    }

    public VillagerFactory withProfession(VillagerProfession prof) {
        this.profession = Optional.ofNullable(prof);
        return this;
    }

    public VillagerFactory withProfession(VillagerProfession prof, int level) {
        this.withProfession(prof);
        this.level = OptionalInt.of(level);
        return this;
    }

    public VillagerFactory withProfession(VillagerProfession prof, int level, MerchantOffers offers) {
        this.withProfession(prof, level);
        this.offers = Optional.of(offers);
        return this;
    }

    public VillagerFactory withName(String name) {
        this.name = Optional.ofNullable(name);
        return this;
    }

    public VillagerFactory withPosition(double x, double y, double z) {
        return this.withPosition(new Vector3d(x, y, z));
    }

    public VillagerFactory withPosition(Entity entity) {
        return this.withPosition(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public VillagerFactory withPosition(Vector3d pos) {
        this.position = Optional.of(pos);
        return this;
    }

    public VillagerFactory withPosition(BlockPos pos) {
        return this.withPosition(Vector3d.func_237492_c_((Vector3i)pos.func_177984_a()));
    }

    public VillagerFactory withAge(int age) {
        this.age = OptionalInt.of(age);
        return this;
    }

    public VillagerFactory spawn(SpawnReason reason) {
        if (!this.position.isPresent()) {
            MCA.LOGGER.info("Attempted to spawn villager without a position being set!");
        }
        WorldUtils.spawnEntity(this.world, (MobEntity)this.build(), reason);
        return this;
    }

    public VillagerEntityMCA build() {
        Gender gender = this.gender.orElseGet(Gender::getRandom);
        VillagerEntityMCA villager = (VillagerEntityMCA)gender.getVillagerType().func_200721_a(this.world);
        assert (villager != null);
        villager.getGenetics().setGender(gender);
        villager.func_70873_a(this.age.orElseGet(() -> villager.func_70681_au().nextInt(AgeState.getMaxAge() * 3) - AgeState.getMaxAge()));
        this.position.ifPresent(pos -> villager.func_242281_f(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c()));
        villager.setName(this.name.orElseGet(() -> Names.pickCitizenName(gender, (Entity)villager)));
        VillagerData data = villager.func_213700_eh();
        villager.func_213753_a(new VillagerData(this.type.orElseGet(() -> ((VillagerData)data).func_221129_a()), this.profession.orElse(VillagerProfession.field_221151_a), this.level.orElseGet(() -> ((VillagerData)data).func_221132_c())));
        this.offers.ifPresent(arg_0 -> ((VillagerEntityMCA)villager).func_213768_b(arg_0));
        return villager;
    }
}

