/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.Infectable;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.DialogueType;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Messenger;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.brain.VillagerBrain;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.EntityRelationship;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.VillagerDimensions;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.entity.interaction.EntityCommandHandler;
import forge.net.mca.resources.ClothingList;
import forge.net.mca.resources.HairList;
import forge.net.mca.resources.Names;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.util.compat.SheepEntityCompat;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CEnumParameter;
import forge.net.mca.util.network.datasync.CParameter;
import forge.net.mca.util.network.datasync.CTrackedEntity;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public interface VillagerLike<E extends Entity>
extends CTrackedEntity<E>,
IVillagerDataHolder,
Infectable,
Messenger {
    public static final CDataParameter<String> VILLAGER_NAME;
    public static final CDataParameter<String> CUSTOM_SKIN;
    public static final CDataParameter<String> CLOTHES;
    public static final CDataParameter<String> HAIR;
    public static final CDataParameter<Float> HAIR_COLOR_RED;
    public static final CDataParameter<Float> HAIR_COLOR_GREEN;
    public static final CDataParameter<Float> HAIR_COLOR_BLUE;
    public static final CEnumParameter<AgeState> AGE_STATE;
    public static final UUID SPEED_ID;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(Class<E> type) {
        return new CDataManager.Builder<E>(type).addAll(VILLAGER_NAME, CUSTOM_SKIN, CLOTHES, HAIR, HAIR_COLOR_RED, HAIR_COLOR_GREEN, HAIR_COLOR_BLUE, AGE_STATE).add(Genetics::createTrackedData).add(Traits::createTrackedData).add(VillagerBrain::createTrackedData);
    }

    public Genetics getGenetics();

    public Traits getTraits();

    public VillagerBrain<?> getVillagerBrain();

    public EntityCommandHandler<?> getInteractions();

    default public void initialize(SpawnReason spawnReason) {
        if (spawnReason != SpawnReason.CONVERSION) {
            if (spawnReason != SpawnReason.BREEDING) {
                this.getGenetics().randomize();
                this.getTraits().randomize();
            }
            if (this.getGenetics().getGender() == Gender.UNASSIGNED) {
                this.getGenetics().setGender(Gender.getRandom());
            }
            if (Strings.isNullOrEmpty((String)((String)this.getTrackedValue(VILLAGER_NAME)))) {
                this.setName(Names.pickCitizenName(this.getGenetics().getGender(), (Entity)this.asEntity()));
            }
            this.initializeSkin(false);
            this.getVillagerBrain().randomize();
        }
        this.asEntity().func_213323_x_();
    }

    @Override
    default public boolean isSpeechImpaired() {
        return this.getInfectionProgress() > 0.6f;
    }

    @Override
    default public boolean isToYoungToSpeak() {
        return this.getAgeState() == AgeState.BABY;
    }

    default public void setName(String name) {
        this.setTrackedValue(VILLAGER_NAME, name);
        if (!this.asEntity().field_70170_p.field_72995_K) {
            EntityRelationship.of((Entity)this.asEntity()).ifPresent(relationship -> relationship.getFamilyEntry().setName(name));
        }
    }

    default public void setCustomSkin(String name) {
        this.setTrackedValue(CUSTOM_SKIN, name);
    }

    default public void updateCustomSkin() {
    }

    default public GameProfile getGameProfile() {
        return null;
    }

    default public boolean hasCustomSkin() {
        if (!MCA.isBlankString((String)this.getTrackedValue(CUSTOM_SKIN)) && this.getGameProfile() != null) {
            Minecraft minecraftClient = Minecraft.func_71410_x();
            Map map = minecraftClient.func_152342_ad().func_152788_a(this.getGameProfile());
            return map.containsKey(MinecraftProfileTexture.Type.SKIN);
        }
        return false;
    }

    default public boolean canBeAttractedTo(VillagerLike<?> other) {
        if (this.getTraits().eitherHaveTrait(Traits.Trait.HOMOSEXUAL, other)) {
            return this.getTraits().hasSameTrait(Traits.Trait.HOMOSEXUAL, other) && this.getGenetics().getGender() == other.getGenetics().getGender();
        }
        return this.getTraits().hasSameTrait(Traits.Trait.BISEXUAL, other) || this.getGenetics().getGender().isMutuallyAttracted(other.getGenetics().getGender());
    }

    default public boolean canBeAttractedTo(PlayerSaveData other) {
        return this.canBeAttractedTo(VillagerLike.toVillager(other));
    }

    default public Hand getDominantHand() {
        return this.getTraits().hasTrait(Traits.Trait.LEFT_HANDED) ? Hand.OFF_HAND : Hand.MAIN_HAND;
    }

    default public Hand getOpposingHand() {
        return this.getDominantHand() == Hand.OFF_HAND ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    default public EquipmentSlotType getSlotForHand(Hand hand) {
        return hand == Hand.OFF_HAND ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND;
    }

    default public EquipmentSlotType getDominantSlot() {
        return this.getSlotForHand(this.getDominantHand());
    }

    default public EquipmentSlotType getOpposingSlot() {
        return this.getSlotForHand(this.getOpposingHand());
    }

    default public ResourceLocation getProfessionId() {
        return MCA.locate("none");
    }

    default public String getProfessionName() {
        String professionName = (this.getProfessionId().func_110624_b().equalsIgnoreCase("minecraft") ? (this.getProfessionId().func_110623_a().equals("none") ? "mca.none" : this.getProfessionId().func_110623_a()) : this.getProfessionId().toString()).replace(":", ".");
        return MCA.isBlankString(professionName) ? "mca.none" : professionName;
    }

    default public IFormattableTextComponent getProfessionText() {
        return new TranslationTextComponent("entity.minecraft.villager." + this.getProfessionName());
    }

    default public boolean isProfessionImportant() {
        return false;
    }

    default public boolean doesProfessionRequireHome() {
        return false;
    }

    default public boolean canTradeWithProfession() {
        return false;
    }

    default public String getClothes() {
        return (String)this.getTrackedValue(CLOTHES);
    }

    default public void setClothes(ResourceLocation clothes) {
        this.setClothes(clothes.toString());
    }

    default public void setClothes(String clothes) {
        this.setTrackedValue(CLOTHES, clothes);
    }

    default public String getHair() {
        return (String)this.getTrackedValue(HAIR);
    }

    default public void setHair(String hair) {
        this.setTrackedValue(HAIR, hair);
    }

    default public void setHairDye(DyeColor color) {
        float[] components = (float[])color.func_193349_f().clone();
        float[] dye = this.getHairDye();
        if (dye[0] > 0.0f) {
            components[0] = components[0] * 0.5f + dye[0] * 0.5f;
            components[1] = components[1] * 0.5f + dye[1] * 0.5f;
            components[2] = components[2] * 0.5f + dye[2] * 0.5f;
        }
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(components[0]));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(components[1]));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(components[2]));
    }

    default public void clearHairDye() {
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(0.0f));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(0.0f));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(0.0f));
    }

    default public float[] getHairDye() {
        return new float[]{((Float)this.getTrackedValue(HAIR_COLOR_RED)).floatValue(), ((Float)this.getTrackedValue(HAIR_COLOR_GREEN)).floatValue(), ((Float)this.getTrackedValue(HAIR_COLOR_BLUE)).floatValue()};
    }

    default public AgeState getAgeState() {
        return (AgeState)this.getTrackedValue(AGE_STATE);
    }

    default public VillagerDimensions getVillagerDimensions() {
        return this.getAgeState();
    }

    default public void updateSpeed() {
        float speed = this.getVillagerBrain().getPersonality().getSpeedModifier();
        speed /= 0.9f + this.getGenetics().getGene(Genetics.WIDTH) * 0.2f;
        speed *= 0.9f + this.getGenetics().getGene(Genetics.SIZE) * 0.2f;
        speed *= this.getAgeState().getSpeed();
        ModifiableAttributeInstance entityAttributeInstance = this.asEntity().func_110148_a(Attributes.field_233821_d_);
        if (entityAttributeInstance != null) {
            if (entityAttributeInstance.func_111127_a(SPEED_ID) != null) {
                entityAttributeInstance.func_188479_b(SPEED_ID);
            }
            AttributeModifier speedModifier = new AttributeModifier(SPEED_ID, "Speed", (double)(speed - 1.0f), AttributeModifier.Operation.MULTIPLY_BASE);
            entityAttributeInstance.func_233767_b_(speedModifier);
        }
    }

    default public boolean setAgeState(AgeState state) {
        AgeState old = this.getAgeState();
        if (state == old) {
            return false;
        }
        this.setTrackedValue(AGE_STATE, state);
        this.asEntity().func_213323_x_();
        this.updateSpeed();
        return old != AgeState.UNASSIGNED;
    }

    default public float getHorizontalScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().func_70631_g_() ? 0.5f : 1.0f;
        }
        return Math.min(0.999f, this.getGenetics().getHorizontalScaleFactor() * this.getTraits().getHorizontalScaleFactor() * this.getVillagerDimensions().getWidth() * this.getGenetics().getGender().getHorizontalScaleFactor());
    }

    default public float getRawScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().func_70631_g_() ? 0.5f : 1.0f;
        }
        return this.getGenetics().getVerticalScaleFactor() * this.getTraits().getVerticalScaleFactor() * this.getVillagerDimensions().getHeight() * this.getGenetics().getGender().getScaleFactor();
    }

    @Override
    default public DialogueType getDialogueType(PlayerEntity receiver) {
        if (!receiver.field_70170_p.field_72995_K) {
            Optional<EntityRelationship> r;
            DialogueType type = DialogueType.fromAge(this.getAgeState());
            if (!receiver.field_70170_p.field_72995_K && (r = EntityRelationship.of((Entity)this.asEntity())).isPresent()) {
                FamilyTreeNode relationship = r.get().getFamilyEntry();
                if (r.get().isMarriedTo(receiver.func_110124_au())) {
                    return DialogueType.SPOUSE;
                }
                if (r.get().isEngagedWith(receiver.func_110124_au())) {
                    return DialogueType.ENGAGED;
                }
                if (relationship.isParent(receiver.func_110124_au())) {
                    return type.toChild();
                }
            }
            this.getVillagerBrain().getMemoriesForPlayer(receiver).setDialogueType(type);
        }
        return this.getVillagerBrain().getMemoriesForPlayer(receiver).getDialogueType();
    }

    default public void initializeSkin(boolean isPlayer) {
        MobEntity entity;
        this.randomizeClothes();
        this.randomizeHair();
        if (!isPlayer && (entity = this.asEntity()).func_70681_au().nextFloat() < Config.getInstance().coloredHairChance) {
            int n = entity.func_70681_au().nextInt(25);
            int o = DyeColor.values().length;
            int p = n % o;
            int q = (n + 1) % o;
            float r = entity.func_70681_au().nextFloat();
            float[] fs = SheepEntityCompat.getRgbColor(DyeColor.func_196056_a((int)p));
            float[] gs = SheepEntityCompat.getRgbColor(DyeColor.func_196056_a((int)q));
            this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(fs[0] * (1.0f - r) + gs[0] * r));
            this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(fs[1] * (1.0f - r) + gs[1] * r));
            this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(fs[2] * (1.0f - r) + gs[2] * r));
        }
    }

    default public void randomizeClothes() {
        this.setClothes(ClothingList.getInstance().getPool(this).pickOne());
    }

    default public void randomizeHair() {
        this.setHair(HairList.getInstance().getPool(this.getGenetics().getGender()).pickOne());
    }

    default public void validateClothes() {
        if (!this.asEntity().field_70170_p.func_201670_d()) {
            if (!ClothingList.getInstance().clothing.containsKey(this.getClothes())) {
                if (this.getClothes() != null) {
                    ResourceLocation identifier = new ResourceLocation(this.getClothes());
                    String id = identifier.func_110624_b() + ":skins/clothing/normal/" + identifier.func_110623_a();
                    if (ClothingList.getInstance().clothing.containsKey(id)) {
                        this.setClothes(id);
                    } else {
                        MCA.LOGGER.info(String.format("Villagers clothing %s does not exist!", this.getClothes()));
                        this.randomizeClothes();
                    }
                } else {
                    MCA.LOGGER.info(String.format("Villagers clothing %s does not exist!", this.getClothes()));
                    this.randomizeClothes();
                }
            }
            if (!HairList.getInstance().hair.containsKey(this.getHair())) {
                MCA.LOGGER.info(String.format("Villagers hair %s does not exist!", this.getHair()));
                this.randomizeHair();
            }
        }
    }

    default public CompoundNBT toNbtForConversion(EntityType<?> convertingTo) {
        CompoundNBT output = new CompoundNBT();
        this.getTypeDataManager().save(this.asEntity(), output);
        return output;
    }

    default public void readNbtForConversion(EntityType<?> convertingFrom, CompoundNBT input) {
        this.getTypeDataManager().load(this.asEntity(), input);
    }

    default public void copyVillagerAttributesFrom(VillagerLike<?> other) {
        this.readNbtForConversion(other.asEntity().func_200600_R(), other.toNbtForConversion(this.asEntity().func_200600_R()));
    }

    public static VillagerLike<?> toVillager(PlayerSaveData player) {
        CompoundNBT villagerData = player.getEntityData();
        VillagerEntityMCA villager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).func_200721_a((World)player.getWorld());
        if (!1.$assertionsDisabled && villager == null) {
            throw new AssertionError();
        }
        villager.func_70037_a(villagerData);
        return villager;
    }

    public static VillagerLike<?> toVillager(Entity entity) {
        if (entity instanceof VillagerLike) {
            return (VillagerLike)entity;
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)entity;
            return VillagerLike.toVillager(PlayerSaveData.get(playerEntity));
        }
        return null;
    }

    default public boolean isHostile() {
        return false;
    }

    default public PlayerModel getPlayerModel() {
        return PlayerModel.VILLAGER;
    }

    public boolean isBurned();

    default public void spawnBurntParticles() {
        Random random = this.asEntity().func_70681_au();
        if (random.nextInt(4) == 0) {
            double d = random.nextGaussian() * 0.02;
            double e = random.nextGaussian() * 0.02;
            double f = random.nextGaussian() * 0.02;
            this.asEntity().field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.asEntity().func_226282_d_(1.0), this.asEntity().func_226279_cv_() + 1.0, this.asEntity().func_226287_g_(1.0), d, e, f);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        VILLAGER_NAME = CParameter.create("villagerName", "");
        CUSTOM_SKIN = CParameter.create("custom_skin", "");
        CLOTHES = CParameter.create("clothes", "");
        HAIR = CParameter.create("hair", "");
        HAIR_COLOR_RED = CParameter.create("hair_color_red", 0.0f);
        HAIR_COLOR_GREEN = CParameter.create("hair_color_green", 0.0f);
        HAIR_COLOR_BLUE = CParameter.create("hair_color_blue", 0.0f);
        AGE_STATE = CParameter.create("ageState", AgeState.UNASSIGNED);
        SPEED_ID = UUID.fromString("1eaf83ff-7207-5596-c37a-d7a07b3ec4ce");
    }

    public static enum PlayerModel {
        VILLAGER,
        PLAYER,
        VANILLA;

        static final PlayerModel[] VALUES;

        static {
            VALUES = PlayerModel.values();
        }
    }
}

