/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.TagsMCA;
import forge.net.mca.entity.UpdatableInventory;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.brain.VillagerBrain;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.interaction.ZombieCommandHandler;
import forge.net.mca.util.InventoryUtils;
import forge.net.mca.util.network.datasync.CDataManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZombieVillagerEntityMCA
extends ZombieVillagerEntity
implements VillagerLike<ZombieVillagerEntityMCA>,
CompassionateEntity<Relationship<ZombieVillagerEntityMCA>> {
    private static final CDataManager<ZombieVillagerEntityMCA> DATA = VillagerEntityMCA.createTrackedData(ZombieVillagerEntityMCA.class).build();
    private final VillagerBrain<ZombieVillagerEntityMCA> mcaBrain = new VillagerBrain<ZombieVillagerEntityMCA>(this);
    private final Genetics genetics = new Genetics(this);
    private final Traits traits = new Traits(this);
    private final Relationship<ZombieVillagerEntityMCA> relations = new Relationship<ZombieVillagerEntityMCA>(this);
    private final ZombieCommandHandler interactions = new ZombieCommandHandler(this);
    private final UpdatableInventory inventory = new UpdatableInventory(27);
    private int burned;

    public ZombieVillagerEntityMCA(EntityType<? extends ZombieVillagerEntity> type, World world, Gender gender) {
        super(type, world);
        this.genetics.setGender(gender);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.getTypeDataManager().register(this);
    }

    @Override
    public CDataManager<ZombieVillagerEntityMCA> getTypeDataManager() {
        return DATA;
    }

    @Override
    public Genetics getGenetics() {
        return this.genetics;
    }

    @Override
    public Traits getTraits() {
        return this.traits;
    }

    @Override
    public VillagerBrain<?> getVillagerBrain() {
        return this.mcaBrain;
    }

    public ZombieCommandHandler getInteractions() {
        return this.interactions;
    }

    @Override
    public boolean isBurned() {
        return this.burned > 0;
    }

    @Override
    public Relationship<ZombieVillagerEntityMCA> getRelationships() {
        return this.relations;
    }

    @Override
    public float getInfectionProgress() {
        return 1.0f;
    }

    @Override
    public void setInfectionProgress(float progress) {
    }

    @Nullable
    public final ITextComponent func_200201_e() {
        String value = (String)this.getTrackedValue(VILLAGER_NAME);
        return MCA.isBlankString(value) ? null : new StringTextComponent(value).func_240699_a_(TextFormatting.RED);
    }

    public double func_70033_W() {
        return -0.35;
    }

    public double func_70042_X() {
        return super.func_70042_X();
    }

    public EntitySize func_213305_a(Pose pose) {
        if (pose == Pose.SLEEPING) {
            return field_213377_as;
        }
        float height = this.func_213355_cm() * 2.0f;
        float width = this.getHorizontalScaleFactor() * 0.6f;
        return EntitySize.func_220314_b((float)width, (float)height);
    }

    public float func_213355_cm() {
        return Math.min(0.999f, this.getRawScaleFactor());
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return this.func_213355_cm() * 1.75f;
    }

    public final ActionResultType func_184199_a(PlayerEntity player, Vector3d pos, @NotNull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand.equals((Object)Hand.MAIN_HAND) && !stack.func_77973_b().func_206844_a(TagsMCA.Items.ZOMBIE_EGGS) && stack.func_77973_b() != Items.field_151153_ao && player instanceof ServerPlayerEntity) {
            String t = new String(new char[this.func_70681_au().nextInt(8) + 2]).replace("\u0000", ". ");
            this.sendChatMessage((IFormattableTextComponent)new StringTextComponent(t), (Entity)player);
        }
        return super.func_184199_a(player, pos, hand);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT entityNbt) {
        ILivingEntityData data = super.func_213386_a(world, difficulty, spawnReason, entityData, entityNbt);
        if (this.getAgeState() == AgeState.UNASSIGNED) {
            if (this.field_70146_Z.nextFloat() < Config.getInstance().babyZombieChance) {
                this.setAgeState(this.func_70631_g_() ? AgeState.BABY : AgeState.random());
            } else {
                this.setAgeState(AgeState.ADULT);
            }
        }
        if (this.getAgeState() == AgeState.BABY) {
            this.setAgeState(AgeState.TODDLER);
        }
        this.initialize(spawnReason);
        return data;
    }

    public void func_70636_d() {
        super.func_70636_d();
        --this.burned;
        if (this.func_70027_ad()) {
            this.burned = Config.getInstance().burnedClothingTickLength;
        }
        if (this.burned > 0) {
            this.spawnBurntParticles();
        }
    }

    public void func_82227_f(boolean isBaby) {
        super.func_82227_f(isBaby);
        this.setAgeState(isBaby ? AgeState.BABY : AgeState.ADULT);
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (name != null) {
            this.setName(name.getString());
        }
    }

    @Override
    public boolean isHostile() {
        return true;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        InventoryUtils.dropAllItems((Entity)this, (IInventory)this.inventory);
        this.relations.onDeath(cause);
    }

    public void setInventory(UpdatableInventory inventory) {
        CompoundNBT nbt = new CompoundNBT();
        InventoryUtils.saveToNBT(inventory, nbt);
        InventoryUtils.readFromNBT(this.inventory, nbt);
    }

    @Nullable
    public <T extends MobEntity> T func_233656_b_(EntityType<T> type, boolean keepInventory) {
        VillagerLike villager;
        MobEntity mob = !this.field_70128_L && type == EntityType.field_200756_av ? super.func_233656_b_(this.getGenetics().getGender().getVillagerType(), keepInventory) : super.func_233656_b_(type, keepInventory);
        if (mob instanceof VillagerLike) {
            villager = (VillagerLike)mob;
            villager.copyVillagerAttributesFrom(this);
            villager.setInfected(false);
        }
        if (mob instanceof VillagerEntityMCA) {
            villager = (VillagerEntityMCA)mob;
            villager.func_184221_a(this.func_110124_au());
            ((VillagerEntityMCA)villager).setInventory(this.inventory);
            ((VillagerEntityMCA)villager).func_70873_a(this.getAgeState().toAge());
        }
        return (T)mob;
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.getTypeDataManager().load(this, nbt);
        this.relations.readFromNbt(nbt);
        this.updateSpeed();
        this.inventory.func_174888_l();
        InventoryUtils.readFromNBT(this.inventory, nbt);
        this.validateClothes();
    }

    public final void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.getTypeDataManager().save(this, nbt);
        this.relations.writeToNbt(nbt);
        InventoryUtils.saveToNBT(this.inventory, nbt);
    }

    public void func_184206_a(DataParameter<?> par) {
        if (this.getTypeDataManager().isParam(AGE_STATE, par) || this.getTypeDataManager().isParam(Genetics.SIZE.getParam(), par)) {
            this.func_213323_x_();
        }
        super.func_184206_a(par);
    }

    protected boolean func_225511_J_() {
        return !this.func_104002_bU();
    }
}

