/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity;

import forge.net.mca.MCA;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.Names;
import forge.net.mca.util.WorldUtils;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ZombieVillagerFactory {
    private final World world;
    private Optional<String> name = Optional.empty();
    private Optional<Gender> gender = Optional.empty();
    private Optional<VillagerProfession> profession = Optional.empty();
    private Optional<VillagerType> type = Optional.empty();
    private OptionalInt level = OptionalInt.empty();
    private Optional<Vector3d> position = Optional.empty();

    private ZombieVillagerFactory(World world) {
        this.world = world;
    }

    public static ZombieVillagerFactory newVillager(World world) {
        return new ZombieVillagerFactory(world);
    }

    public ZombieVillagerFactory withGender(Gender gender) {
        this.gender = Optional.ofNullable(gender);
        return this;
    }

    public ZombieVillagerFactory withType(VillagerType type) {
        this.type = Optional.ofNullable(type);
        return this;
    }

    public ZombieVillagerFactory withProfession(VillagerProfession prof) {
        this.profession = Optional.ofNullable(prof);
        return this;
    }

    public ZombieVillagerFactory withProfession(VillagerProfession prof, int level) {
        this.withProfession(prof);
        this.level = OptionalInt.of(level);
        return this;
    }

    public ZombieVillagerFactory withName(String name) {
        this.name = Optional.ofNullable(name);
        return this;
    }

    public ZombieVillagerFactory withPosition(double x, double y, double z) {
        return this.withPosition(new Vector3d(x, y, z));
    }

    public ZombieVillagerFactory withPosition(Entity entity) {
        return this.withPosition(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    public ZombieVillagerFactory withPosition(Vector3d pos) {
        this.position = Optional.of(pos);
        return this;
    }

    public ZombieVillagerFactory withPosition(BlockPos pos) {
        return this.withPosition(Vector3d.func_237492_c_((Vector3i)pos.func_177984_a()));
    }

    public ZombieVillagerEntityMCA spawn(SpawnReason reason) {
        if (!this.position.isPresent()) {
            MCA.LOGGER.info("Attempted to spawn villager without a position being set!");
        }
        ZombieVillagerEntityMCA build = this.build();
        WorldUtils.spawnEntity(this.world, (MobEntity)build, reason);
        return build;
    }

    public ZombieVillagerEntityMCA build() {
        Gender gender = this.gender.orElseGet(Gender::getRandom);
        ZombieVillagerEntityMCA zombie = (ZombieVillagerEntityMCA)gender.getZombieType().func_200721_a(this.world);
        zombie.getGenetics().setGender(gender);
        zombie.setName(this.name.orElseGet(() -> Names.pickCitizenName(gender, (Entity)zombie)));
        this.position.ifPresent(pos -> zombie.func_242281_f(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c()));
        VillagerData data = zombie.func_213700_eh();
        zombie.func_213792_a(new VillagerData(this.type.orElseGet(() -> ((VillagerData)data).func_221129_a()), this.profession.orElse(VillagerProfession.field_221151_a), this.level.orElseGet(() -> ((VillagerData)data).func_221132_c())));
        return zombie;
    }
}

