/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Pregnancy;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.interaction.gifts.GiftType;
import forge.net.mca.entity.interaction.gifts.Response;
import forge.net.mca.item.SpecialCaseGift;
import forge.net.mca.network.s2c.AnalysisResults;
import forge.net.mca.resources.data.analysis.IntAnalysis;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Food;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TieredItem;
import net.minecraft.util.math.MathHelper;

public class BreedableRelationship
extends Relationship<VillagerEntityMCA> {
    private static final CDataParameter<Boolean> IS_PROCREATING = CParameter.create("isProcreating", false);
    private int procreateTick = -1;
    private final Pregnancy pregnancy;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return Relationship.createTrackedData(builder).addAll(IS_PROCREATING).add(Pregnancy::createTrackedData);
    }

    public BreedableRelationship(VillagerEntityMCA entity) {
        super(entity);
        this.pregnancy = new Pregnancy(entity);
    }

    public Pregnancy getPregnancy() {
        return this.pregnancy;
    }

    public boolean isProcreating() {
        return (Boolean)((VillagerEntityMCA)this.entity).getTrackedValue(IS_PROCREATING);
    }

    public void startProcreating() {
        this.procreateTick = 60;
        ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, true);
    }

    public void tick(int age) {
        if (age % 20 == 0) {
            this.pregnancy.tick();
        }
        if (!this.isProcreating()) {
            return;
        }
        if (this.procreateTick > 0) {
            --this.procreateTick;
            ((VillagerEntityMCA)this.entity).func_70661_as().func_75499_g();
            ((VillagerEntityMCA)this.entity).field_70170_p.func_72960_a((Entity)this.entity, (byte)12);
        } else {
            this.getFamilyTree().getOrCreate((Entity)this.entity);
            this.getPartner().ifPresent(spouse -> {
                this.pregnancy.procreate((Entity)spouse);
                ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, false);
            });
        }
    }

    public void giveGift(ServerPlayerEntity player, Memories memory) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && !this.handleSpecialCaseGift(player, stack)) {
            if (stack.func_77973_b() == Items.field_151153_ao) {
                ((VillagerEntityMCA)this.entity).setInfected(false);
                ((VillagerEntityMCA)this.entity).func_213357_a(((VillagerEntityMCA)this.entity).field_70170_p, stack);
                stack.func_190918_g(1);
            } else if (stack.func_77973_b() instanceof DyeItem) {
                DyeItem dye = (DyeItem)stack.func_77973_b();
                ((VillagerEntityMCA)this.entity).setHairDye(dye.func_195962_g());
                stack.func_190918_g(1);
            } else if (stack.func_77973_b() == Items.field_221648_al) {
                ((VillagerEntityMCA)this.entity).clearHairDye();
                stack.func_190918_g(1);
            } else if (stack.func_77973_b() == Items.field_151057_cb) {
                if (stack.func_82837_s()) {
                    ((VillagerEntityMCA)this.entity).setCustomSkin(stack.func_200301_q().func_150261_e());
                } else {
                    ((VillagerEntityMCA)this.entity).setCustomSkin("");
                }
                stack.func_190918_g(1);
            } else {
                Optional<GiftType> gift = GiftType.bestMatching((VillagerEntityMCA)this.entity, stack, player);
                if (gift.isPresent()) {
                    this.acceptGift(stack, gift.get(), player, memory);
                } else {
                    gift = this.handleDynamicGift(stack);
                    if (gift.isPresent()) {
                        this.acceptGift(stack, gift.get(), player, memory);
                    } else {
                        this.rejectGift((PlayerEntity)player, "gift.fail");
                    }
                }
            }
        }
    }

    private Optional<GiftType> handleDynamicGift(ItemStack stack) {
        Food component;
        if (stack.func_77973_b() instanceof SwordItem) {
            SwordItem sword = (SwordItem)stack.func_77973_b();
            float satisfaction = sword.func_200894_d();
            satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.func_77973_b(), (int)satisfaction, MCA.locate("swords")));
        }
        if (stack.func_77973_b() instanceof ShootableItem) {
            ShootableItem ranged = (ShootableItem)stack.func_77973_b();
            float satisfaction = ranged.func_230305_d_();
            satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.func_77973_b(), (int)satisfaction, MCA.locate("archery")));
        }
        if (stack.func_77973_b() instanceof TieredItem) {
            TieredItem tool = (TieredItem)stack.func_77973_b();
            float satisfaction = tool.func_200891_e().func_200928_b();
            satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
            return Optional.of(new GiftType(stack.func_77973_b(), (int)satisfaction, MCA.locate(stack.func_77973_b() instanceof AxeItem ? "swords" : (stack.func_77973_b() instanceof HoeItem ? "hoes" : (stack.func_77973_b() instanceof ShovelItem ? "shovels" : "pickaxes")))));
        }
        if (stack.func_77973_b() instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)stack.func_77973_b();
            int satisfaction = (int)(Math.pow(armor.func_200881_e(), 1.25) * 1.5 + (double)(armor.func_200880_d().func_200901_e() * 5.0f));
            return Optional.of(new GiftType(stack.func_77973_b(), satisfaction, MCA.locate("armor")));
        }
        if (stack.func_77973_b().func_219971_r() && (component = stack.func_77973_b().func_219967_s()) != null) {
            int satisfaction = (int)((float)component.func_221466_a() + component.func_221469_b() * 3.0f);
            return Optional.of(new GiftType(stack.func_77973_b(), satisfaction, MCA.locate("food")));
        }
        return Optional.empty();
    }

    private void acceptGift(ItemStack stack, GiftType gift, ServerPlayerEntity player, Memories memory) {
        if (!((VillagerEntityMCA)this.entity).func_213715_ed().func_233541_b_(stack)) {
            this.rejectGift((PlayerEntity)player, "villager.inventory.full");
            return;
        }
        IntAnalysis analysis = gift.getSatisfactionFor((VillagerEntityMCA)this.entity, stack, player);
        int satisfaction = analysis.getTotal();
        Response response = gift.getResponse(satisfaction);
        int occurrences = this.getGiftSaturation().get(stack);
        int penalty = (int)((double)((float)occurrences * Config.getInstance().giftDesaturationFactor) * Math.pow(Math.max((double)satisfaction, 0.0), Config.getInstance().giftDesaturationExponent));
        if (penalty != 0) {
            analysis.add("desaturation", -penalty);
        }
        int desaturatedSatisfaction = analysis.getTotal();
        Response desaturatedResponse = gift.getResponse(desaturatedSatisfaction);
        desaturatedSatisfaction = (int)((double)desaturatedSatisfaction * Config.getInstance().giftSatisfactionFactor);
        NetworkHandler.sendToPlayer(new AnalysisResults(analysis), player);
        if (response == Response.FAIL) {
            this.rejectGift((PlayerEntity)player, gift.getDialogueFor(response));
        } else if (desaturatedResponse == Response.FAIL) {
            this.rejectGift((PlayerEntity)player, "gift.saturated");
        } else {
            ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, gift.getDialogueFor(response), new Object[0]);
            if (response == Response.BEST) {
                ((VillagerEntityMCA)this.entity).playSurprisedSound();
            }
            this.getGiftSaturation().add(stack);
            ((VillagerEntityMCA)this.entity).field_70170_p.func_72960_a((Entity)this.entity, (byte)16);
            ((VillagerEntityMCA)this.entity).func_213715_ed().func_174894_a(stack.func_77979_a(1));
        }
        ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue((int)((float)desaturatedSatisfaction * Config.getInstance().giftMoodEffect + Config.getInstance().baseGiftMoodEffect * (float)MathHelper.func_219802_k((double)desaturatedSatisfaction)));
        CriterionMCA.HEARTS_CRITERION.trigger(player, memory.getHearts(), desaturatedSatisfaction, "gift");
        memory.modHearts(desaturatedSatisfaction);
    }

    private void rejectGift(PlayerEntity player, String dialogue) {
        ((VillagerEntityMCA)this.entity).field_70170_p.func_72960_a((Entity)this.entity, (byte)15);
        ((VillagerEntityMCA)this.entity).sendChatMessage(player, dialogue, new Object[0]);
    }

    private boolean handleSpecialCaseGift(ServerPlayerEntity player, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof SpecialCaseGift) {
            if (((SpecialCaseGift)item).handle(player, (VillagerEntityMCA)this.entity)) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (item == Items.field_222070_lD && !((VillagerEntityMCA)this.entity).func_70631_g_()) {
            if (this.pregnancy.tryStartGestation()) {
                player.field_70170_p.func_72960_a((Entity)this.entity, (byte)12);
                stack.func_190918_g(1);
                ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "gift.cake.success", new Object[0]);
            } else {
                ((VillagerEntityMCA)this.entity).sendChatMessage((PlayerEntity)player, "gift.cake.fail", new Object[0]);
            }
            return true;
        }
        if (item == Items.field_151153_ao && ((VillagerEntityMCA)this.entity).func_70631_g_()) {
            ((VillagerEntityMCA)this.entity).func_110195_a(6000);
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }
}

