/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CEnumParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class Genetics
implements Iterable<Gene> {
    private static final Set<GeneType> GENOMES = new HashSet<GeneType>();
    public static final GeneType SIZE = new GeneType("gene_size");
    public static final GeneType WIDTH = new GeneType("gene_width");
    public static final GeneType BREAST = new GeneType("gene_breast");
    public static final GeneType MELANIN = new GeneType("gene_melanin");
    public static final GeneType HEMOGLOBIN = new GeneType("gene_hemoglobin");
    public static final GeneType EUMELANIN = new GeneType("gene_eumelanin");
    public static final GeneType PHEOMELANIN = new GeneType("gene_pheomelanin");
    public static final GeneType SKIN = new GeneType("gene_skin");
    public static final GeneType FACE = new GeneType("gene_face");
    public static final GeneType VOICE = new GeneType("gene_voice");
    private static final CEnumParameter<Gender> GENDER = CParameter.create("gender", Gender.UNASSIGNED);
    private Random random;
    private final Map<GeneType, Gene> genes = new HashMap<GeneType, Gene>();
    private final VillagerLike<?> entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        GENOMES.forEach(g -> builder.addAll(g.getParam()));
        return builder.addAll(GENDER);
    }

    public Genetics(VillagerLike<?> entity) {
        this.entity = entity;
        this.random = new Random(entity.asEntity().field_70170_p.field_73012_v.nextLong());
    }

    public float getVerticalScaleFactor() {
        return 0.75f + this.getGene(SIZE) / 2.0f;
    }

    public float getHorizontalScaleFactor() {
        return 0.75f + this.getGene(WIDTH) / 2.0f;
    }

    public void setGender(Gender gender) {
        this.entity.setTrackedValue(GENDER, gender);
    }

    public Gender getGender() {
        return (Gender)((Object)this.entity.getTrackedValue(GENDER));
    }

    public float getBreastSize() {
        return this.getGender() == Gender.FEMALE ? this.getGene(BREAST) : 0.0f;
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genes.values().iterator();
    }

    public void setGene(GeneType type, float value) {
        this.getGenome(type).set(value);
    }

    public float getGene(GeneType type) {
        return this.getGenome(type).get();
    }

    public Gene getGenome(GeneType type) {
        return this.genes.computeIfAbsent(type, x$0 -> new Gene((GeneType)x$0));
    }

    public void randomize() {
        for (GeneType type : GENOMES) {
            this.getGenome(type).randomize();
        }
        this.setGene(SIZE, this.centeredRandom());
        this.setGene(WIDTH, this.centeredRandom());
        float temp = this.entity.asEntity().field_70170_p.func_226691_t_(this.entity.asEntity().func_233580_cy_()).func_242445_k();
        if (this.random.nextInt(100) < Config.getInstance().immigrantChance) {
            temp = this.random.nextFloat() * 2.0f - 0.5f;
        }
        this.setGene(MELANIN, this.temperatureBaseRandom(temp));
        this.setGene(HEMOGLOBIN, this.temperatureBaseRandom(temp));
        this.setGene(EUMELANIN, this.random.nextFloat());
        this.setGene(PHEOMELANIN, this.random.nextFloat());
    }

    private float centeredRandom() {
        return Math.min(1.0f, Math.max(0.0f, (this.random.nextFloat() - 0.5f) * (this.random.nextFloat() - 0.5f) + 0.5f));
    }

    private float temperatureBaseRandom(float temp) {
        return MathHelper.func_76131_a((float)((this.random.nextFloat() - 0.5f) * 0.5f + temp * 0.4f + 0.1f), (float)0.0f, (float)1.0f);
    }

    public void combine(Genetics mother, Genetics father) {
        for (GeneType type : GENOMES) {
            this.getGenome(type).mutate(mother, father);
        }
    }

    public void combine(Optional<Genetics> mother, Optional<Genetics> father) {
        if (mother.isPresent() != father.isPresent()) {
            Genetics single = mother.orElse(father.orElse(null));
            this.combine(single, single);
        } else {
            mother.ifPresent(genetics -> this.combine((Genetics)genetics, (Genetics)father.get()));
        }
    }

    public void combine(Optional<Genetics> mother, Optional<Genetics> father, long seed) {
        Random old = this.random;
        this.random = new Random(seed);
        this.combine(mother, father);
        this.random = old;
    }

    public static class GeneType
    implements Comparable<GeneType> {
        private final String key;
        private final CDataParameter<Float> parameter;

        GeneType(String key) {
            this.key = key;
            this.parameter = CParameter.create(key, 0.5f);
            GENOMES.add(this);
        }

        public String key() {
            return this.key;
        }

        public String getTranslationKey() {
            return this.key().replace("_", ".");
        }

        public CDataParameter<Float> getParam() {
            return this.parameter;
        }

        @Override
        public int compareTo(GeneType o) {
            return this.key().compareTo(o.key());
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof GeneType && ((GeneType)o).key().equals(this.key());
        }
    }

    public class Gene {
        private final GeneType type;

        public Gene(GeneType type) {
            this.type = type;
        }

        public GeneType getType() {
            return this.type;
        }

        public float get() {
            return ((Float)Genetics.this.entity.getTrackedValue(this.type.parameter)).floatValue();
        }

        public void set(float value) {
            Genetics.this.entity.setTrackedValue(this.type.parameter, Float.valueOf(value));
        }

        public void randomize() {
            this.set(Genetics.this.random.nextFloat());
        }

        public void mutate(Genetics mother, Genetics father) {
            float m = mother.getGene(this.type);
            float f = father.getGene(this.type);
            float interpolation = Genetics.this.random.nextFloat();
            float mutation = (Genetics.this.random.nextFloat() - 0.5f) * 0.2f;
            float g = m * interpolation + f * (1.0f - interpolation) + mutation;
            this.set((float)Math.min(1.0, Math.max(0.0, (double)g)));
        }
    }
}

