/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import com.google.gson.JsonObject;
import forge.net.mca.entity.VillagerEntityMCA;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class LongTermMemory {
    HashMap<String, Long> memories = new HashMap();
    private final VillagerEntityMCA entity;

    public LongTermMemory(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public void writeToNbt(CompoundNBT nbt) {
        CompoundNBT memory = new CompoundNBT();
        for (Map.Entry<String, Long> entry : this.memories.entrySet()) {
            memory.func_74772_a(entry.getKey(), entry.getValue().longValue());
        }
        nbt.func_218657_a("longTermMemory", (INBT)memory);
    }

    public void readFromNbt(CompoundNBT nbt) {
        CompoundNBT memory = nbt.func_74775_l("longTermMemory");
        this.memories.clear();
        for (String key : memory.func_150296_c()) {
            this.memories.put(key, memory.func_74763_f(key));
        }
    }

    public void remember(String id) {
        this.remember(id, Integer.MAX_VALUE);
    }

    public void remember(String id, long time) {
        long currentTime = this.entity.field_70170_p.func_82737_E();
        if (this.memories.containsKey(id)) {
            currentTime = Math.max(currentTime, this.memories.get(id));
        }
        this.memories.put(id, currentTime + time);
    }

    public long getMemory(String id) {
        if (this.memories.containsKey(id)) {
            if (this.entity.field_70170_p.func_82737_E() > this.memories.get(id)) {
                this.memories.remove(id);
            } else {
                return this.memories.get(id) - this.entity.field_70170_p.func_82737_E();
            }
        }
        return 0L;
    }

    public boolean hasMemory(String id) {
        return this.getMemory(id) > 0L;
    }

    public static String parseId(JsonObject json, ServerPlayerEntity player) {
        String id = json.get("id").getAsString();
        if (json.has("var")) {
            switch (json.get("var").getAsString()) {
                case "player": {
                    assert (player != null);
                    id = id + "." + player.func_110124_au().toString();
                }
            }
        }
        return id;
    }
}

