/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.DialogueType;
import forge.net.mca.entity.ai.brain.VillagerBrain;
import java.util.UUID;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.Nullable;

public class Memories {
    private int hearts;
    private final UUID playerUUID;
    private int interactionFatigue;
    private DialogueType dialogueType;
    private final VillagerBrain<?> brain;
    private long lastSeen;

    public Memories(VillagerBrain<?> brain, long time, UUID uuid) {
        this.brain = brain;
        this.playerUUID = uuid;
        this.dialogueType = DialogueType.UNASSIGNED;
        this.lastSeen = time / 24000L;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int getHearts() {
        return this.hearts;
    }

    public void setHearts(int value) {
        this.hearts = value;
        this.brain.updateMemories(this);
    }

    public void modHearts(int value) {
        this.setHearts(this.hearts += value);
    }

    public int getInteractionFatigue() {
        return this.interactionFatigue;
    }

    public void setInteractionFatigue(int value) {
        this.interactionFatigue = value;
        this.brain.updateMemories(this);
    }

    public void modInteractionFatigue(int value) {
        this.interactionFatigue += value;
        this.brain.updateMemories(this);
    }

    public DialogueType getDialogueType() {
        return this.dialogueType;
    }

    public void setDialogueType(DialogueType dialogueType) {
        this.dialogueType = dialogueType;
        this.brain.updateMemories(this);
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(int lastSeen) {
        this.lastSeen = lastSeen;
        this.brain.updateMemories(this);
    }

    public CompoundNBT toCNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("playerUUID", this.playerUUID);
        nbt.func_74768_a("hearts", this.hearts);
        nbt.func_74768_a("interactionFatigue", this.interactionFatigue);
        nbt.func_74768_a("dialogueType", this.dialogueType.ordinal());
        nbt.func_74772_a("lastSeen", this.lastSeen);
        return nbt;
    }

    public static <E extends MobEntity> Memories fromCNBT(E villager, @Nullable CompoundNBT tag) {
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        Memories memories = new Memories(((VillagerLike)villager).getVillagerBrain(), villager.field_70170_p.func_72820_D(), tag.func_186857_a("playerUUID"));
        memories.hearts = tag.func_74762_e("hearts");
        memories.interactionFatigue = tag.func_74762_e("interactionFatigue");
        memories.dialogueType = DialogueType.byId(tag.func_74762_e("dialogueType"));
        memories.lastSeen = tag.func_74763_f("lastSeen");
        return memories;
    }
}

