/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.EntityWrapper;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.DialogueType;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.resources.API;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public interface Messenger
extends EntityWrapper {
    public static final EntityPredicate CAN_RECEIVE = new EntityPredicate().func_221009_d();

    default public boolean isSpeechImpaired() {
        return false;
    }

    default public boolean isToYoungToSpeak() {
        return false;
    }

    default public void playSpeechEffect() {
    }

    default public DialogueType getDialogueType(PlayerEntity receiver) {
        return DialogueType.UNASSIGNED;
    }

    default public TranslationTextComponent getTranslatable(PlayerEntity target, String phraseId, Object ... params) {
        String targetName;
        if (target.field_70170_p instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)target.field_70170_p;
            targetName = FamilyTree.get(world).getOrEmpty(target.func_110124_au()).map(FamilyTreeNode::getName).filter(n -> !MCA.isBlankString(n)).orElse(target.func_200200_C_().getString());
        } else {
            targetName = target.func_200200_C_().getString();
        }
        Object[] newParams = new Object[params.length + 1];
        System.arraycopy(params, 0, newParams, 1, params.length);
        newParams[0] = targetName;
        String professionString = "";
        if (!this.asEntity().func_70631_g_() && this.asEntity() instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)this.asEntity();
            professionString = "#P" + Registry.field_218370_L.func_177774_c((Object)v.getProfession()).func_110623_a() + ".";
        }
        String personalityString = "";
        if (!this.asEntity().func_70631_g_() && this.asEntity() instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)this.asEntity();
            personalityString = "#E" + v.getVillagerBrain().getPersonality().name() + ".";
        }
        return new TranslationTextComponent(personalityString + professionString + "#T" + this.getDialogueType(target).name() + "." + phraseId, newParams);
    }

    default public void sendChatToAllAround(String phrase, Object ... params) {
        for (PlayerEntity player : this.asEntity().field_70170_p.func_217373_a(CAN_RECEIVE, (LivingEntity)this.asEntity(), this.asEntity().func_174813_aQ().func_186662_g(20.0))) {
            float dist = player.func_70032_d((Entity)this.asEntity());
            this.sendChatMessage(this.getTranslatable(player, phrase, params).func_240699_a_(dist < 10.0f ? TextFormatting.WHITE : TextFormatting.GRAY), (Entity)player);
        }
    }

    default public void sendChatMessage(PlayerEntity target, String phraseId, Object ... params) {
        this.sendChatMessage((IFormattableTextComponent)this.getTranslatable(target, phraseId, params), (Entity)target);
    }

    default public void sendChatMessage(IFormattableTextComponent message, Entity receiver) {
        if (this.isSpeechImpaired()) {
            message = new TranslationTextComponent(API.getRandomSentence("zombie", message.getString()));
        } else if (this.isToYoungToSpeak()) {
            message = new TranslationTextComponent(API.getRandomSentence("baby", message.getString()));
        }
        receiver.func_145747_a((ITextComponent)new StringTextComponent(Config.getInstance().villagerChatPrefix).func_230529_a_(this.asEntity().func_145748_c_()).func_240702_b_(": ").func_230529_a_((ITextComponent)message), this.asEntity().func_110124_au());
        this.playSpeechEffect();
    }

    default public void sendEventMessage(ITextComponent message, PlayerEntity receiver) {
        receiver.func_146105_b(message, true);
    }

    default public void sendEventMessage(ITextComponent message) {
        if (!(this instanceof Entity)) {
            return;
        }
        Messenger.sendEventMessage(((Entity)this).field_70170_p, message);
    }

    public static void sendEventMessage(World world, ITextComponent message) {
        world.func_217369_A().forEach(player -> player.func_146105_b(message, true));
    }
}

