/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum MoveState {
    MOVE("moving"),
    STAY("staying"),
    FOLLOW("following");

    private static final MoveState[] VALUES;
    private static final Map<String, MoveState> REGISTRY;
    private final String friendlyName;

    private MoveState(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public ITextComponent getName() {
        return new TranslationTextComponent("gui.label." + this.friendlyName);
    }

    public static Optional<MoveState> byCommand(String action) {
        return Optional.ofNullable(REGISTRY.get(action.toUpperCase(Locale.ENGLISH)));
    }

    public static MoveState byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return MOVE;
        }
        return VALUES[id];
    }

    static {
        VALUES = MoveState.values();
        REGISTRY = Stream.of(VALUES).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

