/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.server.world.data.BabyTracker;
import forge.net.mca.util.WorldUtils;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.server.ServerWorld;

public class Pregnancy {
    private static final CDataParameter<Boolean> HAS_BABY = CParameter.create("hasBaby", false);
    private static final CDataParameter<Boolean> IS_BABY_MALE = CParameter.create("isBabyMale", false);
    private static final CDataParameter<Integer> BABY_AGE = CParameter.create("babyAge", 0);
    private final VillagerEntityMCA mother;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(HAS_BABY, IS_BABY_MALE, BABY_AGE);
    }

    Pregnancy(VillagerEntityMCA entity) {
        this.mother = entity;
    }

    public boolean isPregnant() {
        return (Boolean)this.mother.getTrackedValue(HAS_BABY);
    }

    public void setPregnant(boolean pregnant) {
        this.mother.setTrackedValue(HAS_BABY, pregnant);
    }

    public int getBabyAge() {
        return (Integer)this.mother.getTrackedValue(BABY_AGE);
    }

    public void setBabyAge(int age) {
        this.mother.setTrackedValue(BABY_AGE, age);
    }

    public Gender getGender() {
        return (Boolean)this.mother.getTrackedValue(IS_BABY_MALE) != false ? Gender.MALE : Gender.FEMALE;
    }

    public void tick() {
        if (!this.isPregnant()) {
            return;
        }
        this.setBabyAge(this.getBabyAge() + 60);
        if (this.getBabyAge() < Config.getInstance().babyItemGrowUpTime) {
            return;
        }
        this.setBabyAge(0);
        this.getFather().ifPresent(father -> {
            this.setPregnant(false);
            VillagerEntityMCA child = this.createChild(this.getGender(), (VillagerEntityMCA)father);
            child.func_70107_b(this.mother.func_226277_ct_(), this.mother.func_226278_cu_(), this.mother.func_226281_cx_());
            WorldUtils.spawnEntity(this.mother.field_70170_p, (MobEntity)child, SpawnReason.BREEDING);
        });
    }

    public boolean tryStartGestation() {
        if (this.isPregnant()) {
            return false;
        }
        return this.getFather().map(father -> {
            if (this.mother.getGenetics().getGender() == Gender.MALE && father.getGenetics().getGender() != Gender.MALE) {
                return father.getRelationships().getPregnancy().tryStartGestation();
            }
            this.setPregnant(true);
            this.mother.setTrackedValue(IS_BABY_MALE, this.mother.field_70170_p.field_73012_v.nextBoolean());
            return true;
        }).orElse(false);
    }

    public VillagerEntityMCA createChild(Gender gender, VillagerEntityMCA partner) {
        VillagerEntityMCA child = (VillagerEntityMCA)gender.getVillagerType().func_200721_a(this.mother.field_70170_p);
        child.getGenetics().combine(partner.getGenetics(), this.mother.getGenetics());
        child.getTraits().inherit(partner.getTraits());
        child.getTraits().inherit(this.mother.getTraits());
        child.func_82227_f(true);
        child.setAgeState(AgeState.TODDLER);
        child.getRelationships().getFamilyEntry().assignParents(this.mother.getRelationships(), partner.getRelationships());
        child.getRelationships().getFamily(2, 0).filter(e -> e instanceof ServerPlayerEntity).map(ServerPlayerEntity.class::cast).forEach(CriterionMCA.FAMILY::trigger);
        return child;
    }

    public VillagerEntityMCA createChild(Gender gender) {
        return this.createChild(gender, this.mother);
    }

    private Optional<VillagerEntityMCA> getFather() {
        return this.mother.getRelationships().getPartner().filter(father -> father instanceof VillagerEntityMCA).map(VillagerEntityMCA.class::cast);
    }

    public void procreate(Entity spouse) {
        int count;
        Random random = this.mother.func_70681_au();
        boolean areTwins = random.nextInt(100) < Config.getInstance().chanceToHaveTwins;
        int n = count = areTwins ? 2 : 1;
        if (spouse instanceof ServerPlayerEntity) {
            CriterionMCA.BABY_CRITERION.trigger((ServerPlayerEntity)spouse, count);
        }
        long seed = random.nextLong();
        for (int i = 0; i < count; ++i) {
            BabyTracker.get((ServerWorld)this.mother.field_70170_p).getPairing(this.mother.func_110124_au(), spouse.func_110124_au()).addChild(state -> {
                ItemStack stack = state.setGender(Gender.getRandom()).setOwner((Entity)this.mother).setSeed(seed).createItem();
                if (!(spouse instanceof PlayerEntity) || !((PlayerEntity)spouse).func_191521_c(stack)) {
                    this.mother.func_213715_ed().func_174894_a(stack);
                }
            });
        }
    }
}

